<?php
$widget->add_render_attribute( 'counter', [
    'class' => 'pxl-counter--value '.$settings['effect'].'',
    'data-duration' => $settings['duration'],
    'data-startnumber' => $settings['starting_number'],
    'data-endnumber' => $settings['ending_number'],
    'data-to-value' => $settings['ending_number'],
    'data-delimiter' => $settings['thousand_separator_char'],
] ); ?>
<div class="pxl-counter pxl-counter3 <?php echo esc_attr($settings['number_style']); ?> <?php echo esc_attr($settings['pxl_animate']); ?>" data-wow-delay="<?php echo esc_attr($settings['pxl_animate_delay']); ?>ms">
    <div class="pxl-counter--inner">
        <div class="pxl-counter--holder ">
            <div class="pxl-counter--number ">
                <span class="pxl-counter--prefix el-empty"><?php echo pxl_print_html($settings['prefix']); ?></span>
                <span <?php pxl_print_html($widget->get_render_attribute_string( 'counter' )); ?>><?php echo esc_html($settings['starting_number']); ?></span>
                <?php if ($settings['icon_plus_ct'] === 'true') : ?>
                    <span class="pxl-icon--plus-ct">
                        <?php echo "+"; ?>
                    </span>
                <?php endif; ?>
                <?php if(!empty($settings['suffix'])) : ?>
                    <span class="pxl-counter--suffix"><?php echo pxl_print_html($settings['suffix']); ?></span>
                <?php endif; ?>
            </div>
        </div>
        <?php if(!empty($settings['title'])) : ?>
            <div class="pxl-counter--title <?php echo esc_attr($settings['title_w']); ?>"><?php echo pxl_print_html($settings['title']); ?></div>
        <?php endif; ?>
    </div>
</div>