<?php
$is_new = \Elementor\Icons_Manager::is_migration_allowed();
if(isset($settings['icons']) && !empty($settings['icons']) && count($settings['icons'])): ?>
    <div class="pxl-icon-list pxl-icon1 <?php echo esc_attr($settings['animate_hover'].' '.$settings['content_direction'].' '.$settings['pxl_animate']); ?>" data-wow-delay="<?php echo esc_attr($settings['pxl_animate_delay']); ?>ms">
        <?php foreach ($settings['icons'] as $key => $value):
            $label = isset($value['label']) ? $value['label'] : '';
            $label_position = isset($value['label_position']) ? $value['label_position'] : '';
            $icon_key = $widget->get_repeater_setting_key( 'pxl_icon', 'icons', $key );
            $widget->add_render_attribute( $icon_key, [
                'class' => $value['pxl_icon'],
                'aria-hidden' => 'true',
            ] );
            ?>

            <?php if ( ! empty( $value['pxl_icon'] ) ) : ?>
                <a <?php konstruc_render_link_attributes($value['icon_link']); ?> class="elementor-repeater-item-<?php echo esc_attr($value['_id']); ?> <?php echo esc_attr($label_position); ?>">

                    <?php if ( $is_new ):
                        \Elementor\Icons_Manager::render_icon( $value['pxl_icon'], [ 'aria-hidden' => 'true' ] );
                    elseif(!empty($value['pxl_icon'])): ?>
                        <i class="<?php echo esc_attr( $value['pxl_icon'] ); ?>" aria-hidden="true"></i>
                    <?php endif; ?>
                    <?php if(!empty($label)) : ?>
                        <span><?php echo pxl_print_html($label); ?></span>
                    <?php endif; ?>
                    
                </a>
            <?php endif; ?>
        <?php endforeach; ?>
    </div>
    <?php endif; ?>