<?php 
    $button_text = !empty($settings['btn_text']) ? $settings['btn_text'] : 'Read more';
 ?>

<div class="pxl-icon-box pxl-icon-box3 <?php echo esc_attr($settings['animate_hover'].' '.$settings['pxl_animate']); ?>" data-wow-delay="<?php echo esc_attr($settings['pxl_animate_delay']); ?>ms">
    <div class="pxl-item--inner">

      <?php if ( $settings['icon_type'] == 'icon' && !empty($settings['pxl_icon']['value']) ) : ?>
        <div class="pxl-item--icon">
            <?php \Elementor\Icons_Manager::render_icon( $settings['pxl_icon'], [ 'aria-hidden' => 'true', 'class' => '' ], 'i' ); ?>
        </div>
    <?php endif; ?>
    <?php if ( $settings['icon_type'] == 'image' && !empty($settings['icon_image']['id']) ) : ?>
        <div class="pxl-item--icon pxl-mr-25">
            <?php $img_icon  = pxl_get_image_by_size( array(
                'attach_id'  => $settings['icon_image']['id'],
                'thumb_size' => 'full',
            ) );
            $thumbnail_icon    = $img_icon['thumbnail'];
            echo pxl_print_html($thumbnail_icon); ?>
        </div>
    <?php endif; ?>
    <div class="pxl-item--meta">
        <<?php echo esc_attr($settings['title_tag']); ?> class="pxl-item--title">
        <?php echo pxl_print_html($settings['title']); ?>
        </<?php echo esc_attr($settings['title_tag']); ?>>
        <div class="pxl-item--description"><?php echo pxl_print_html($settings['desc']); ?></div>
    </div>

    <a class="btn-readmore pxl-d-flex" <?php konstruc_render_link_attributes($settings['item_link']); ?>>
        <span class="pxl-btn--text pxl-d-flex">
            <?php pxl_print_html($button_text); ?>
            <svg xmlns="http://www.w3.org/2000/svg" width="16" height="16" viewBox="0 0 16 16" fill="none">
                <path d="M2 8H14M8 2V14" stroke="currentColor" stroke-width="2.5" stroke-linecap="round" stroke-linejoin="round"/>
            </svg>
        </span>
        <span class="pxl-icon--arrow pxl-d-flex">
            <svg xmlns="http://www.w3.org/2000/svg" width="20" height="14" viewBox="0 0 20 14" fill="none">
                <path d="M0.000139952 7.86247L0 5.86257H16.1719L12.2222 1.91281L13.6364 0.498596L20.0004 6.86257L13.6364 13.2266L12.2222 11.8123L16.172 7.86257L0.000139952 7.86247Z" fill="currentColor"/>
            </svg>
        </span>
    </a>

</div>
</div>