<?php 
$button_text = !empty($settings['btn_text']) ? $settings['btn_text'] : 'Read more';
?>


<div class="pxl-icon-box pxl-icon-box5 <?php echo esc_attr($settings['animate_hover'].' '.$settings['style_layout'].' '.$settings['pxl_animate']); ?>" data-wow-delay="<?php echo esc_attr($settings['pxl_animate_delay']); ?>ms">
    <div class="pxl-item--inner">
        <a class="pxl-item-link" <?php konstruc_render_link_attributes($settings['item_link']); ?>>
        </a>
        <?php if ( $settings['icon_type'] == 'icon' && !empty($settings['pxl_icon']['value']) ) : ?>
            <div class="pxl-icon--content">
                <div class="pxl-item--icon">
                    <?php \Elementor\Icons_Manager::render_icon( $settings['pxl_icon'], [ 'aria-hidden' => 'true', 'class' => '' ], 'i' ); ?>
                </div>
                <?php if (!empty($settings['number'])) : ?>
                    <div class="pxl-item--number <?php echo pxl_print_html($settings['number_position']); ?>">
                        <?php echo pxl_print_html($settings['input_number']); ?>
                    </div>
                <?php endif; ?>
            </div>
        <?php endif; ?>
        <?php if ( $settings['icon_type'] == 'image' && !empty($settings['icon_image']['id']) ) : ?>
            <div class="pxl-icon--content">
                <div class="pxl-item--icon pxl-mr-25">
                    <?php $img_icon  = pxl_get_image_by_size( array(
                        'attach_id'  => $settings['icon_image']['id'],
                        'thumb_size' => 'full',
                    ) );
                    $thumbnail_icon    = $img_icon['thumbnail'];
                    echo pxl_print_html($thumbnail_icon); ?>
                </div>
                <div class="pxl-item--number <?php echo pxl_print_html($settings['number_position']); ?>">
                    <?php echo pxl_print_html($settings['input_number']); ?>
                </div>
            </div>
        <?php endif; ?>
        <div class="pxl-item--meta">
            <<?php echo esc_attr($settings['title_tag']); ?> class="pxl-item--title">
            <?php echo pxl_print_html($settings['title']); ?>
            </<?php echo esc_attr($settings['title_tag']); ?>>
            <div class="pxl-item--description"><?php echo pxl_print_html($settings['desc']); ?></div>
        </div>

        <a class="btn-readmore pxl-d-flex" <?php konstruc_render_link_attributes($settings['item_link']); ?>>
            <span class="pxl-btn--text pxl-d-flex">
                <?php pxl_print_html($button_text); ?>
            </span>
            <svg xmlns="http://www.w3.org/2000/svg" width="16" height="16" viewBox="0 0 16 16" fill="none">
                <path d="M2 8H14M8 2V14" stroke="currentColor" stroke-width="2.5" stroke-linecap="round" stroke-linejoin="round"/>
            </svg>
        </a>

    </div>
</div>