<?php if(isset($settings['language']) && !empty($settings['language']) && count($settings['language'])): ?>
<div class="pxl-language-switch <?php echo esc_attr($settings['pxl_animate']); ?> <?php echo esc_attr($settings['style']); ?>" data-wow-delay="<?php echo esc_attr($settings['pxl_animate_delay']); ?>ms">
    <div class="language">

        <div class="language-first"> 
            <?php if ($settings['style'] =='default'): ?>
                <?php echo esc_html__('English','konstruc') ?> <i class="caseicon-angle-arrow-down"></i></div>
            <?php endif ?>
            <?php if ($settings['style'] =='style-2'): ?>
                <?php echo esc_html__('En','konstruc') ?> <i class="caseicon-angle-arrow-down"></i></div>
            <?php endif ?>
            <?php if ($settings['style'] =='style-3'): ?>
                <?php echo esc_html__('EN','konstruc') ?> <i class="caseicon-angle-arrow-down"></i></div>
            <?php endif ?>
        </div>
        <div class="list-language">
            <?php foreach ($settings['language'] as $key => $value): ?>

                <?php if(!empty($value['name'])) : ?>
                    <div class="pxl--item pxl-d-flex">
                        <a <?php konstruc_render_link_attributes($value['link']); ?>>
                            <?php if ( !empty($value['pxl_icon']['value']) ) : ?>
                                    <?php \Elementor\Icons_Manager::render_icon( $value['pxl_icon'], [ 'aria-hidden' => 'true', 'class' => '' ], 'i' ); ?>
                            <?php endif; ?>
                            <?php echo esc_attr($value['name']); ?>
                        </a>
                    </div>
                <?php endif; ?>
            <?php endforeach; ?>
        </div>
    </div>
    <?php endif; ?>