<?php if(isset($settings['lists']) && !empty($settings['lists']) && count($settings['lists'])): ?>
<div class="pxl-list pxl-list1 <?php echo esc_attr($settings['pxl_animate']); ?>" data-wow-delay="<?php echo esc_attr($settings['pxl_animate_delay']); ?>ms">
    <h3 class="pxl-item--title pxl-empty"><?php echo pxl_print_html($settings['title']); ?></h3>
    <?php foreach ($settings['lists'] as $key => $value): ?>
        <div class="pxl--item">
            <?php if ( !empty($settings['pxl_icon']['value']) ) : ?>
                <div class="pxl-item--icon">
                    <?php \Elementor\Icons_Manager::render_icon( $settings['pxl_icon'], [ 'aria-hidden' => 'true', 'class' => '' ], 'i' ); ?>
                </div>
            <?php endif; ?>
            <?php if(!empty($value['content'])) : ?>
                <div class="pxl-item-content">
                    <?php if ($value['link']) : ?>
                        <a <?php konstruc_render_link_attributes($value['link']); ?>>
                        <?php endif; ?>
                            <?php echo pxl_print_html($value['content'])?>
                        <?php if ($value['link']) : ?>
                        </a>
                    <?php endif; ?>
                </div>
            <?php endif; ?>
        </div>
    <?php endforeach; ?>
</div>
<?php endif; ?>