<?php
$post_id = get_the_ID();
$post_type = get_post_type();
$taxonomy_category = $post_type === 'post' ? 'category' : $post_type.'-category';
$taxonomy_tag = $post_type === 'post' ? 'post_tag' : $post_type.'-tags';


if(isset($settings['post_box']) && !empty($settings['post_box']) && count($settings['post_box'])): ?>
    <div class="pxl-post-box pxl-post-box1">
        <?php if (!empty($settings['heading_box'])) : ?>
            <h3 class="pxl-item--heading"> 
                <?php pxl_print_html($settings['heading_box']); ?>
            </h3>
        <?php endif; ?>

        <div class="pxl-item--content">
            <?php foreach ($settings['post_box'] as $key => $value):
                $title = isset($value['title']) ? $value['title'] : '';
                $data_field = isset($value['data_field']) ? $value['data_field'] : '';


                ?>
                <div class="pxl--item">
                    <div class="pxl-item--title"> 
                        <?php pxl_print_html($title); ?>
                    </div>
                    <?php if ($data_field == 'category'): ?>
                        <div class="data-field data-categories">
                           <?php the_terms( $post_id, $taxonomy_category, '', ', '); ?>
                       </div>
                   <?php elseif($data_field == 'author') : ?>
                    <div class="data-field data-author">
                     <?php $author_id = get_post_field ('post_author', $post_id); ?> 
                     <a href="<?php echo esc_url(get_author_posts_url($author_id)); ?>" class="pxl-author-link">
                        <?php echo esc_attr(get_the_author_meta('display_name', $author_id)); ?>
                    </a>
                </div>
            <?php elseif($data_field == 'date') : ?>
                <div class="data-field data-date">
                    <?php echo get_the_date( 'j F, Y', $post_id); ?>
                </div>
            <?php elseif($data_field == 'tags') : ?>
                <div class="data-field data-categories">
                    <?php the_terms( $post_id, $taxonomy_tag, '', ', '); ?>
                </div>
            <?php else : ?>
                <div class="data-field pxl-custom--text">
                    <?php pxl_print_html($data_field); ?>
                </div>
            <?php endif; ?>
        </div>
    <?php endforeach; ?>
</div>
</div>
<?php endif; ?>