<?php
$html_id = pxl_get_element_id($settings);
$select_post_by = $widget->get_setting('select_post_by', '');
$source = $post_ids = [];
if($select_post_by === 'post_selected'){
    $post_ids = $widget->get_setting('source_'.$settings['post_type'].'_post_ids', '');
}else{
    $source  = $widget->get_setting('source_'.$settings['post_type'], '');
}
$orderby = $widget->get_setting('orderby', 'date');
$order = $widget->get_setting('order', 'desc');
$limit = $widget->get_setting('limit', 6);
$settings['layout']    = $settings['layout_'.$settings['post_type']];
extract(pxl_get_posts_of_grid('post', [
    'source' => $source,
    'orderby' => $orderby,
    'order' => $order,
    'limit' => $limit,
    'post_ids' => $post_ids,
]));

$pxl_animate = $widget->get_setting('pxl_animate', '');
$col_xs = $widget->get_setting('col_xs', '');
$col_sm = $widget->get_setting('col_sm', '');
$col_md = $widget->get_setting('col_md', '');
$col_lg = $widget->get_setting('col_lg', '');
$col_xl = $widget->get_setting('col_xl', '');
$col_xxl = $widget->get_setting('col_xxl', '');
if($col_xxl == 'inherit') {
    $col_xxl = $col_xl;
}
$slides_to_scroll = $widget->get_setting('slides_to_scroll', '');

$arrows = $widget->get_setting('arrows', false);
$pagination = $widget->get_setting('pagination', false);
$pagination_type = $widget->get_setting('pagination_type', 'bullets');
$pause_on_hover = $widget->get_setting('pause_on_hover', false);
$autoplay = $widget->get_setting('autoplay', false);
$autoplay_speed = $widget->get_setting('autoplay_speed', '5000');
$infinite = $widget->get_setting('infinite', false);
$speed = $widget->get_setting('speed', '500');
$center = $widget->get_setting('center', false);
$drap = $widget->get_setting('drap', false);

$img_size = $widget->get_setting('img_size');
$show_excerpt = $widget->get_setting('show_excerpt');
$show_date = $widget->get_setting('show_date');
$num_words = $widget->get_setting('num_words');
$show_button = $widget->get_setting('show_button');
$button_text = $widget->get_setting('button_text');
$show_category = $widget->get_setting('show_category');
$show_author = $widget->get_setting('show_author');
$show_comment = $widget->get_setting('show_comment');

$opts = [
    'slide_direction'               => 'horizontal',
    'slide_percolumn'               => 1, 
    'slide_percolumnfill'           => 1, 
    'slide_mode'                    => 'slide', 
    'slides_to_show'                => (int)$col_xl, 
    'slides_to_show_xxl'            => (int)$col_xxl, 
    'slides_to_show_lg'             => (int)$col_lg, 
    'slides_to_show_md'             => (int)$col_md, 
    'slides_to_show_sm'             => (int)$col_sm, 
    'slides_to_show_xs'             => (int)$col_xs, 
    'slides_to_scroll'              => (int)$slides_to_scroll,  
    'slides_gutter'                 => 30, 
    'arrow'                         => (bool)$arrows,
    'pagination'                    => (bool)$pagination,
    'pagination_type'               => $pagination_type,
    'autoplay'                      => (bool)$autoplay,
    'pause_on_hover'                => (bool)$pause_on_hover,
    'pause_on_interaction'          => true,
    'delay'                         => (int)$autoplay_speed,
    'loop'                          => (bool)$infinite,
    'speed'                         => (int)$speed,
    'center'                        => (bool)$center,
];

$widget->add_render_attribute( 'carousel', [
    'class'         => 'pxl-swiper-container',
    'dir'           => is_rtl() ? 'rtl' : 'ltr',
    'data-settings' => wp_json_encode($opts)
]); ?>

<?php if (is_array($posts)): ?>
    <div class="pxl-post pxl-swiper-slider pxl-post-carousel pxl-post-layout-post-4 " <?php if($drap !== false): ?>data-cursor-drap="<?php echo esc_html('DRAG', 'konstruc'); ?>"<?php endif; ?>>
        <div class="pxl-carousel-inner">
            <div <?php pxl_print_html($widget->get_render_attribute_string( 'carousel' )); ?>>
                <div class="pxl-swiper-wrapper">
                    <?php
                    $image_size = !empty($img_size) ? $img_size : '512x282';
                    foreach ($posts as $post):
                        $img_id       = get_post_thumbnail_id( $post->ID );
                        $author = get_user_by('id', $post->post_author);
                        $description_post = get_post_meta($post->ID, 'description_post', true);
                        ?>
                        <div class="pxl-swiper-slide">
                            <div class="pxl-post--inner">
                                <?php if (has_post_thumbnail($post->ID) && wp_get_attachment_image_src(get_post_thumbnail_id($post->ID), false)):
                                $img_id = get_post_thumbnail_id($post->ID);
                                $img          = pxl_get_image_by_size( array(
                                    'attach_id'  => $img_id,
                                    'thumb_size' => $image_size,
                                ) );
                                $thumbnail    = $img['thumbnail']; 
                                ?>
                                <div class="pxl-post--featured">
                                    <a href="<?php echo esc_url(get_permalink( $post->ID )); ?>">
                                        <?php echo wp_kses_post($thumbnail); ?>
                                    </a>
                                </div>
                                <div class="pxl-post--meta">
                                    <div class="pxl-info--post">
                                        <?php if ($show_author == 'true'): ?>
                                            <span class="post-author pxl-d-flex">
                                                <svg xmlns="http://www.w3.org/2000/svg" width="22" height="22" viewBox="0 0 22 22" fill="none">
                                                  <g clip-path="url(#clip0_514_7605)">
                                                    <path d="M18.7782 3.22182C16.7006 1.14421 13.9382 0 11 0C8.06184 0 5.29942 1.14421 3.22182 3.22182C1.14421 5.29942 0 8.06184 0 11C0 13.9382 1.14421 16.7006 3.22182 18.7782C5.29942 20.8558 8.06184 22 11 22C13.9382 22 16.7006 20.8558 18.7782 18.7782C20.8558 16.7006 22 13.9382 22 11C22 8.06184 20.8558 5.29942 18.7782 3.22182ZM4.77406 18.4464C5.13728 15.321 7.82434 12.9081 11 12.9081C12.6741 12.9081 14.2483 13.5603 15.4325 14.7443C16.4329 15.7449 17.0638 17.0512 17.2261 18.4462C15.5392 19.8589 13.3673 20.7109 11 20.7109C8.63269 20.7109 6.46092 19.8591 4.77406 18.4464ZM11 11.5804C9.15788 11.5804 7.65901 10.0815 7.65901 8.23943C7.65901 6.39714 9.15788 4.89844 11 4.89844C12.8421 4.89844 14.341 6.39714 14.341 8.23943C14.341 10.0815 12.8421 11.5804 11 11.5804ZM18.3356 17.3565C18.0071 16.0322 17.3221 14.8111 16.3439 13.8329C15.5517 13.0407 14.6144 12.4463 13.5922 12.0739C14.821 11.2405 15.6301 9.83263 15.6301 8.23943C15.6301 5.68648 13.5529 3.60938 11 3.60938C8.44705 3.60938 6.36995 5.68648 6.36995 8.23943C6.36995 9.83347 7.17964 11.2419 8.40945 12.0751C7.46901 12.4178 6.59872 12.9477 5.84996 13.6453C4.76567 14.655 4.01271 15.9426 3.66359 17.3555C2.18503 15.651 1.28906 13.4282 1.28906 11C1.28906 5.64536 5.64536 1.28906 11 1.28906C16.3546 1.28906 20.7109 5.64536 20.7109 11C20.7109 13.4287 19.8146 15.652 18.3356 17.3565Z" fill="currentColor"/>
                                                </g>
                                                <defs>
                                                    <clipPath id="clip0_514_7605">
                                                      <rect width="22" height="22" fill="white"/>
                                                  </clipPath>
                                              </defs>
                                          </svg>
                                          <span><?php echo esc_html__('By', 'konstruc'); ?>&nbsp;<?php the_author_posts_link(); ?></span>
                                      </span>
                                  <?php endif; ?>

                                  <?php if ($show_comment == 'true'): ?>
                                    <span class="post-comments  pxl-d-flex">
                                        <svg xmlns="http://www.w3.org/2000/svg" width="22" height="22" viewBox="0 0 22 22" fill="none">
                                            <path d="M18.4662 1.48242H3.51232C1.94883 1.48242 0.676758 2.75424 0.676758 4.31798V13.4694C0.676758 15.0297 1.94329 16.2995 3.50225 16.305V20.4578L9.47033 16.305H18.4662C20.0297 16.305 21.3018 15.0329 21.3018 13.4694V4.31798C21.3018 2.75424 20.0297 1.48242 18.4662 1.48242ZM20.0933 13.4694C20.0933 14.3665 19.3634 15.0965 18.4662 15.0965H9.09116L4.71074 18.1447V15.0965H3.51232C2.61514 15.0965 1.88525 14.3665 1.88525 13.4694V4.31798C1.88525 3.42067 2.61514 2.69092 3.51232 2.69092H18.4662C19.3634 2.69092 20.0933 3.42067 20.0933 4.31798V13.4694Z" fill="currentColor"/>
                                            <path d="M6.19727 5.75293H15.7819V6.96143H6.19727V5.75293Z" fill="currentColor"/>
                                            <path d="M6.19727 8.33105H15.7819V9.53955H6.19727V8.33105Z" fill="currentColor"/>
                                            <path d="M6.19727 10.9092H15.7819V12.1177H6.19727V10.9092Z" fill="currentColor"/>
                                        </svg>
                                        <a href="<?php echo esc_url(get_permalink( $post->ID )); ?>">
                                            <span><?php comments_number(esc_html__('No Comment', 'konstruc'), esc_html__(' 1 Comment', 'konstruc'), esc_html__('%  Comments', 'konstruc'),$post->ID); ?></span>
                                        </a>
                                    </span>
                                <?php endif ?>
                            </div>
                            <h3 class="pxl-post--title"><a href="<?php echo esc_url(get_permalink( $post->ID )); ?>"><?php echo esc_html__(get_the_title($post->ID)); ?></a></h3>

                            <?php if($show_excerpt == 'true'): ?>
                                <div class="pxl-post--content">
                                    <?php
                                    echo wp_trim_words( $description_post, $num_words, null );
                                    ?>
                                </div>
                            <?php endif; ?>

                            <?php if($show_button == 'true') : ?>
                                <div class="pxl-post--readmore">
                                    <a class="btn-readmore" href="<?php echo esc_url(get_permalink( $post->ID )); ?>">
                                        <span><?php if(!empty($button_text)) {
                                            echo esc_attr($button_text);
                                        } else {
                                            echo esc_html__('Read More', 'konstruc');
                                        } ?></span>
                                        <div class="pxl-icon--plus"></div>
                                    </a>
                                </div>
                            <?php endif; ?>
                        </div>

                    <?php endif; ?>
                </div>
            </div>
        <?php endforeach; ?>
    </div> 
</div>

</div>
<?php if($pagination !== false): ?>
    <div class="pxl-swiper-dots style-1"></div>
<?php endif; ?>

<?php if($arrows !== false): ?>
    <div class="pxl-swiper-arrow-wrap style-2">
        <div class="pxl-swiper-arrow pxl-swiper-arrow-prev">
            <svg width="20" height="38" xmlns="http://www.w3.org/2000/svg">
             <g>
              <path stroke="#000" id="svg_3" d="m20.21811,38.88319l-19.7456,-20.72803" opacity="undefined" stroke-linecap="undefined" stroke-linejoin="undefined" fill="none"/>
              <path stroke="#000" id="svg_5" d="m20.00751,-0.49215l-19.55631,19.26847" opacity="undefined" stroke-linecap="undefined" stroke-linejoin="undefined" fill="none"/>
          </g>
      </svg>
  </div>
  <div class="pxl-swiper-arrow pxl-swiper-arrow-next">
    <svg width="20" height="38" xmlns="http://www.w3.org/2000/svg">
     <g>
      <path stroke="#000" id="svg_3" d="m20.21811,38.88319l-19.7456,-20.72803" opacity="undefined" stroke-linecap="undefined" stroke-linejoin="undefined" fill="none"/>
      <path stroke="#000" id="svg_5" d="m20.00751,-0.49215l-19.55631,19.26847" opacity="undefined" stroke-linecap="undefined" stroke-linejoin="undefined" fill="none"/>
  </g>
</svg>
</div>
</div>
<?php endif; ?>
</div>
<?php endif; ?>