<?php
$col_xs = $widget->get_setting('col_xs', '1');
$col_sm = $widget->get_setting('col_sm', '1');
$col_md = $widget->get_setting('col_md', '1');
$col_lg = $widget->get_setting('col_lg', '1');
$col_xl = $widget->get_setting('col_xl', '1');
$col_xxl = $widget->get_setting('col_xxl', '1');
if($col_xxl == 'inherit') {
    $col_xxl = $col_xl;
}
$slides_to_scroll = $widget->get_setting('slides_to_scroll');
$pagination = $widget->get_setting('pagination', false);
$pagination_type = $widget->get_setting('pagination_type', 'bullets');
$pause_on_hover = $widget->get_setting('pause_on_hover', false);
$autoplay = $widget->get_setting('autoplay', false);
$autoplay_speed = $widget->get_setting('autoplay_speed', 5000);
$infinite = $widget->get_setting('infinite', false);  
$arrows = $widget->get_setting('arrows', false);  
$speed = $widget->get_setting('speed', 500);
$img_size = $settings['img_size'] ?? 'full';
$opts = [
    'slide_direction'               => 'horizontal',
    'slide_percolumn'               => 1, 
    'slide_mode'                    => 'fade', 
    'slides_to_show'                => (int)$col_xl, 
    'slides_to_show_xxl'            => (int)$col_xxl, 
    'slides_to_show_lg'             => (int)$col_lg, 
    'slides_to_show_md'             => (int)$col_md, 
    'slides_to_show_sm'             => (int)$col_sm, 
    'slides_to_show_xs'             => (int)$col_xs, 
    'slides_to_scroll'              => (int)$slides_to_scroll,
    'arrow'                         => (bool)$arrows,
    'pagination'                    => (bool)$pagination,
    'pagination_type'               => $pagination_type,
    'autoplay'                      => (bool)$autoplay,
    'pause_on_hover'                => (bool)$pause_on_hover,
    'pause_on_interaction'          => true,
    'delay'                         => (int)$autoplay_speed,
    'loop'                          => (bool)$infinite,
    'speed'                         => (int)$speed
];
$widget->add_render_attribute( 'carousel', [
    'class'         => 'pxl-swiper-container',
    'dir'           => is_rtl() ? 'rtl' : 'ltr',
    'data-settings' => wp_json_encode($opts)
]);
if(isset($settings['slide_home']) && !empty($settings['slide_home']) && count($settings['slide_home'])): ?>
    <div class="pxl-swiper-slider pxl-slide--home pxl-slide--home4">
        <div class="pxl-carousel-inner">
            <div <?php pxl_print_html($widget->get_render_attribute_string( 'carousel' )); ?>>
                <div class="pxl-swiper-wrapper">
                 <?php foreach ($settings['slide_home'] as $key => $value):
                    $image_id_1 = $value['image_1']['id'] ?? '';
                    $image_id_2 = $value['image_2']['id'] ?? '';

                    $rating_text = isset($value['rating_text']) ? $value['rating_text'] : '';
                    $title_box = isset($value['title_box']) ? $value['title_box'] : '';
                    $description = isset($value['description']) ? $value['description'] : '';
                    $heading = $widget->parse_text_editor( $value['heading'] ); 
                    $text_button = isset($value['text_button']) ? $value['text_button'] : '';
                    $text_button_2 = isset($value['text_button_2']) ? $value['text_button_2'] : '';
                    $button_link = isset($value['button_link']) ? $value['button_link'] : '';
                    $button_link_2 = isset($value['button_link2']) ? $value['button_link2'] : '';


                    ?>
                    <div class="pxl-swiper-slide elementor-repeater-item-<?php echo esc_attr($value['_id']); ?>">
                        <div class="pxl-item--overlay"></div>
                        <div class="pxl-item--inner <?php echo esc_attr($settings['pxl_animate']); ?>" data-wow-delay="<?php echo esc_attr($settings['pxl_animate_delay']); ?>ms">

                            <div class="pxl-item--content">
                                <div class="pxl-box--heading">

                                    <div class="pxl-box--rating">
                                        <div class="pxl-rating--author">
                                            <?php 
                                            $thumbnail_1 = konstruc_get_thumbnail($image_id_1, $img_size); 
                                            $thumbnail_2 = konstruc_get_thumbnail($image_id_2, $img_size); 
                                            echo pxl_print_html($thumbnail_1);
                                            echo pxl_print_html($thumbnail_2);
                                            ?>

                                        </div>
                                        <div class="pxl-rating--content">
                                            <div class="pxl-rating--text">
                                                <div class="pxl-icon--star">
                                                    <svg xmlns="http://www.w3.org/2000/svg" width="17" height="16" viewBox="0 0 17 16" fill="none">
                                                        <path d="M7.54894 0.927052C7.8483 0.0057416 9.1517 0.00573945 9.45106 0.92705L10.6329 4.56434C10.7668 4.97636 11.1507 5.25532 11.5839 5.25532H15.4084C16.3771 5.25532 16.7799 6.49494 15.9962 7.06434L12.9021 9.31231C12.5516 9.56695 12.405 10.0183 12.5389 10.4303L13.7207 14.0676C14.02 14.9889 12.9656 15.7551 12.1818 15.1857L9.08779 12.9377C8.7373 12.6831 8.2627 12.6831 7.91222 12.9377L4.81815 15.1857C4.03444 15.7551 2.97996 14.9889 3.27931 14.0676L4.46114 10.4303C4.59501 10.0183 4.44835 9.56695 4.09787 9.31231L1.00381 7.06434C0.220092 6.49494 0.622867 5.25532 1.59159 5.25532H5.41606C5.84929 5.25532 6.23324 4.97636 6.36712 4.56434L7.54894 0.927052Z" fill="currentColor"/>
                                                    </svg>
                                                </div>
                                                <?php pxl_print_html($rating_text); ?>
                                            </div>
                                            <div class="pxl-rating--title">
                                                <?php pxl_print_html($title_box); ?>
                                            </div>
                                        </div>
                                    </div>

                                    <?php if (!empty($heading)) : ?>
                                        <h1 class="pxl--heading">
                                            <?php echo pxl_print_html($heading); ?>
                                        </h1>
                                    <?php endif; ?>
                                </div>


                                

                                <?php if (!empty($description)) : ?>
                                    <div class="pxl--description">
                                        <?php echo pxl_print_html($description); ?>
                                    </div>
                                <?php endif; ?>

                                <?php if (!empty($text_button)) : ?>
                                    <div class="pxl-box--button">
                                        <a class="btn pxl-text--button pxl-btn--1 <?php echo pxl_print_html($settings['btn_text_effect']); ?>" <?php konstruc_render_link_attributes($button_link); ?>>
                                            <span class="pxl--btn-text" data-text="<?php echo esc_attr($text_button); ?>">
                                                <?php if($settings['btn_text_effect'] == 'btn-text-nina' || $settings['btn_text_effect'] == 'btn-text-nanuk') {
                                                    $chars = preg_split('//u', $text_button, -1, PREG_SPLIT_NO_EMPTY);

                                                    foreach ($chars as $value) {
                                                        if($value == ' ') {
                                                            echo '<span class="spacer">&nbsp;</span>';
                                                        } else {
                                                            echo '<span>' . htmlspecialchars($value) . '</span>';
                                                        }
                                                    }
                                                } else {
                                                    echo pxl_print_html($text_button);
                                                }
                                                ?>
                                            </span>
                                            <span class="pxl--btn-icon">
                                                <svg xmlns="http://www.w3.org/2000/svg" width="10" height="10" viewBox="0 0 10 10" fill="none">
                                                    <path d="M8.33622 2.84025L1.17647 10L0 8.82354L7.15975 1.66378H0.849212V0H10V9.15081H8.33622V2.84025Z" fill="currentColor"/>
                                                </svg>
                                            </span>
                                        </a>
                                        <a <?php konstruc_render_link_attributes($button_link_2); ?> class="btn pxl-text--button pxl-btn--2 <?php echo pxl_print_html($settings['btn_text_effect']); ?>" >
                                            <span class="pxl--btn-text" data-text="<?php echo esc_attr($text_button_2); ?>">
                                                <?php if($settings['btn_text_effect'] == 'btn-text-nina' || $settings['btn_text_effect'] == 'btn-text-nanuk') {
                                                    $chars = preg_split('//u', $text_button_2, -1, PREG_SPLIT_NO_EMPTY);

                                                    foreach ($chars as $value) {
                                                        if($value == ' ') {
                                                            echo '<span class="spacer">&nbsp;</span>';
                                                        } else {
                                                            echo '<span>' . htmlspecialchars($value) . '</span>';
                                                        }
                                                    }
                                                } else {
                                                    echo pxl_print_html($text_button_2);
                                                }
                                                ?>
                                            </span>
                                            <span class="pxl--btn-icon">
                                                <svg xmlns="http://www.w3.org/2000/svg" width="10" height="10" viewBox="0 0 10 10" fill="none">
                                                    <path d="M8.33622 2.84025L1.17647 10L0 8.82354L7.15975 1.66378H0.849212V0H10V9.15081H8.33622V2.84025Z" fill="currentColor"/>
                                                </svg>
                                            </span>
                                        </a>
                                    </div>
                                <?php endif; ?>
                            </div>


                        </div>
                    </div>
                <?php endforeach; ?>
            </div>
        </div>

        
        <?php if($arrows !== false): ?>
            <div class="pxl-swiper-arrow-wrap style-1">
                <div class="pxl-swiper-arrow pxl-swiper-arrow-prev"><i class="caseicon-long-arrow-right-three" style="transform: scalex(-1);"></i></div>
                <div class="pxl-swiper-arrow pxl-swiper-arrow-next"><i class="caseicon-long-arrow-right-three"></i></div>
            </div>
        <?php endif; ?>
    </div>
</div>
<?php endif; ?>
