<?php
$col_xs = $widget->get_setting('col_xs', '');
$col_sm = $widget->get_setting('col_sm', '');
$col_md = $widget->get_setting('col_md', '');
$col_lg = $widget->get_setting('col_lg', '');
$col_xl = $widget->get_setting('col_xl', '');
$col_xxl = $widget->get_setting('col_xxl', '');
if($col_xxl == 'inherit') {
    $col_xxl = $col_xl;
}
$slides_to_scroll = $widget->get_setting('slides_to_scroll');
$arrows = $widget->get_setting('arrows', false);  
$pagination = $widget->get_setting('pagination', false);
$pagination_type = $widget->get_setting('pagination_type', 'bullets');
$pause_on_hover = $widget->get_setting('pause_on_hover', false);
$autoplay = $widget->get_setting('autoplay', false);
$autoplay_speed = $widget->get_setting('autoplay_speed', '5000');
$infinite = $widget->get_setting('infinite', false);  
$speed = $widget->get_setting('speed', '500');
$drap = $widget->get_setting('drap', false);  
$opts = [
    'slide_direction'               => 'horizontal',
    'slide_percolumn'               => 1, 
    'slide_mode'                    => 'slide', 
    'slides_to_show'                => (int)$col_xl,
    'slides_to_show_xxl'            => (int)$col_xxl, 
    'slides_to_show_lg'             => (int)$col_lg, 
    'slides_to_show_md'             => (int)$col_md, 
    'slides_to_show_sm'             => (int)$col_sm, 
    'slides_to_show_xs'             => (int)$col_xs, 
    'slides_to_scroll'              => (int)$slides_to_scroll,
    'arrow'                         => (bool)$arrows,
    'pagination'                    => (bool)$pagination,
    'pagination_type'               => $pagination_type,
    'autoplay'                      => (bool)$autoplay,
    'pause_on_hover'                => (bool)$pause_on_hover,
    'pause_on_interaction'          => true,
    'delay'                         => (int)$autoplay_speed,
    'loop'                          => (bool)$infinite,
    'speed'                         => (int)$speed
];
$widget->add_render_attribute( 'carousel', [
    'class'         => 'pxl-swiper-container',
    'dir'           => is_rtl() ? 'rtl' : 'ltr',
    'data-settings' => wp_json_encode($opts)
]);
?>
<?php if(isset($settings['team']) && !empty($settings['team']) && count($settings['team'])): 
$image_size = !empty($settings['img_size']) ? $settings['img_size'] : '424x470'; ?>
<div class="pxl-swiper-slider pxl-team pxl-team1 pxl-team-carousel1" <?php if($drap !== false) : ?>data-cursor-drap="<?php echo esc_html('DRAG', 'konstruc'); ?>"<?php endif; ?>>
    <div class="pxl-carousel-inner">
        <div <?php pxl_print_html($widget->get_render_attribute_string( 'carousel' )); ?>>
            <div class="pxl-swiper-wrapper">
                <?php foreach ($settings['team'] as $key => $value):
                    $title = isset($value['title']) ? $value['title'] : '';
                    $position = isset($value['position']) ? $value['position'] : '';
                    $description = isset($value['description']) ? $value['description'] : '';
                    $popup_template = isset($value['popup_template']) ? $value['popup_template'] : '';
                    $image = isset($value['image']) ? $value['image'] : '';
                    $social = isset($value['social']) ? $value['social'] : '';
                    ?>
                    <div class="pxl-swiper-slide">
                        <div class="pxl-item--inner <?php echo esc_attr($settings['pxl_animate']); ?>" data-wow-delay="<?php echo esc_attr($settings['pxl_animate_delay']); ?>ms">
                            <?php if(!empty($image['id'])) { 
                                $img = pxl_get_image_by_size( array(
                                    'attach_id'  => $image['id'],
                                    'thumb_size' => $image_size,
                                    'class' => 'no-lazyload',
                                ));
                                $thumbnail = $img['thumbnail'];
                                ?>
                                <div class="pxl-item--image">
                                    <a class="pxl-link--thumbnail" <?php konstruc_render_link_attributes($value['link']); ?> ><?php echo wp_kses_post($thumbnail); ?></a>
                                    <?php if(!empty($social)): ?>
                                        <div class="pxl-social--wrap">
                                            <div class="pxl-social">
                                                <?php  $team_social = json_decode($social, true); ?>
                                                <?php foreach ($team_social as $social): ?>
                                                    <a href="<?php echo esc_url($social['url']); ?>" target="_blank"><i class="<?php echo esc_attr($social['icon']); ?>"></i></a>
                                                <?php endforeach; ?>
                                            </div>
                                            <div class="pxl-icon--wrap" >
                                                <svg xmlns="http://www.w3.org/2000/svg" width="23" height="24" viewBox="0 0 23 24" fill="none">
                                                    <path d="M13.3068 17.8596L8.40809 15.1875C7.55649 16.0976 6.34463 16.6663 4.99992 16.6663C2.42259 16.6663 0.333252 14.577 0.333252 11.9997C0.333252 9.42235 2.42259 7.33301 4.99992 7.33301C6.34456 7.33301 7.55638 7.90171 8.40796 8.81171L13.3068 6.13966C13.2152 5.77482 13.1666 5.39292 13.1666 4.99967C13.1666 2.42234 15.256 0.333008 17.8333 0.333008C20.4105 0.333008 22.4999 2.42234 22.4999 4.99967C22.4999 7.577 20.4105 9.66634 17.8333 9.66634C16.4886 9.66634 15.2767 9.0976 14.4251 8.18754L9.52632 10.8596C9.61794 11.2244 9.66658 11.6064 9.66658 11.9997C9.66658 12.393 9.61795 12.7748 9.52636 13.1396L14.4252 15.8118C15.2767 14.9018 16.4886 14.333 17.8333 14.333C20.4105 14.333 22.4999 16.4224 22.4999 18.9997C22.4999 21.577 20.4105 23.6663 17.8333 23.6663C15.256 23.6663 13.1666 21.577 13.1666 18.9997C13.1666 18.6064 13.2152 18.2244 13.3068 17.8596ZM4.99992 14.333C6.28858 14.333 7.33325 13.2884 7.33325 11.9997C7.33325 10.711 6.28858 9.66634 4.99992 9.66634C3.71125 9.66634 2.66659 10.711 2.66659 11.9997C2.66659 13.2884 3.71125 14.333 4.99992 14.333ZM17.8333 7.33301C19.122 7.33301 20.1666 6.28834 20.1666 4.99967C20.1666 3.71101 19.122 2.66634 17.8333 2.66634C16.5446 2.66634 15.4999 3.71101 15.4999 4.99967C15.4999 6.28834 16.5446 7.33301 17.8333 7.33301ZM17.8333 21.333C19.122 21.333 20.1666 20.2884 20.1666 18.9997C20.1666 17.711 19.122 16.6663 17.8333 16.6663C16.5446 16.6663 15.4999 17.711 15.4999 18.9997C15.4999 20.2884 16.5446 21.333 17.8333 21.333Z" fill="currentColor"/>
                                                </svg>
                                            </div>
                                        </div>
                                    <?php endif; ?>
                                </div>
                            <?php } ?>
                            <div class="pxl-item--holder ">

                                <div class="pxl-item--meta">
                                    <?php if (!empty($title || !empty($position))) : ?>
                                        <div class="pxl-item--author">
                                            <?php if (!empty($title)) : ?>
                                                <h3 class="pxl-item--title">    
                                                    <a <?php konstruc_render_link_attributes($value['link']); ?>>
                                                        <?php echo pxl_print_html($title); ?>
                                                    </a>
                                                </h3>
                                            <?php endif; ?>
                                            <?php if (!empty($position)) : ?>
                                                <div class="pxl-item--position"><?php echo pxl_print_html($position); ?></div>
                                            <?php endif; ?>
                                        </div>
                                    <?php endif; ?>

                                    <div class="pxl-item--description"><?php echo pxl_print_html($description); ?></div>
                                </div>

                            </div>
                        </div>
                    </div>
                <?php endforeach; ?>
            </div>
        </div>

        <?php if($pagination !== false): ?>
            <div class="pxl-swiper-dots style-1"></div>
        <?php endif; ?>

        <?php if($arrows !== false): ?>
            <div class="pxl-swiper-arrow-wrap style-2">
                <div class="pxl-swiper-arrow pxl-swiper-arrow-prev">
                    <svg width="20" height="38" xmlns="http://www.w3.org/2000/svg">
                       <g>
                          <path stroke="#000" id="svg_3" d="m20.21811,38.88319l-19.7456,-20.72803" opacity="undefined" stroke-linecap="undefined" stroke-linejoin="undefined" fill="none"/>
                          <path stroke="#000" id="svg_5" d="m20.00751,-0.49215l-19.55631,19.26847" opacity="undefined" stroke-linecap="undefined" stroke-linejoin="undefined" fill="none"/>
                      </g>
                  </svg>
              </div>
              <div class="pxl-swiper-arrow pxl-swiper-arrow-next">
                <svg width="20" height="38" xmlns="http://www.w3.org/2000/svg">
                   <g>
                      <path stroke="#000" id="svg_3" d="m20.21811,38.88319l-19.7456,-20.72803" opacity="undefined" stroke-linecap="undefined" stroke-linejoin="undefined" fill="none"/>
                      <path stroke="#000" id="svg_5" d="m20.00751,-0.49215l-19.55631,19.26847" opacity="undefined" stroke-linecap="undefined" stroke-linejoin="undefined" fill="none"/>
                  </g>
              </svg>
          </div>
      </div>
  <?php endif; ?>

</div>
</div>
<?php endif; ?>
