<?php
$col_xs = $widget->get_setting('col_xs', '');
$col_sm = $widget->get_setting('col_sm', '');
$col_md = $widget->get_setting('col_md', '');
$col_lg = $widget->get_setting('col_lg', '');
$col_xl = $widget->get_setting('col_xl', '');

$col_xl = 12 / intval($col_xl);
$col_lg = 12 / intval($col_lg);
$col_md = 12 / intval($col_md);
$col_sm = 12 / intval($col_sm);
$col_xs = 12 / intval($col_xs);

$grid_sizer = "col-xl-{$col_xl} col-lg-{$col_lg} col-md-{$col_md} col-sm-{$col_sm} col-{$col_xs}";
$item_class = "pxl-grid-item col-xl-{$col_xl} col-lg-{$col_lg} col-md-{$col_md} col-sm-{$col_sm} col-{$col_xs}";
$image_size = !empty($settings['img_size']) ? $settings['img_size'] : '848x940';




?>
<?php if(isset($settings['team']) && !empty($settings['team']) && count($settings['team'])): ?>
<div class="pxl-team pxl-team-grid pxl-team1 pxl-team-layout1" data-layout="<?php echo esc_attr($settings['layout_mode']); ?>">
    <div class="pxl-grid-inner pxl-grid-masonry row" data-gutter="15">
        <?php foreach ($settings['team'] as $key => $value):
            $title = isset($value['title']) ? $value['title'] : '';
            $position = isset($value['position']) ? $value['position'] : '';
            $description = isset($value['description']) ? $value['description'] : '';
            $popup_template = isset($value['popup_template']) ? $value['popup_template'] : '';
            $image = isset($value['image']) ? $value['image'] : '';
            $social = isset($value['social']) ? $value['social'] : '';
            ?>
            <div class="<?php echo esc_attr($item_class); ?>">
                <div class="pxl-item--inner <?php echo esc_attr($settings['pxl_animate']); ?>" data-wow-delay="<?php echo esc_attr($settings['pxl_animate_delay']); ?>ms">
                    <?php if(!empty($image['id'])) { 
                        $img = pxl_get_image_by_size( array(
                            'attach_id'  => $image['id'],
                            'thumb_size' => $image_size,
                            'class' => 'no-lazyload',
                        ));
                        $thumbnail = $img['thumbnail'];
                        ?>
                        <div class="pxl-item--image">
                            <a class="pxl-link--thumbnail" <?php konstruc_render_link_attributes($value['link']); ?> ><?php echo wp_kses_post($thumbnail); ?></a>
                            <?php if(!empty($social)): ?>
                                <div class="pxl-social--wrap">
                                    <div class="pxl-social">
                                        <?php  $team_social = json_decode($social, true); ?>
                                        <?php foreach ($team_social as $social): ?>
                                            <a href="<?php echo esc_url($social['url']); ?>" target="_blank"><i class="<?php echo esc_attr($social['icon']); ?>"></i></a>
                                        <?php endforeach; ?>
                                    </div>
                                    <div class="pxl-icon--wrap" ><i class="fas fa-share-alt"></i></div >
                                </div>
                            <?php endif; ?>
                        </div>
                    <?php } ?>
                    <div class="pxl-item--holder ">

                        <div class="pxl-item--meta">
                            <?php if (!empty($title || !empty($position))) : ?>
                                <div class="pxl-item--author">
                                    <?php if (!empty($title)) : ?>
                                        <h3 class="pxl-item--title">    
                                            <a <?php konstruc_render_link_attributes($value['link']); ?>>
                                                <?php echo pxl_print_html($title); ?>
                                            </a>
                                        </h3>
                                    <?php endif; ?>
                                    <?php if (!empty($position)) : ?>
                                        <div class="pxl-item--position"><?php echo pxl_print_html($position); ?></div>
                                    <?php endif; ?>
                                </div>
                            <?php endif; ?>

                            <div class="pxl-item--description"><?php echo pxl_print_html($description); ?></div>
                        </div>

                    </div>
                </div>
            </div>
        <?php endforeach; ?>
        <div class="grid-sizer <?php echo esc_attr($grid_sizer); ?>"></div>
    </div>
</div>
<?php endif; ?>
