<?php
$col_xs = $widget->get_setting('col_xs', '');
$col_sm = $widget->get_setting('col_sm', '');
$col_md = $widget->get_setting('col_md', '');
$col_lg = $widget->get_setting('col_lg', '');
$col_xl = $widget->get_setting('col_xl', '');
$col_xxl = $widget->get_setting('col_xxl', '');
if($col_xxl == 'inherit') {
    $col_xxl = $col_xl;
}
$slides_to_scroll = $widget->get_setting('slides_to_scroll');
$arrows = $widget->get_setting('arrows', false);  
$pagination = $widget->get_setting('pagination', false);
$pagination_type = $widget->get_setting('pagination_type', 'bullets');
$pause_on_hover = $widget->get_setting('pause_on_hover', false);
$autoplay = $widget->get_setting('autoplay', false);
$autoplay_speed = $widget->get_setting('autoplay_speed', '5000');
$infinite = $widget->get_setting('infinite', false);  
$speed = $widget->get_setting('speed', '500');
$img_size = $settings['img_size'] ?? 'full';
$drap = $widget->get_setting('drap', false);  
$opts = [
    'slide_direction'               => 'horizontal',
    'slide_percolumn'               => 1, 
    'slide_mode'                    => 'slide', 
    'slides_to_show'                => (int)$col_xl,
    'slides_to_show_xxl'            => (int)$col_xxl, 
    'slides_to_show_lg'             => (int)$col_lg, 
    'slides_to_show_md'             => (int)$col_md, 
    'slides_to_show_sm'             => (int)$col_sm, 
    'slides_to_show_xs'             => (int)$col_xs, 
    'slides_to_scroll'              => (int)$slides_to_scroll,
    'arrow'                         => (bool)$arrows,
    'pagination'                    => (bool)$pagination,
    'pagination_type'               => $pagination_type,
    'autoplay'                      => (bool)$autoplay,
    'pause_on_hover'                => (bool)$pause_on_hover,
    'pause_on_interaction'          => true,
    'delay'                         => (int)$autoplay_speed,
    'loop'                          => (bool)$infinite,
    'speed'                         => (int)$speed
];
$widget->add_render_attribute( 'carousel', [
    'class'         => 'pxl-swiper-container',
    'dir'           => is_rtl() ? 'rtl' : 'ltr',
    'data-settings' => wp_json_encode($opts)
]);
if(isset($settings['testimonial']) && !empty($settings['testimonial']) && count($settings['testimonial'])): ?>
    <div class="pxl-swiper-slider pxl-testimonial-carousel pxl-testimonial-carousel4" <?php if($drap !== false) : ?>data-cursor-drap="<?php echo esc_html('DRAG', 'konstruc'); ?>"<?php endif; ?>>
        <div class="pxl-carousel-inner">
            <div <?php pxl_print_html($widget->get_render_attribute_string( 'carousel' )); ?>>
                <div class="pxl-swiper-wrapper">
                    <?php foreach ($settings['testimonial'] as $key => $value):
                        $title = isset($value['title']) ? $value['title'] : '';
                        $position = isset($value['position']) ? $value['position'] : '';
                        $desc = isset($value['desc']) ? $value['desc'] : '';
                        $heading = isset($value['heading']) ? $value['heading'] : '';
                        $image_id = $value['image']['id'] ?? '';
                        $thumbnail = konstruc_get_thumbnail($image_id, $img_size); 
                        $star = isset($value['star']) ? $value['star'] : '';
                        $outlined_star =  '5' - $star;
                        ?>
                        <div class="pxl-swiper-slide">
                            <div class="pxl-item--inner <?php echo esc_attr($settings['pxl_animate']); ?>" data-wow-delay="<?php echo esc_attr($settings['pxl_animate_delay']); ?>ms">
                                <div class="pxl-icon--quote">
                                    <svg xmlns="http://www.w3.org/2000/svg" width="36" height="36" viewBox="0 0 36 36" fill="none">
                                        <path d="M31.7812 16.5938H23.3438V13.7812C23.3438 9.90422 26.498 6.75 30.375 6.75H34.5938C35.3704 6.75 36 6.12042 36 5.34375C36 4.56708 35.3704 3.9375 34.5938 3.9375H30.375C24.9472 3.9375 20.5312 8.35341 20.5312 13.7812V27.8438C20.5312 30.17 22.4238 32.0625 24.75 32.0625H31.7812C34.1075 32.0625 36 30.17 36 27.8438V20.8125C36 18.4863 34.1075 16.5938 31.7812 16.5938ZM33.1875 27.8438C33.1875 28.6192 32.5567 29.25 31.7812 29.25H24.75C23.9746 29.25 23.3438 28.6192 23.3438 27.8438V19.4062H31.7812C32.5567 19.4062 33.1875 20.0371 33.1875 20.8125V27.8438Z" fill="currentColor"/>
                                        <path d="M9.84375 6.75H14.0625C14.8392 6.75 15.4688 6.12042 15.4688 5.34375C15.4688 4.56708 14.8392 3.9375 14.0625 3.9375H9.84375C4.41591 3.9375 0 8.35341 0 13.7812V27.8438C0 30.17 1.89253 32.0625 4.21875 32.0625H11.25C13.5762 32.0625 15.4688 30.17 15.4688 27.8438V20.8125C15.4688 18.4863 13.5762 16.5938 11.25 16.5938H2.8125V13.7812C2.8125 9.90422 5.96672 6.75 9.84375 6.75ZM12.6562 20.8125V27.8438C12.6562 28.6192 12.0254 29.25 11.25 29.25H4.21875C3.44334 29.25 2.8125 28.6192 2.8125 27.8438V19.4062H11.25C12.0254 19.4062 12.6562 20.0371 12.6562 20.8125Z" fill="currentColor"/>
                                    </svg>
                                </div>

                                <div class="pxl-item--star pxl-rating--<?php echo esc_attr($star); ?>-star">
                                    <?php for ($i = 0; $i < $star; $i++) : ?>
                                        <i class="fas fa-star"></i>
                                    <?php endfor; ?>
                                    <?php for ($i = 0; $i < $outlined_star; $i++) : ?>
                                        <i class="far fa-star"></i>
                                    <?php endfor; ?>
                                </div>

                                <h4 class="pxl-item--heading el-empty">
                                    <?php echo pxl_print_html($heading); ?>
                                </h4>

                                <div class="pxl-item--desc el-empty">
                                    <?php echo pxl_print_html($desc); ?>
                                </div>

                                <div class="pxl-item--content">
                                  <div class="pxl-item--meta">

                                    <div class="pxl-item--info">
                                        <h3 class="pxl-item--title el-empty">
                                            <?php echo pxl_print_html($title); ?>
                                        </h3>
                                        <div class="pxl-item--position el-empty">
                                            <?php echo pxl_print_html($position); ?>
                                        </div>
                                    </div>

                                    <div class="pxl-item--author">
                                        <?php pxl_print_html($thumbnail); ?>
                                    </div>
                                </div>
                            </div>
                        </div>
                    </div>
                <?php endforeach; ?>
            </div>
        </div>

    </div>
    <?php if($pagination !== false || $arrows !== false): ?>
        <div class="pxl-swiper-arrow-wrap style-1">
            <div class="pxl-swiper-arrow pxl-swiper-arrow-prev">
             <svg xmlns="http://www.w3.org/2000/svg" width="55" height="55" viewBox="0 0 55 55" fill="none">
                <path d="M23.1297 26.9228L28.4937 21.5587L27.0795 20.1445L19.3013 27.9228L27.0795 35.7009L28.4937 34.2867L23.1297 28.9228H35.3013V26.9228H23.1297Z" fill="currentColor"/>
            </svg>
        </div>
        <div class="pxl-swiper-arrow pxl-swiper-arrow-next">
            <svg xmlns="http://www.w3.org/2000/svg" width="55" height="55" viewBox="0 0 55 55" fill="none">
                <path d="M23.1297 26.9228L28.4937 21.5587L27.0795 20.1445L19.3013 27.9228L27.0795 35.7009L28.4937 34.2867L23.1297 28.9228H35.3013V26.9228H23.1297Z" fill="currentColor"/>
            </svg>
        </div>
    </div>
<?php endif; ?>

</div>
<?php endif; ?>
