<?php
$col_xs = $widget->get_setting('col_xs', '');
$col_sm = $widget->get_setting('col_sm', '');
$col_md = $widget->get_setting('col_md', '');
$col_lg = $widget->get_setting('col_lg', '');
$col_xl = $widget->get_setting('col_xl', '');
$col_xxl = $widget->get_setting('col_xxl', '');
if($col_xxl == 'inherit') {
    $col_xxl = $col_xl;
}
$slides_to_scroll = $widget->get_setting('slides_to_scroll');
$arrows = $widget->get_setting('arrows', false);  
$pagination = $widget->get_setting('pagination', false);
$pagination_type = $widget->get_setting('pagination_type', 'bullets');
$pause_on_hover = $widget->get_setting('pause_on_hover', false);
$autoplay = $widget->get_setting('autoplay', false);
$autoplay_speed = $widget->get_setting('autoplay_speed', '5000');
$infinite = $widget->get_setting('infinite', false);  
$speed = $widget->get_setting('speed', '500');
$img_size = $settings['img_size'] ?? 'full';
$drap = $widget->get_setting('drap', false);  
$opts = [
    'slide_direction'               => 'horizontal',
    'slide_percolumn'               => 1, 
    'slide_mode'                    => 'slide', 
    'slides_to_show'                => (int)$col_xl,
    'slides_to_show_xxl'            => (int)$col_xxl, 
    'slides_to_show_lg'             => (int)$col_lg, 
    'slides_to_show_md'             => (int)$col_md, 
    'slides_to_show_sm'             => (int)$col_sm, 
    'slides_to_show_xs'             => (int)$col_xs, 
    'slides_to_scroll'              => (int)$slides_to_scroll,
    'arrow'                         => (bool)$arrows,
    'pagination'                    => (bool)$pagination,
    'pagination_type'               => $pagination_type,
    'autoplay'                      => (bool)$autoplay,
    'pause_on_hover'                => (bool)$pause_on_hover,
    'pause_on_interaction'          => true,
    'delay'                         => (int)$autoplay_speed,
    'loop'                          => (bool)$infinite,
    'speed'                         => (int)$speed
];
$widget->add_render_attribute( 'carousel', [
    'class'         => 'pxl-swiper-container',
    'dir'           => is_rtl() ? 'rtl' : 'ltr',
    'data-settings' => wp_json_encode($opts)
]);
if(isset($settings['testimonial']) && !empty($settings['testimonial']) && count($settings['testimonial'])): ?>
    <div class="pxl-swiper-slider pxl-testimonial-carousel pxl-testimonial-carousel5" <?php if($drap !== false) : ?>data-cursor-drap="<?php echo esc_html('DRAG', 'konstruc'); ?>"<?php endif; ?>>
        <div class="pxl-carousel-inner">
            <div <?php pxl_print_html($widget->get_render_attribute_string( 'carousel' )); ?>>
                <div class="pxl-swiper-wrapper">
                    <?php foreach ($settings['testimonial'] as $key => $value):
                        $title = isset($value['title']) ? $value['title'] : '';
                        $position = isset($value['position']) ? $value['position'] : '';
                        $desc = isset($value['desc']) ? $value['desc'] : '';
                        $heading = isset($value['heading']) ? $value['heading'] : '';
                        $image_id = $value['image']['id'] ?? '';
                        $thumbnail = konstruc_get_thumbnail($image_id, $img_size); 
                        $star = isset($value['star']) ? $value['star'] : '';
                        $outlined_star =  '5' - $star;
                        ?>
                        <div class="pxl-swiper-slide">
                            <div class="pxl-item--inner <?php echo esc_attr($settings['pxl_animate']); ?>" data-wow-delay="<?php echo esc_attr($settings['pxl_animate_delay']); ?>ms">
                                <div class="pxl-icon--quote">
                                    <svg xmlns="http://www.w3.org/2000/svg" width="36" height="36" viewBox="0 0 36 36" fill="none">
                                        <path d="M31.7812 16.5938H23.3438V13.7812C23.3438 9.90422 26.498 6.75 30.375 6.75H34.5938C35.3704 6.75 36 6.12042 36 5.34375C36 4.56708 35.3704 3.9375 34.5938 3.9375H30.375C24.9472 3.9375 20.5312 8.35341 20.5312 13.7812V27.8438C20.5312 30.17 22.4238 32.0625 24.75 32.0625H31.7812C34.1075 32.0625 36 30.17 36 27.8438V20.8125C36 18.4863 34.1075 16.5938 31.7812 16.5938ZM33.1875 27.8438C33.1875 28.6192 32.5567 29.25 31.7812 29.25H24.75C23.9746 29.25 23.3438 28.6192 23.3438 27.8438V19.4062H31.7812C32.5567 19.4062 33.1875 20.0371 33.1875 20.8125V27.8438Z" fill="currentColor"/>
                                        <path d="M9.84375 6.75H14.0625C14.8392 6.75 15.4688 6.12042 15.4688 5.34375C15.4688 4.56708 14.8392 3.9375 14.0625 3.9375H9.84375C4.41591 3.9375 0 8.35341 0 13.7812V27.8438C0 30.17 1.89253 32.0625 4.21875 32.0625H11.25C13.5762 32.0625 15.4688 30.17 15.4688 27.8438V20.8125C15.4688 18.4863 13.5762 16.5938 11.25 16.5938H2.8125V13.7812C2.8125 9.90422 5.96672 6.75 9.84375 6.75ZM12.6562 20.8125V27.8438C12.6562 28.6192 12.0254 29.25 11.25 29.25H4.21875C3.44334 29.25 2.8125 28.6192 2.8125 27.8438V19.4062H11.25C12.0254 19.4062 12.6562 20.0371 12.6562 20.8125Z" fill="currentColor"/>
                                    </svg>
                                </div>

                                <div class="pxl-item--star pxl-rating--<?php echo esc_attr($star); ?>-star">
                                    <?php for ($i = 0; $i < $star; $i++) : ?>
                                        <i class="fas fa-star"></i>
                                    <?php endfor; ?>
                                    <?php for ($i = 0; $i < $outlined_star; $i++) : ?>
                                        <i class="far fa-star"></i>
                                    <?php endfor; ?>
                                </div>

                                <h4 class="pxl-item--heading el-empty">
                                    <?php echo pxl_print_html($heading); ?>
                                </h4>

                                <div class="pxl-item--desc el-empty">
                                    <?php echo pxl_print_html($desc); ?>
                                </div>

                                <div class="pxl-item--content">
                                  <div class="pxl-item--meta">
                                    <div class="pxl-item--author">
                                        <?php pxl_print_html($thumbnail); ?>
                                    </div>
                                    <div class="pxl-item--info">
                                        <h3 class="pxl-item--title el-empty">
                                            <?php echo pxl_print_html($title); ?>
                                        </h3>
                                        <div class="pxl-item--position el-empty">
                                            <?php echo pxl_print_html($position); ?>
                                        </div>
                                    </div>


                                </div>
                                <div class="pxl-icon--quote2">
                                    <svg xmlns="http://www.w3.org/2000/svg" width="115" height="115" viewBox="0 0 115 115" fill="none">
                                      <path d="M51.2109 26.7285C52.4515 26.7285 53.457 25.7227 53.457 24.4824V17.2949C53.457 11.1024 48.419 6.06445 42.2266 6.06445H11.2305C5.03799 6.06445 0 11.1024 0 17.2949V44.2454C0 50.4378 5.03799 55.4758 11.2305 55.4758H25.7609C25.2497 72.2555 18.8831 80.9784 6.3414 82.1194C5.18443 82.2248 4.2988 83.1946 4.2988 84.3563V106.689C4.2988 107.307 4.55306 107.897 5.00183 108.322C5.42005 108.717 5.97236 108.936 6.54467 108.936C6.58667 108.936 6.6289 108.934 6.6709 108.932C22.1483 108.061 33.9634 102.735 41.7883 93.0999C49.5311 83.5661 53.457 69.6354 53.457 51.6943V43.649C53.457 42.4087 52.4515 41.4029 51.2109 41.4029C49.9704 41.4029 48.9648 42.4087 48.9648 43.649V51.6943C48.9648 84.6319 35.8173 101.857 8.79121 104.275V86.3428C15.6218 85.2804 20.9053 82.1008 24.5154 76.873C28.3448 71.3272 30.2866 63.3726 30.2866 53.2297C30.2866 51.9894 29.281 50.9836 28.0405 50.9836H11.2305C7.51498 50.9836 4.49219 47.9608 4.49219 44.2454V17.2949C4.49219 13.5794 7.51498 10.5566 11.2305 10.5566H42.2266C45.9421 10.5566 48.9648 13.5794 48.9648 17.2949V24.4824C48.9648 25.7227 49.9704 26.7285 51.2109 26.7285Z" fill="#FF792D" fill-opacity="0.15"/>
                                      <path d="M103.77 6.06445H72.7734C66.581 6.06445 61.543 11.1024 61.543 17.2949V44.2454C61.543 50.4378 66.581 55.4758 72.7734 55.4758H87.3039C86.7927 72.2555 80.4261 80.9784 67.8844 82.1194C66.7276 82.2248 65.8418 83.1946 65.8418 84.3563V106.689C65.8418 107.307 66.096 107.897 66.5448 108.322C66.963 108.717 67.5153 108.936 68.0876 108.936C68.1296 108.936 68.1719 108.934 68.2139 108.932C83.6913 108.061 95.5064 102.735 103.331 93.0999C111.074 83.5664 115 69.6354 115 51.6943V17.2949C115 11.1024 109.962 6.06445 103.77 6.06445ZM110.508 51.6943C110.508 84.6319 97.3603 101.857 70.334 104.275V86.3428C77.1648 85.2804 82.4483 82.1008 86.0582 76.873C89.8875 71.3274 91.8293 63.3729 91.8293 53.2297C91.8293 51.9894 90.8237 50.9836 89.5832 50.9836H72.7734C69.0579 50.9836 66.0352 47.9608 66.0352 44.2454V17.2949C66.0352 13.5794 69.0579 10.5566 72.7734 10.5566H99.7266V27.1854C99.7266 28.4257 100.732 29.4315 101.973 29.4315C103.213 29.4315 104.219 28.4257 104.219 27.1854V10.5733C107.725 10.8055 110.508 13.7306 110.508 17.2949V51.6943Z" fill="#FF792D" fill-opacity="0.15"/>
                                      <path d="M101.973 32.7373C100.732 32.7373 99.7266 33.7541 99.7266 34.9944C99.7266 36.2347 100.732 37.2405 101.973 37.2405C103.213 37.2405 104.219 36.2347 104.219 34.9944V34.9722C104.219 33.7319 103.213 32.7373 101.973 32.7373Z" fill="#FF792D" fill-opacity="0.15"/>
                                      <path d="M51.2109 31.8193C49.9704 31.8193 48.9648 32.8251 48.9648 34.0654V34.1124C48.9648 35.3527 49.9704 36.3585 51.2109 36.3585C52.4515 36.3585 53.457 35.3527 53.457 34.1124V34.0654C53.457 32.8251 52.4515 31.8193 51.2109 31.8193Z" fill="#FF792D" fill-opacity="0.15"/>
                                  </svg>
                              </div>
                          </div>

                      </div>
                  </div>
              <?php endforeach; ?>
          </div>
      </div>

  </div>
  <?php if($pagination !== false || $arrows !== false): ?>
    <div class="pxl-swiper-arrow-wrap style-1">
        <div class="pxl-swiper-arrow pxl-swiper-arrow-prev">
         <svg xmlns="http://www.w3.org/2000/svg" width="55" height="55" viewBox="0 0 55 55" fill="none">
            <path d="M23.1297 26.9228L28.4937 21.5587L27.0795 20.1445L19.3013 27.9228L27.0795 35.7009L28.4937 34.2867L23.1297 28.9228H35.3013V26.9228H23.1297Z" fill="currentColor"/>
        </svg>
    </div>
    <div class="pxl-swiper-arrow pxl-swiper-arrow-next">
        <svg xmlns="http://www.w3.org/2000/svg" width="55" height="55" viewBox="0 0 55 55" fill="none">
            <path d="M23.1297 26.9228L28.4937 21.5587L27.0795 20.1445L19.3013 27.9228L27.0795 35.7009L28.4937 34.2867L23.1297 28.9228H35.3013V26.9228H23.1297Z" fill="currentColor"/>
        </svg>
    </div>
</div>
<?php endif; ?>

</div>
<?php endif; ?>
