<?php
$col_xs = $widget->get_setting('col_xs', '');
$col_sm = $widget->get_setting('col_sm', '');
$col_md = $widget->get_setting('col_md', '');
$col_lg = $widget->get_setting('col_lg', '');
$col_xl = $widget->get_setting('col_xl', '');
$col_xxl = $widget->get_setting('col_xxl', '');
if($col_xxl == 'inherit') {
    $col_xxl = $col_xl;
}
$slides_to_scroll = $widget->get_setting('slides_to_scroll');
$arrows = $widget->get_setting('arrows', false);  
$pagination = $widget->get_setting('pagination', false);
$pagination_type = $widget->get_setting('pagination_type', 'bullets');
$pause_on_hover = $widget->get_setting('pause_on_hover', false);
$autoplay = $widget->get_setting('autoplay', false);
$autoplay_speed = $widget->get_setting('autoplay_speed', '5000');
$infinite = $widget->get_setting('infinite', false);  
$speed = $widget->get_setting('speed', '500');
$img_size = $settings['img_size'] ?? '170x170';
$drap = $widget->get_setting('drap', false);  
$opts = [
    'slide_direction'               => 'horizontal',
    'slide_percolumn'               => 1, 
    'slide_mode'                    => 'slide', 
    'slides_to_show'                => 1,
    'slides_to_show_xxl'            => 1, 
    'slides_to_show_lg'             => 1, 
    'slides_to_show_md'             => 1, 
    'slides_to_show_sm'             => 1, 
    'slides_to_show_xs'             => 1, 
    'slides_to_scroll'              => (int)$slides_to_scroll,
    'arrow'                         => (bool)$arrows,
    'pagination'                    => (bool)$pagination,
    'pagination_type'               => $pagination_type,
    'autoplay'                      => (bool)$autoplay,
    'pause_on_hover'                => (bool)$pause_on_hover,
    'pause_on_interaction'          => true,
    'delay'                         => (int)$autoplay_speed,
    'loop'                          => (bool)$infinite,
    'speed'                         => (int)$speed
];
$widget->add_render_attribute( 'carousel', [
    'class'         => 'pxl-swiper-container',
    'dir'           => is_rtl() ? 'rtl' : 'ltr',
    'data-settings' => wp_json_encode($opts)
]);
$opts_thumb = [
    'slide_direction'               => 'horizontal',
    'slides_to_show'                => '3', 
    'slide_mode'                    => 'slide',
    'slides_to_show'                => (int)$col_xl,
    'slides_to_show_xxl'            => (int)$col_xxl, 
    'slides_to_show_lg'             => (int)$col_lg, 
    'slides_to_show_md'             => (int)$col_md, 
    'slides_to_show_sm'             => (int)$col_sm, 
    'slides_to_show_xs'             => (int)$col_xs, 
    'loop'                          => true,
];
$widget->add_render_attribute( 'thumb', [
    'class'         => 'pxl-swiper-thumbs',
    'data-settings' => wp_json_encode($opts_thumb),
]);


if(isset($settings['testimonial']) && !empty($settings['testimonial']) && count($settings['testimonial'])): ?>
    <div class="pxl-swiper-slider pxl-testimonial-carousel pxl-testimonial-carousel7" <?php if($drap !== false) : ?>data-cursor-drap="<?php echo esc_html('DRAG', 'konstruc'); ?>"<?php endif; ?>>
        <div class="pxl-carousel-inner">
            <div <?php pxl_print_html($widget->get_render_attribute_string( 'thumb' )); ?>>

                <div class="pxl-swiper-wrapper">
                    <?php foreach ($settings['testimonial'] as $key => $value):
                        $image_id = $value['image']['id'] ?? '';
                        $thumbnail = konstruc_get_thumbnail($image_id, $img_size); 
                        ?>
                        <div class="pxl-swiper-slide swiper-slide">
                            <div class="pxl-item--author">
                                <?php pxl_print_html($thumbnail); ?>
                            </div>
                        </div>
                    <?php endforeach; ?>
                </div>
            </div>


            <div <?php pxl_print_html($widget->get_render_attribute_string( 'carousel' )); ?>>
                <div class="pxl-swiper-wrapper">
                    <?php foreach ($settings['testimonial'] as $key => $value):
                        $title = isset($value['title']) ? $value['title'] : '';
                        $position = isset($value['position']) ? $value['position'] : '';
                        $desc = isset($value['desc']) ? $value['desc'] : '';
                        $star = isset($value['star']) ? $value['star'] : '';
                        $outlined_star =  '5' - $star;
                        ?>
                        <div class="pxl-swiper-slide">
                            <div class="pxl-item--inner <?php echo esc_attr($settings['pxl_animate']); ?>" data-wow-delay="<?php echo esc_attr($settings['pxl_animate_delay']); ?>ms">
                                <div class="pxl-item--star pxl-rating--<?php echo esc_attr($star); ?>-star">
                                    <?php for ($i = 0; $i < $star; $i++) : ?>
                                        <i class="fas fa-star"></i>
                                    <?php endfor; ?>
                                    <?php for ($i = 0; $i < $outlined_star; $i++) : ?>
                                        <i class="far fa-star"></i>
                                    <?php endfor; ?>
                                </div>
                                <div class="pxl-item--desc el-empty"><?php echo pxl_print_html($desc); ?></div>
                                <div class="pxl-item--content">

                                  <div class="pxl-item--meta">

                                    <div class="pxl-item--info">
                                        <h3 class="pxl-item--title el-empty">
                                            <?php echo pxl_print_html($title); ?>
                                        </h3>
                                        <div class="pxl-item--position el-empty">
                                            <?php echo pxl_print_html($position); ?>
                                        </div>
                                    </div>
                                    <div class="pxl-icon---quote">
                                        <svg xmlns="http://www.w3.org/2000/svg" width="64" height="64" viewBox="0 0 64 64" fill="none">
                                            <path d="M56.5 29.5H41.5V24.5C41.5 17.6075 47.1075 12 54 12H61.5C62.8808 12 64 10.8807 64 9.5C64 8.11925 62.8808 7 61.5 7H54C44.3505 7 36.5 14.8505 36.5 24.5V49.5C36.5 53.6355 39.8645 57 44 57H56.5C60.6355 57 64 53.6355 64 49.5V37C64 32.8645 60.6355 29.5 56.5 29.5ZM59 49.5C59 50.8785 57.8785 52 56.5 52H44C42.6215 52 41.5 50.8785 41.5 49.5V34.5H56.5C57.8785 34.5 59 35.6215 59 37V49.5Z" fill="currentColor" fill-opacity="0.28"/>
                                            <path d="M17.5 12H25C26.3808 12 27.5 10.8807 27.5 9.5C27.5 8.11925 26.3808 7 25 7H17.5C7.8505 7 0 14.8505 0 24.5V49.5C0 53.6355 3.3645 57 7.5 57H20C24.1355 57 27.5 53.6355 27.5 49.5V37C27.5 32.8645 24.1355 29.5 20 29.5H5V24.5C5 17.6075 10.6075 12 17.5 12ZM22.5 37V49.5C22.5 50.8785 21.3785 52 20 52H7.5C6.1215 52 5 50.8785 5 49.5V34.5H20C21.3785 34.5 22.5 35.6215 22.5 37Z" fill="currentColor" fill-opacity="0.28"/>
                                        </svg>
                                    </div>
                                </div>
                            </div>
                        </div>
                    </div>
                <?php endforeach; ?>
            </div>
        </div>



    </div>
    <?php if($pagination !== false || $arrows !== false): ?>
        <div class="pxl-swiper-arrow-wrap ">
            <div class="pxl-swiper-arrow pxl-swiper-arrow-prev">
                <svg width="20" height="38" xmlns="http://www.w3.org/2000/svg">
                   <g>
                      <path stroke="#000" id="svg_3" d="m20.21811,38.88319l-19.7456,-20.72803" opacity="undefined" stroke-linecap="undefined" stroke-linejoin="undefined" fill="none"/>
                      <path stroke="#000" id="svg_5" d="m20.00751,-0.49215l-19.55631,19.26847" opacity="undefined" stroke-linecap="undefined" stroke-linejoin="undefined" fill="none"/>
                  </g>
              </svg>
          </div>
          <div class="pxl-swiper-arrow pxl-swiper-arrow-next">
            <svg width="20" height="38" xmlns="http://www.w3.org/2000/svg">
               <g>
                  <path stroke="#000" id="svg_3" d="m20.21811,38.88319l-19.7456,-20.72803" opacity="undefined" stroke-linecap="undefined" stroke-linejoin="undefined" fill="none"/>
                  <path stroke="#000" id="svg_5" d="m20.00751,-0.49215l-19.55631,19.26847" opacity="undefined" stroke-linecap="undefined" stroke-linejoin="undefined" fill="none"/>
              </g>
          </svg>
      </div>
  </div>
<?php endif; ?>

</div>
<?php endif; ?>
