( function( $ ) {
    "use strict";
    var pxl_circilar_text_handler = function( $scope ) {
        let elements = $scope.find('.pxl-circle-text-item');
        if(!elements.length) return;
        setTimeout(function() {
            elements.each(function() {
                let circletext = new CircleType(this)
                circletext.forceHeight(true) 
                .forceWidth(true)  
            });
        }, 300)

        gsap.registerPlugin(ScrollTrigger);
        setTimeout(function() {
            document.querySelectorAll('.pxl-circle-text-wrapper.spin-scroll').forEach(spinScroll => {
              gsap.to(spinScroll, {
                rotate: 360,
                ease: "none",
                scrollTrigger: {
                  trigger: spinScroll,
                  start: "top bottom",
                  end: "bottom top",
                  scrub: true,
              }
          });
          });
        }, 300)
        
    };

    $( window ).on( 'elementor/frontend/init', function() {
        elementorFrontend.hooks.addAction( 'frontend/element_ready/pxl_video_player.default', function( $scope ) {
            pxl_circilar_text_handler($scope);
        });
    } );
} )( jQuery );