(function( $ ) {
    "use strict";
    var pxl_widget_counter_handler = function( $scope, $ ) {
        setTimeout(function(){
            var counterElements = $scope.find('.pxl-counter--value:not(.effect-slide)').toArray();
            var observer = new IntersectionObserver(function(entries, observer) {
                entries.forEach(function(entry) {
                    if (entry.isIntersecting) {
                        var $number = $(entry.target),
                            data = $number.data();

                        var decimalDigits = data.toValue.toString().match(/\.(.*)/);
                        if (decimalDigits) {
                            data.rounding = decimalDigits[1].length;
                        }

                        $number.numerator(data);
                        observer.unobserve(entry.target);
                    }
                });
            }, {
                rootMargin: '0px 0px -5% 0px', 
                threshold: 0
            });

            counterElements.forEach(function(element) {
                observer.observe(element);
            });
            var slideElements = $scope.find('.pxl-counter--value.effect-slide').toArray();
            var observerSlide = new IntersectionObserver(function(entries, observerSlide) {
                entries.forEach(function(entry) {
                    if (entry.isIntersecting) {
                        var $number = $(entry.target),
                            data = $number.data();
                        var el = $number[0];
                        var startNumber = data['startnumber'], endNumber = data['endnumber'], separator = data['delimiter'], duration = data['duration'];
                        
                        var od = new Odometer({
                            el: el,
                            value: startNumber,
                            format: separator,
                            theme: 'default'
                        });
                        od.update(endNumber);
                        observerSlide.unobserve(entry.target);
                    }
                });
            }, {
                rootMargin: '0px 0px -5% 0px',
                threshold: 0
            });
            slideElements.forEach(function(element) {
                observerSlide.observe(element);
            });

        }, 300);
    };
    
    $( window ).on( 'elementor/frontend/init', function() {
        elementorFrontend.hooks.addAction( 'frontend/element_ready/pxl_counter.default', pxl_widget_counter_handler );
        elementorFrontend.hooks.addAction( 'frontend/element_ready/pxl_pie_chart.default', pxl_widget_counter_handler );
    } );
})( jQuery );
