(function( $ ) {

    var pxl_widget_progressbar_handler = function( $scope, $ ) {
        var elements = $scope.find('.pxl--progressbar').toArray();
        const observer = new IntersectionObserver(function(entries, observer) {
            entries.forEach(function(entry) {
                if (entry.isIntersecting) {
                    $(entry.target).progressbar();
                    observer.unobserve(entry.target);
                }
            });
        }, {
            rootMargin: '0px 0px -10% 0px',
            threshold: 0  
        });

        elements.forEach(function(element) {
            observer.observe(element);
        });
    };

    $( window ).on( 'elementor/frontend/init', function() {
        elementorFrontend.hooks.addAction( 'frontend/element_ready/pxl_progressbar.default', pxl_widget_progressbar_handler );
    } );
})( jQuery );
