<?php
$templates_df = ['0' => esc_html__('None', 'konstruc')];
$templates = $templates_df + konstruc_get_templates_option('popup') ;
pxl_add_custom_widget(
    array(
        'name' => 'pxl_button',
        'title' => esc_html__('BR Button', 'konstruc' ),
        'icon' => 'eicon-button',
        'categories' => array('pxltheme-core'),
        'params' => array(
            'sections' => array(
                array(
                    'name' => 'section_content',
                    'label' => esc_html__('Content', 'konstruc' ),
                    'tab' => \Elementor\Controls_Manager::TAB_CONTENT,
                    'controls' => array(
                        array(
                            'name' => 'btn_style',
                            'label' => esc_html__('Type', 'konstruc' ),
                            'type' => \Elementor\Controls_Manager::SELECT,
                            'default' => 'btn-default',
                            'options' => [
                                'btn-default' => esc_html__('Default', 'konstruc' ),
                                'pxl-action-popup' => esc_html__('Popup', 'konstruc' ),
                            ],
                        ),
                        array(
                            'name' => 'text',
                            'label' => esc_html__('Text', 'konstruc' ),
                            'type' => \Elementor\Controls_Manager::TEXT,
                            'default' => esc_html__('Click Here', 'konstruc'),
                        ),
                        array(
                            'name' => 'btn_action',
                            'label' => esc_html__('Action', 'konstruc' ),
                            'type' => \Elementor\Controls_Manager::SELECT,
                            'default' => 'pxl-atc-link',
                            'options' => [
                                'pxl-atc-link' => esc_html__('Link', 'konstruc' ),
                                'pxl-atc-popup' => esc_html__('Popup', 'konstruc' ),
                            ],
                        ),
                        array(
                            'name' => 'link',
                            'label' => esc_html__('Link', 'konstruc' ),
                            'type' => \Elementor\Controls_Manager::URL,
                            'default' => [
                                'url' => '#',
                            ],
                            'condition' => [
                                'btn_action' => ['pxl-atc-link'],
                            ],
                        ),

                        array(
                            'name' => 'popup_template',
                            'label' => esc_html__('Select Popup Template', 'konstruc'),
                            'type' => 'select',
                            'options' => $templates,
                            'default' => 'df',
                            'description' => 'Add new tab template: "<a href="' . esc_url( admin_url( 'edit.php?post_type=pxl-template' ) ) . '" target="_blank">Click Here</a>"',
                            'condition' => [
                                'btn_action' => ['pxl-atc-popup'],
                            ],
                        ),

                        array(
                            'name' => 'align',
                            'label' => esc_html__('Alignment', 'konstruc' ),
                            'type' => \Elementor\Controls_Manager::CHOOSE,
                            'control_type' => 'responsive',
                            'options' => [
                                'left'    => [
                                    'title' => esc_html__('Left', 'konstruc' ),
                                    'icon' => 'fa fa-align-left',
                                ],
                                'center' => [
                                    'title' => esc_html__('Center', 'konstruc' ),
                                    'icon' => 'fa fa-align-center',
                                ],
                                'right' => [
                                    'title' => esc_html__('Right', 'konstruc' ),
                                    'icon' => 'fa fa-align-right',
                                ],
                                'justify' => [
                                    'title' => esc_html__('Justified', 'konstruc' ),
                                    'icon' => 'fa fa-align-justify',
                                ],
                            ],
                            'prefix_class' => 'elementor-align-',
                            'default' => '',
                            'selectors'         => [
                                '{{WRAPPER}} .pxl-button' => 'text-align: {{VALUE}}',
                            ],
                        ),
                        array(
                            'name' => 'btn_icon',
                            'label' => esc_html__('Icon', 'konstruc' ),
                            'type' => \Elementor\Controls_Manager::ICONS,
                            'label_block' => true,
                            'fa4compatibility' => 'icon',
                        ),
                        array(
                            'name' => 'icon_align',
                            'label' => esc_html__('Icon Position', 'konstruc' ),
                            'type' => \Elementor\Controls_Manager::SELECT,
                            'default' => 'right',
                            'options' => [
                                'left' => esc_html__('Before', 'konstruc' ),
                                'right' => esc_html__('After', 'konstruc' ),
                            ],
                        ),
                    ),
),

array(
    'name' => 'section_style_button',
    'label' => esc_html__('Button Normal', 'konstruc' ),
    'tab' => \Elementor\Controls_Manager::TAB_STYLE,
    'controls' => array_merge(
        array(
            array(
                'name' => 'color',
                'label' => esc_html__('Color', 'konstruc' ),
                'type' => \Elementor\Controls_Manager::COLOR,
                'selectors' => [
                    '{{WRAPPER}} .pxl-button .btn' => 'color: {{VALUE}};',
                ],
            ),
            array(
                'name' => 'btn_bg_color',
                'label' => esc_html__('Background Color', 'konstruc' ),
                'type' => \Elementor\Controls_Manager::COLOR,
                'selectors' => [
                    '{{WRAPPER}} .pxl-button .btn' => 'background-color: {{VALUE}};',
                ],
            ),

            array(
                'name' => 'btn_stroke_color',
                'label' => esc_html__('Stroke Color', 'konstruc' ),
                'type' => \Elementor\Controls_Manager::COLOR,
                'selectors' => [
                    '{{WRAPPER}} .pxl-button .btn.btn-stroke .pxl-svg-line path' => 'stroke: {{VALUE}};',
                ],
                'condition' => [
                    'btn_style' => ['btn-stroke'],
                ],
            ),

            array(
                'name' => 'btn_typography',
                'label' => esc_html__('Typography', 'konstruc' ),
                'type' => \Elementor\Group_Control_Typography::get_type(),
                'control_type' => 'group',
                'selector' => '{{WRAPPER}} .pxl-button .btn',
            ),
            array(
                'name'         => 'btn_box_shadow',
                'label' => esc_html__( 'Box Shadow', 'konstruc' ),
                'type'         => \Elementor\Group_Control_Box_Shadow::get_type(),
                'control_type' => 'group',
                'selector'     => '{{WRAPPER}} .pxl-button .btn',
            ),
            array(
                'name' => 'border_type',
                'label' => esc_html__( 'Border Type', 'konstruc' ),
                'type' => \Elementor\Controls_Manager::SELECT,
                'options' => [
                    '' => esc_html__( 'None', 'konstruc' ),
                    'solid' => esc_html__( 'Solid', 'konstruc' ),
                    'double' => esc_html__( 'Double', 'konstruc' ),
                    'dotted' => esc_html__( 'Dotted', 'konstruc' ),
                    'dashed' => esc_html__( 'Dashed', 'konstruc' ),
                    'groove' => esc_html__( 'Groove', 'konstruc' ),
                ],
                'selectors' => [
                    '{{WRAPPER}} .pxl-button .btn' => 'border-style: {{VALUE}} !important;',
                ],
            ),
            array(
                'name' => 'border_width',
                'label' => esc_html__( 'Border Width', 'konstruc' ),
                'type' => \Elementor\Controls_Manager::DIMENSIONS,
                'selectors' => [
                    '{{WRAPPER}} .pxl-button .btn' => 'border-width: {{TOP}}{{UNIT}} {{RIGHT}}{{UNIT}} {{BOTTOM}}{{UNIT}} {{LEFT}}{{UNIT}} !important;',
                ],
                'condition' => [
                    'border_type!' => '',
                ],
                'responsive' => true,
            ),
            array(
                'name' => 'border_color',
                'label' => esc_html__( 'Border Color', 'konstruc' ),
                'type' => \Elementor\Controls_Manager::COLOR,
                'default' => '',
                'selectors' => [
                    '{{WRAPPER}} .pxl-button .btn' => 'border-color: {{VALUE}} !important;',
                ],
                'condition' => [
                    'border_type!' => '',
                ],
            ),

            array(
                'name' => 'border_width_outline_gradient',
                'label' => esc_html__('Broder Width Gradient', 'konstruc' ),
                'type' => \Elementor\Controls_Manager::SLIDER,
                'control_type' => 'responsive',
                'size_units' => [ 'px' ],
                'range' => [
                    'px' => [
                        'min' => 0,
                        'max' => 300,
                    ],
                ],
                'selectors' => [
                    '{{WRAPPER}} .pxl-button .btn.btn-outline-gradient:after' => 'top: {{SIZE}}{{UNIT}};right: {{SIZE}}{{UNIT}};bottom: {{SIZE}}{{UNIT}};left: {{SIZE}}{{UNIT}};',
                ],
                'condition' => [
                    'btn_style' => ['btn-outline-gradient'],
                ],
            ),
        ),

array(
    array(
        'name' => 'btn_border_radius',
        'label' => esc_html__('Border Radius', 'konstruc' ),
        'type' => \Elementor\Controls_Manager::DIMENSIONS,
        'size_units' => [ 'px' ],
        'selectors' => [
            '{{WRAPPER}} .pxl-button .btn' => 'border-radius: {{TOP}}{{UNIT}} {{RIGHT}}{{UNIT}} {{BOTTOM}}{{UNIT}} {{LEFT}}{{UNIT}};',
        ],
    ),
    array(
        'name' => 'btn_padding',
        'label' => esc_html__('Padding', 'konstruc' ),
        'type' => \Elementor\Controls_Manager::DIMENSIONS,
        'size_units' => [ 'px' ],
        'selectors' => [
            '{{WRAPPER}} .pxl-button .btn' => 'padding: {{TOP}}{{UNIT}} {{RIGHT}}{{UNIT}} {{BOTTOM}}{{UNIT}} {{LEFT}}{{UNIT}};',
        ],
        'control_type' => 'responsive',
    ),
)
),
),

array(
    'name' => 'section_style_button_hover',
    'label' => esc_html__('Button Hover', 'konstruc' ),
    'tab' => \Elementor\Controls_Manager::TAB_STYLE,
    'controls' => array(
        array(
            'name' => 'btn_text_effect',
            'label' => esc_html__('Text Effect', 'konstruc' ),
            'type' => \Elementor\Controls_Manager::SELECT,
            'default' => '',
            'options' => [
                '' => esc_html__('Default', 'konstruc' ),
                'btn-arrow' => esc_html__('Arrow', 'konstruc' ),
                'btn-text-nina' => esc_html__('Nina', 'konstruc' ),
                'btn-text-nanuk' => esc_html__('Nanuk', 'konstruc' ),
                'btn-text-smoke' => esc_html__('Smoke', 'konstruc' ),
                'btn-text-reverse' => esc_html__('Reverse', 'konstruc' ),
                'btn-text-parallax' => esc_html__('Text Parallax', 'konstruc' ),
                'btn-hide-icon' => esc_html__('Hide Icon', 'konstruc' ),
                'btn-glossy' => esc_html__('Glossy', 'konstruc' ),
                'btn-underline' => esc_html__('Underline', 'konstruc' ),
            ],
        ),
        array(
            'name' => 'transition_duration',
            'label' => esc_html__('Transition Duration', 'konstruc' ),
            'type' => \Elementor\Controls_Manager::SLIDER,
            'size_units' => [ 'px' ],
            'range' => [
                'px' => [
                    'min' => 0,
                    'max' => 100000,
                ],
            ],
            'selectors' => [
                '{{WRAPPER}} .btn.btn-text-reverse .pxl-text--inner span' => 'transition-duration: {{SIZE}}ms;',
            ],
            'condition' => [
                'btn_text_effect' => ['btn-text-reverse'],
            ],
            'description' => 'Enter number, unit is ms.',
        ),
        array(
            'name' => 'color_hover',
            'label' => esc_html__('Color Hover', 'konstruc' ),
            'type' => \Elementor\Controls_Manager::COLOR,
            'selectors' => [
                '{{WRAPPER}} .pxl-button .btn:hover' => 'color: {{VALUE}};',
                '{{WRAPPER}} .pxl-button .btn-hide-icon .pxl--btn-text:before' => 'background-color: {{VALUE}} !important;',
            ],
        ),
        array(
            'name' => 'bd_color_hover',
            'label' => esc_html__('Border Color Hover', 'konstruc' ),
            'type' => \Elementor\Controls_Manager::COLOR,
            'selectors' => [
                '{{WRAPPER}} .pxl-button .btn:hover' => ' border-color: {{VALUE}} !important;',
            ],
        ),
        array(
            'name' => 'btn_bg_color_hover',
            'label' => esc_html__('Background Color', 'konstruc' ),
            'type' => \Elementor\Controls_Manager::COLOR,
            'selectors' => [
                '{{WRAPPER}} .pxl-button .btn:hover' => 'background-color: {{VALUE}};',
            ],
            'condition' => [
                'btn_style!' => [''],
            ],
        ),

        array(
            'name'         => 'btn_box_shadow_hover',
            'label' => esc_html__( 'Box Shadow', 'konstruc' ),
            'type'         => \Elementor\Group_Control_Box_Shadow::get_type(),
            'control_type' => 'group',
            'selector'     => '{{WRAPPER}} .pxl-button .btn:hover',
        ),
    ),
),

array(
    'name' => 'section_style_icon',
    'label' => esc_html__('Icon', 'konstruc' ),
    'tab' => \Elementor\Controls_Manager::TAB_STYLE,
    'controls' => array(
        array(
            'name' => 'icon_color',
            'label' => esc_html__('Color', 'konstruc' ),
            'type' => \Elementor\Controls_Manager::COLOR,
            'selectors' => [
                '{{WRAPPER}} .pxl-button .btn i' => 'color: {{VALUE}};',
                '{{WRAPPER}} .pxl-button .btn svg path' => 'fill: {{VALUE}};',
            ],
        ),
        array(
            'name' => 'icon_hv_color',
            'label' => esc_html__('Color Hover', 'konstruc' ),
            'type' => \Elementor\Controls_Manager::COLOR,
            'selectors' => [
                '{{WRAPPER}} .pxl-button .btn:hover i' => 'color: {{VALUE}};',
                '{{WRAPPER}} .pxl-button .btn:hover svg path' => 'fill: {{VALUE}};',
            ],
        ),

        array(
            'name' => 'icon_bg_color',
            'label' => esc_html__('Background', 'konstruc' ),
            'type' => \Elementor\Controls_Manager::COLOR,
            'selectors' => [
                '{{WRAPPER}} .pxl-button .btn .pxl--btn-icon' => 'background: {{VALUE}};',
            ],
        ),

        array(
            'name' => 'icon_bg_color_hv',
            'label' => esc_html__('Background Hover', 'konstruc' ),
            'type' => \Elementor\Controls_Manager::COLOR,
            'selectors' => [
                '{{WRAPPER}} .pxl-button .btn:hover .pxl--btn-icon' => 'background: {{VALUE}};',
            ],
        ),
        array(
            'name' => 'icon_font_size',
            'label' => esc_html__('Font Size', 'konstruc' ),
            'type' => \Elementor\Controls_Manager::SLIDER,
            'control_type' => 'responsive',
            'size_units' => [ 'px' ],
            'range' => [
                'px' => [
                    'min' => 0,
                    'max' => 300,
                ],
            ],
            'selectors' => [
                '{{WRAPPER}} .pxl-button .btn i' => 'font-size: {{SIZE}}{{UNIT}};',
                '{{WRAPPER}} .pxl-button .btn.btn-default svg' => 'width: {{SIZE}}{{UNIT}};',
                '{{WRAPPER}} .pxl-button .btn-svg:hover svg' => 'width: {{SIZE}}{{UNIT}};',
            ],
        ),

        array(
            'name' => 'icon_box_width',
            'label' => esc_html__('Box Width', 'konstruc' ),
            'type' => \Elementor\Controls_Manager::SLIDER,
            'size_units' => [ 'px' ],
            'range' => [
                'px' => [
                    'min' => 0,
                    'max' => 300,
                ],
            ],
            'selectors' => [
                '{{WRAPPER}} .btn .pxl--btn-icon' => 'width: {{SIZE}}{{UNIT}};min-width: {{SIZE}}{{UNIT}};',
            ],
        ),
        array(
            'name' => 'icon_box_height',
            'label' => esc_html__('Box Height', 'konstruc' ),
            'type' => \Elementor\Controls_Manager::SLIDER,
            'size_units' => [ 'px' ],
            'range' => [
                'px' => [
                    'min' => 0,
                    'max' => 300,
                ],
            ],
            'selectors' => [
                '{{WRAPPER}} .btn .pxl--btn-icon' => 'height: {{SIZE}}{{UNIT}};',
            ],
        ),
        array(
            'name' => 'icon_border_radius',
            'label' => esc_html__('Border Radius', 'konstruc' ),
            'type' => \Elementor\Controls_Manager::DIMENSIONS,
            'size_units' => [ 'px' ],
            'selectors' => [
                '{{WRAPPER}} .btn.pxl-icon-active .pxl--btn-icon' => 'border-radius: {{TOP}}{{UNIT}} {{RIGHT}}{{UNIT}} {{BOTTOM}}{{UNIT}} {{LEFT}}{{UNIT}};',
            ],
        ),
        array(
            'name' => 'icon_space',
            'label' => esc_html__('Icon Spacer', 'konstruc' ),
            'type' => \Elementor\Controls_Manager::SLIDER,
            'control_type' => 'responsive',
            'size_units' => [ 'px' ],
            'range' => [
                'px' => [
                    'min' => 0,
                    'max' => 300,
                ],
            ],
            'selectors' => [
                '{{WRAPPER}} .pxl-button .btn' => 'gap: {{SIZE}}{{UNIT}};',
            ],
        ),
    ),
),
konstruc_widget_animation_settings(),
),
),
),
konstruc_get_class_widget_path()
);