<?php
pxl_add_custom_widget(
    array(
        'name' => 'pxl_categories_box',
        'title' => esc_html__('BR Categories Box', 'konstruc'),
        'icon' => 'eicon-flip-box',
        'categories' => array('pxltheme-core'),
        'params' => array(
            'sections' => array(
                array(
                    'name' => 'tab_content',
                    'label' => esc_html__('Content', 'konstruc'),
                    'tab' => \Elementor\Controls_Manager::TAB_CONTENT,
                    'controls' => array(
                        array(
                            'name' => 'heading_box',
                            'label' => esc_html__('Heading', 'konstruc'),
                            'type' => \Elementor\Controls_Manager::TEXT,
                            'label_block' => true,
                        ),
                        array(
                            'name' => 'cate_box',
                            'label' => esc_html__('Post Box', 'konstruc'),
                            'type' => \Elementor\Controls_Manager::REPEATER,
                            'controls' => array(
                                array(
                                    'name' => 'title',
                                    'label' => esc_html__('Title', 'konstruc'),
                                    'type' => \Elementor\Controls_Manager::TEXT,
                                    'label_block' => true,
                                ),
                                array(
                                    'name' => 'link_item',
                                    'label' => esc_html__('Link', 'konstruc' ),
                                    'type' => \Elementor\Controls_Manager::URL,
                                    'default'   => [
                                        'url'   => '#',
                                    ],
                                ),
                            ),
                            'title_field' => '{{{ title }}}',
                        ),

                    ),
                ),


                array(
                    'name' => 'section_style_general',
                    'label' => esc_html__('General', 'konstruc'),
                    'tab' => \Elementor\Controls_Manager::TAB_STYLE,
                    'controls' => array(
                       array(
                        'name' => 'item_padding',
                        'label' => esc_html__('Padding', 'konstruc' ),
                        'type' => \Elementor\Controls_Manager::DIMENSIONS,
                        'control_type' => 'responsive',
                        'size_units' => [ 'px', 'em', '%', 'rem' ],
                        'selectors' => [
                            '{{WRAPPER}} .pxl-post-box .pxl-item--content' => 'padding: {{TOP}}{{UNIT}} {{RIGHT}}{{UNIT}} {{BOTTOM}}{{UNIT}} {{LEFT}}{{UNIT}};',
                        ],
                    ),
                       array(
                        'name' => 'item_border_radius',
                        'label' => esc_html__('Border Radius', 'konstruc' ),
                        'type' => \Elementor\Controls_Manager::DIMENSIONS,
                        'control_type' => 'responsive',
                        'size_units' => [ 'px', 'em', '%', 'rem' ],
                        'selectors' => [
                            '{{WRAPPER}} .pxl-post-box .pxl-item--content' => 'border-radius: {{TOP}}{{UNIT}} {{RIGHT}}{{UNIT}} {{BOTTOM}}{{UNIT}} {{LEFT}}{{UNIT}};',
                        ],
                    ),
                       array(
                        'name'  => 'heading_title',
                        'label' => esc_html__('TITLE','konstruc'),
                        'type'  => \Elementor\Controls_Manager::HEADING,
                        'separator' => 'before',
                    ),
                       array(
                        'name' => 'title_color',
                        'label' => esc_html__('Color', 'konstruc' ),
                        'type' => \Elementor\Controls_Manager::COLOR,
                        'selectors' => [
                            '{{WRAPPER}} .pxl-post-box .pxl-item--title' => 'color: {{VALUE}};',
                        ],
                    ),
                       array(
                        'name' => 'title_typography',
                        'label' => esc_html__('Typography', 'konstruc' ),
                        'type' => \Elementor\Group_Control_Typography::get_type(),
                        'control_type' => 'group',
                        'selector' => '{{WRAPPER}} .pxl-post-box .pxl-item--title',
                    ),
                   ),
                ),

                konstruc_widget_animation_settings(),
            ),
),
),
konstruc_get_class_widget_path()
);