<?php
pxl_add_custom_widget(
    array(
        'name' => 'pxl_image',
        'title' => esc_html__('BR Image', 'konstruc' ),
        'icon' => 'eicon-image',
        'categories' => array('pxltheme-core'),
        'scripts' => array(
            'tilt',
            'pxl-tweenmax',
            'gsap',
            'scroll-trigger',
        ),
        'params' => array(
            'sections' => array(
                array(
                    'name' => 'tab_content',
                    'label' => esc_html__('Content', 'konstruc' ),
                    'tab' => \Elementor\Controls_Manager::TAB_CONTENT,
                    'controls' => array(
                        array(
                            'name' => 'source_type',
                            'label' => esc_html__('Source Type', 'konstruc' ),
                            'type' => \Elementor\Controls_Manager::SELECT,
                            'options' => [
                                's_img' => 'Select Image',
                                'f_img' => 'Featured Image',
                            ],
                            'default' => 's_img',
                        ),
                        array(
                            'name' => 'image',
                            'label' => esc_html__('Choose Image', 'konstruc' ),
                            'type' => \Elementor\Controls_Manager::MEDIA,
                            'condition' => [
                                'source_type' => ['s_img'],
                            ],
                        ),
                        array(
                            'name' => 'image_link',
                            'label' => esc_html__('Link', 'konstruc' ),
                            'type' => \Elementor\Controls_Manager::URL,
                        ),
                        array(
                            'name' => 'image_type',
                            'label' => esc_html__('Image Type', 'konstruc' ),
                            'type' => \Elementor\Controls_Manager::SELECT,
                            'options' => [
                                'img' => 'Image',
                                'bg' => 'Background',
                            ],
                            'default' => 'img',
                        ),
                        array(
                            'name' => 'img_size',
                            'label' => esc_html__('Image Size', 'konstruc' ),
                            'type' => \Elementor\Controls_Manager::TEXT,
                            'description' => 'Enter image size - Example: "thumbnail", "medium", "large", "full" or other sizes defined by theme. Alternatively enter size in pixels Example: 200x100 - Width x Height.',
                            'condition' => [
                                'image_type' => ['img'],
                            ],
                        ),
                        array(
                            'name' => 'img_label',
                            'label' => esc_html__('Image Label', 'konstruc' ),
                            'type' => \Elementor\Controls_Manager::TEXT,
                            'label_block' => true,
                        ),
                        array(
                            'name'  => 'type_item_content_img',
                            'label' => esc_html__('Select Type','konstruc'),
                            'type'  => \Elementor\Controls_Manager::SELECT,
                            'options'   => [
                                ''      => 'Default',
                                'one-line'  => 'One Line',
                            ],
                            'default'   => '',
                            'control_type'  => 'responsive',
                        ),
                        array(
                            'name' => 'image_align',
                            'label' => esc_html__('Image Alignment', 'konstruc' ),
                            'type' => \Elementor\Controls_Manager::CHOOSE,
                            'control_type' => 'responsive',
                            'options' => [
                                'left' => [
                                    'title' => esc_html__('Left', 'konstruc' ),
                                    'icon' => 'fa fa-align-left',
                                ],
                                'center' => [
                                    'title' => esc_html__('Center', 'konstruc' ),
                                    'icon' => 'fa fa-align-center',
                                ],
                                'right' => [
                                    'title' => esc_html__('Right', 'konstruc' ),
                                    'icon' => 'fa fa-align-right',
                                ],
                            ],
                            'selectors' => [
                                '{{WRAPPER}} .pxl-image-single' => 'text-align: {{VALUE}};',
                            ],
                        ),
                    ),
),
array(
    'name' => 'tab_style_img',
    'label' => esc_html__('Image', 'konstruc' ),
    'tab' => \Elementor\Controls_Manager::TAB_STYLE,
    'controls' => array(
        array(
            'name' => 'image_min_height',
            'label' => esc_html__('Image Height', 'konstruc' ),
            'type' => \Elementor\Controls_Manager::SLIDER,
            'description' => esc_html__('Enter number.', 'konstruc' ),
            'range' => [
                'px' => [
                    'min' => 0,
                    'max' => 3000,
                ],
            ],
            'control_type' => 'responsive',
            'selectors' => [
                '{{WRAPPER}} .pxl-image-single img' => 'height: {{SIZE}}{{UNIT}};',
            ],
            'condition' => [
                'source_type' => 'f_img',
            ],
        ),
        array(
            'name' => 'image_max_height',
            'label' => esc_html__('Image Max Height', 'konstruc' ),
            'type' => \Elementor\Controls_Manager::SLIDER,
            'description' => esc_html__('Enter number.', 'konstruc' ),
            'range' => [
                'px' => [
                    'min' => 0,
                    'max' => 3000,
                ],
            ],
            'control_type' => 'responsive',
            'selectors' => [
                '{{WRAPPER}} .pxl-image-single img' => 'max-height: {{SIZE}}{{UNIT}};',
            ],
            'condition' => [
                'image_type' => 'img',
                'source_type!' => 'f_img',
            ],
        ),
        array(
            'name' => 'image_min_height_2',
            'label' => esc_html__('Image Min Height', 'konstruc' ),
            'type' => \Elementor\Controls_Manager::SLIDER,
            'description' => esc_html__('Enter number.', 'konstruc' ),
            'range' => [
                'px' => [
                    'min' => 0,
                    'max' => 3000,
                ],
            ],
            'control_type' => 'responsive',
            'selectors' => [
                '{{WRAPPER}} .pxl-image-single img' => 'min-height: {{SIZE}}{{UNIT}};',
            ],
            'condition' => [
                'image_type' => 'img',
                'source_type!' => 'f_img',
            ],
        ),
        array(
            'name' => 'image_width',
            'label' => esc_html__('Image Width', 'konstruc' ),
            'type' => \Elementor\Controls_Manager::CHOOSE,
            'options' => [
                'auto' => [
                    'title' => esc_html__( 'Auto', 'konstruc' ),
                    'icon' => 'fas fa-arrows-alt-v',
                ],
                '100%' => [
                    'title' => esc_html__( 'Full', 'konstruc' ),
                    'icon' => 'fas fa-arrows-alt-h',
                ],
            ],
            'selectors' => [
                '{{WRAPPER}} .pxl-image-single img' => 'width: {{VALUE}};',
            ],
            'condition' => [
                'image_type' => 'img',
            ],
            'control_type' => 'responsive',
        ),
        array(
            'name' => 'image_height',
            'label' => esc_html__('Image Height', 'konstruc' ),
            'type' => \Elementor\Controls_Manager::SLIDER,
            'description' => esc_html__('Enter number.', 'konstruc' ),
            'condition' => [
                'image_type' => 'bg',
            ],
            'range' => [
                'px' => [
                    'min' => 0,
                    'max' => 3000,
                ],
            ],
            'control_type' => 'responsive',
            'selectors' => [
                '{{WRAPPER}} .pxl-image-single .pxl-item--bg' => 'height: {{SIZE}}{{UNIT}};',
            ],
        ),

        array(
            'name' => 'border_type',
            'label' => esc_html__( 'Border Type', 'konstruc' ),
            'type' => \Elementor\Controls_Manager::SELECT,
            'options' => [
                '' => esc_html__( 'None', 'konstruc' ),
                'solid' => esc_html__( 'Solid', 'konstruc' ),
                'double' => esc_html__( 'Double', 'konstruc' ),
                'dotted' => esc_html__( 'Dotted', 'konstruc' ),
                'dashed' => esc_html__( 'Dashed', 'konstruc' ),
                'groove' => esc_html__( 'Groove', 'konstruc' ),
                'border-custom' => esc_html__( 'Custom', 'konstruc' ),
            ],
            'default'   => '',
            'selectors' => [
                '{{WRAPPER}} .pxl-image-single img' => 'border-style: {{VALUE}} !important;',
            ],
        ),
        array(
            'name' => 'border_width',
            'label' => esc_html__( 'Border Width', 'konstruc' ),
            'type' => \Elementor\Controls_Manager::DIMENSIONS,
            'selectors' => [
                '{{WRAPPER}} .pxl-image-single img' => 'border-width: {{TOP}}{{UNIT}} {{RIGHT}}{{UNIT}} {{BOTTOM}}{{UNIT}} {{LEFT}}{{UNIT}} !important;',
            ],
            'condition' => [
                'border_type!' => ['','border-custom'],
            ],
            'responsive' => true,
        ),
        array(
            'name' => 'border_width_ct',
            'label' => esc_html__( 'Border Width', 'konstruc' ),
            'type' => \Elementor\Controls_Manager::DIMENSIONS,
            'selectors' => [
                '{{WRAPPER}} .pxl-image-single .border-custom:before' => 'border-width: {{TOP}}{{UNIT}} {{RIGHT}}{{UNIT}} {{BOTTOM}}{{UNIT}} {{LEFT}}{{UNIT}} !important;',
            ],
            'condition' => [
                'border_type' => ['border-custom'],
            ],
            'responsive' => true,
        ),
        array(
            'name' => 'border_color',
            'label' => esc_html__( 'Border Color', 'konstruc' ),
            'type' => \Elementor\Controls_Manager::COLOR,
            'default' => '',
            'selectors' => [
                '{{WRAPPER}} .pxl-image-single img' => 'border-color: {{VALUE}} !important;',
            ],
            'condition' => [
                'border_type!' => ['','border-custom'],
            ],
        ),
        array(
            'name' => 'border_color_ct',
            'label' => esc_html__( 'Border Color', 'konstruc' ),
            'type' => \Elementor\Controls_Manager::COLOR,
            'default' => '',
            'selectors' => [
                '{{WRAPPER}} .pxl-image-single .border-custom:before' => 'border-color: {{VALUE}} !important;',
            ],
            'condition' => [
                'border_type' => ['border-custom'],
            ],
        ),

        array(
            'name' => 'border_position_top',
            'label' => esc_html__('Border Position Top', 'konstruc' ),
            'type' => \Elementor\Controls_Manager::SLIDER,
            'control_type' => 'responsive',
            'size_units' => [ 'px','custom' ],
            'range' => [
                'px' => [
                    'min' => 0,
                    'max' => 100,
                ],
            ],
            'selectors' => [
                '{{WRAPPER}} .pxl-image-single .border-custom:before' => 'top: {{SIZE}}{{UNIT}};',
            ],
            'condition' => [
                'border_type' => ['border-custom'],
            ],
        ),
        array(
            'name' => 'border_position_left',
            'label' => esc_html__('Border Position Left', 'konstruc' ),
            'type' => \Elementor\Controls_Manager::SLIDER,
            'control_type' => 'responsive',
            'size_units' => [ 'px','custom' ],
            'range' => [
                'px' => [
                    'min' => 0,
                    'max' => 100,
                ],
            ],
            'selectors' => [
                '{{WRAPPER}} .pxl-image-single .border-custom:before' => 'left: {{SIZE}}{{UNIT}};',
            ],
            'condition' => [
                'border_type' => ['border-custom'],
            ],
        ),



        array(
            'name'         => 'box_shadow',
            'label' => esc_html__( 'Box Shadow', 'konstruc' ),
            'type'         => \Elementor\Group_Control_Box_Shadow::get_type(),
            'control_type' => 'group',
            'selector'     => '{{WRAPPER}} .pxl-image-single img'
        ),

        array(
            'name' => 'border_radius',
            'label' => esc_html__('Border Radius', 'konstruc' ),
            'type' => \Elementor\Controls_Manager::DIMENSIONS,
            'size_units' => [ 'px' ],
            'selectors' => [
                '{{WRAPPER}} .pxl-image-single img, {{WRAPPER}} .pxl-item--inner' => 'border-radius: {{TOP}}{{UNIT}} {{RIGHT}}{{UNIT}} {{BOTTOM}}{{UNIT}} {{LEFT}}{{UNIT}};',
            ],
        ),

        array(
            'name' => 'border_radius_hover',
            'label' => esc_html__('Border Radius Hover', 'konstruc' ),
            'type' => \Elementor\Controls_Manager::DIMENSIONS,
            'size_units' => [ 'px' ],
            'selectors' => [
                '{{WRAPPER}} .pxl-image-single:hover img, {{WRAPPER}} .pxl-image-single:hover .pxl-item--inner' => 'border-radius: {{TOP}}{{UNIT}} {{RIGHT}}{{UNIT}} {{BOTTOM}}{{UNIT}} {{LEFT}}{{UNIT}};',
            ],
        ),
        
        array(
            'name'  => 'heading_image_effect',
            'label' => esc_html__('IMAGE EFFECT','konstruc'),
            'type'  => \Elementor\Controls_Manager::HEADING,
            'separator' => 'before',
        ),
        
        array(
            'name' => 'img_effect',
            'label' => esc_html__('Image Effect', 'konstruc' ),
            'type' => \Elementor\Controls_Manager::SELECT,
            'options' => [
                '' => 'None',
                'pxl-image-effect1' => 'Zigzag',
                'pxl-image-tilt' => 'Tilt',
                'pxl-image-spin' => 'Spin',
                'pxl-image-zoom' => 'Zoom 1',
                'pxl-image-zoom2' => 'Zoom 2',
                'pxl-image-bounce' => 'Bounce',
                'slide-up-down' => 'Slide Up Down',
                'slide-top-to-bottom' => 'Slide Top To Bottom ',
                'slide-bottom-to-top' => 'Slide Bottom To Top ',
                'slide-right-to-left' => 'Slide Right To Left ',
                'slide-left-to-right' => 'Slide Left To Right ',
                'pxl-hover1' => 'ZoomIn',
                'pxl-hover2' => 'ZoomOut',
                'pxl-animation-round' => 'Round',
                'pxl-image-parallax' => 'Parallax Hover',
                'pxl-image-scale-parallax' => 'Parallax Scale',
                'pxl-parallax-scroll' => 'Parallax Scroll',
                'pxl-image-distortion' => 'Distortion',
            ],
            'default' => '',
            'condition' => [
                'image_type' => 'img',
            ],
        ),
        array(
            'name' => 'parallax_scroll_type',
            'label' => esc_html__('Parallax Scroll Type', 'konstruc' ),
            'type' => \Elementor\Controls_Manager::SELECT,
            'options' => [
                'y' => 'Effect Y',
                'x' => 'Effect X',
                'z' => 'Effect Z',
            ],
            'default' => 'y',
            'condition' => [
                'img_effect' => 'pxl-parallax-scroll',
            ],
        ),
        array(
            'name' => 'parallax_scroll_value_x',
            'label' => esc_html__('Parallax Value', 'konstruc' ),
            'type' => \Elementor\Controls_Manager::TEXT,
            'condition' => [
                'img_effect' => 'pxl-parallax-scroll',
            ],
            'default' => '80',
            'description' => esc_html__('Enter number.', 'konstruc' ),
        ),
        array(
            'name' => 'parallax_value',
            'label' => esc_html__('Parallax Value', 'konstruc' ),
            'type' => \Elementor\Controls_Manager::TEXT,
            'condition' => [
                'img_effect' => 'pxl-image-parallax',
            ],
            'default' => '40',
            'description' => esc_html__('Enter number.', 'konstruc' ),
        ),
        array(
            'name' => 'displacement_img',
            'label' => esc_html__('Displacement Image', 'konstruc'),
            'type' => 'media',
            'default' => [
                'url' => content_url('/uploads/2025/01/displacement-4.webp'),
                'id' => 9031,
            ],
            'condition' => [
                'img_effect' => 'pxl-image-distortion',
            ]
        ),



        array(
            'name' => 'max_tilt',
            'label' => esc_html__('Max Tilt', 'konstruc' ),
            'type' => \Elementor\Controls_Manager::TEXT,
            'condition' => [
                'img_effect' => 'pxl-image-tilt',
            ],
            'default' => '10',
            'description' => esc_html__('Enter number.', 'konstruc' ),
        ),
        array(
            'name' => 'speed_tilt',
            'label' => esc_html__('Speed Tilt', 'konstruc' ),
            'type' => \Elementor\Controls_Manager::TEXT,
            'condition' => [
                'img_effect' => 'pxl-image-tilt',
            ],
            'default' => '400',
            'description' => esc_html__('Enter number.', 'konstruc' ),
        ),
        array(
            'name' => 'perspective_tilt',
            'label' => esc_html__('Perspective Tilt', 'konstruc' ),
            'type' => \Elementor\Controls_Manager::TEXT,
            'condition' => [
                'img_effect' => 'pxl-image-tilt',
            ],
            'default' => '1000',
            'description' => esc_html__('Enter number.', 'konstruc' ),
        ),
        array(
            'name' => 'speed_effect',
            'label' => esc_html__('Speed', 'konstruc' ),
            'type' => \Elementor\Controls_Manager::SLIDER,
            'control_type' => 'responsive',
            'size_units' => [ 'px' ],
            'range' => [
                'px' => [
                    'min' => 0,
                    'max' => 100000,
                ],
            ],
            'selectors' => [
                '{{WRAPPER}} .pxl-image-single, {{WRAPPER}} .pxl-image-single img' => 'animation-duration: {{SIZE}}ms;',
            ],
            'condition' => [
                'img_effect!' => ['pxl-image-tilt','pxl-hover1','pxl-parallax-scroll'],
            ],
            'description' => 'Enter number, unit is ms.',
        ),
        array(
            'name' => 'img_display',
            'label' => esc_html__('Hide on Screen <= 1400px', 'konstruc'),
            'type' => \Elementor\Controls_Manager::SWITCHER,
            'default' => 'false',
        ),
        array(
            'name' => 'overflow_hidden',
            'label' => esc_html__('Overflow', 'konstruc'),
            'type' => \Elementor\Controls_Manager::SELECT,
            'options'   => [
                'default'   => esc_html__("Default",'konstruc'),
                'hidden'    => esc_html__("Hidden",'konstruc'),
            ],
            'default' => 'hidden',
        ),
        array(
            'name' => 'hide_parallax_sm',
            'label' => esc_html__('Disable Parallax on Mobile <= 767px', 'konstruc'),
            'type' => \Elementor\Controls_Manager::SWITCHER,
            'default' => 'false',
            'condition' => [
                'img_effect' => ['pxl-parallax-scroll'],
            ],
        ),
        array(
            'name' => 'heading_overlay',
            'label' => esc_html__('OVERLAY', 'konstruc' ),
            'type'  => \Elementor\Controls_Manager::HEADING,
            'separator' => 'before',
        ),
        array(
            'name' => 'switch_overlay',
            'label' => esc_html__('Overlay', 'konstruc'),
            'type' => \Elementor\Controls_Manager::SWITCHER,
            'default' => 'false',
        ),
        array(
            'name' => 'overlay_color',
            'label' => esc_html__('Overlay Color', 'konstruc' ),
            'type' => \Elementor\Controls_Manager::COLOR,
            'selectors' => [
                '{{WRAPPER}} .pxl-image-single .pxl-overlay-color' => 'background-color: {{VALUE}};',
            ],
            'condition' => [
                'switch_overlay'    => 'true',
            ],
        ),
        array(
            'name' => 'position_top_ovl',
            'label' => esc_html__('Top', 'konstruc' ),
            'type' => \Elementor\Controls_Manager::SLIDER,
            'control_type' => 'responsive',
            'size_units' => [ 'px','%','custom' ],
            'default'    => [
                'unit' => '%'
            ],
            'range' => [
                '%' => [
                    'min' => 0,
                    'max' => 100,
                ],
            ],
            'selectors' => [
                '{{WRAPPER}} .pxl-image-single .pxl-overlay-color' => 'top: {{SIZE}}{{UNIT}};',
            ],
            'condition' => [
                'switch_overlay'    => 'true',
            ],
        ),
        array(
            'name' => 'position_bottom_ovl',
            'label' => esc_html__('Bottom', 'konstruc' ),
            'type' => \Elementor\Controls_Manager::SLIDER,
            'control_type' => 'responsive',
            'size_units' => [ 'px','%','custom' ],
            'default'    => [
                'unit' => '%'
            ],
            'range' => [
                '%' => [
                    'min' => 0,
                    'max' => 100,
                ],
            ],
            'selectors' => [
                '{{WRAPPER}} .pxl-image-single .pxl-overlay-color' => 'bottom: {{SIZE}}{{UNIT}};',
            ],
            'condition' => [
                'switch_overlay'    => 'true',
            ],
        ),
        array(
            'name' => 'height_overlay',
            'label' => esc_html__('Height', 'konstruc' ),
            'type' => \Elementor\Controls_Manager::SLIDER,
            'control_type' => 'responsive',
            'size_units' => [ 'px','%','custom' ],
            'default'    => [
                'unit' => '%'
            ],
            'range' => [
                '%' => [
                    'min' => 0,
                    'max' => 100,
                ],
            ],
            'selectors' => [
                '{{WRAPPER}} .pxl-image-single .pxl-overlay-color' => 'height: {{SIZE}}{{UNIT}};',
            ],
            'condition' => [
                'switch_overlay'    => 'true',
            ],
        ),
        array(
            'name' => 'width_overlay',
            'label' => esc_html__('Width', 'konstruc' ),
            'type' => \Elementor\Controls_Manager::SLIDER,
            'control_type' => 'responsive',
            'size_units' => [ 'px','%','custom' ],
            'default'    => [
                'unit' => '%'
            ],
            'range' => [
                '%' => [
                    'min' => 0,
                    'max' => 100,
                ],
            ],
            'selectors' => [
                '{{WRAPPER}} .pxl-image-single .pxl-overlay-color' => 'width: {{SIZE}}{{UNIT}};',
            ],
            'condition' => [
                'switch_overlay'    => 'true',
            ],
        ),
        array(
            'name' => 'opacity',
            'label' => esc_html__('Opacity (0 - 100)', 'konstruc' ),
            'type' => \Elementor\Controls_Manager::SLIDER,
            'control_type' => 'responsive',
            'size_units' => [ '%' ],
            'default'    => [
                'unit' => '%'
            ],
            'range' => [
                '%' => [
                    'min' => 0,
                    'max' => 100,
                ],
            ],
            'selectors' => [
                '{{WRAPPER}} .pxl-image-single .pxl-overlay-color' => 'opacity: {{SIZE}}%;',
            ],
            'condition' => [
                'switch_overlay'    => 'true',
            ],
        ),
        array(
            'name' => 'z_index_overlay',
            'label' => esc_html__('Z-Index', 'konstruc' ),
            'type' => \Elementor\Controls_Manager::NUMBER,
            'selectors' => [
                '{{WRAPPER}} .pxl-image-single .pxl-overlay-color' => 'z-index: {{VALUE}};',
            ],
            'condition' => [
                'switch_overlay'    => 'true',
            ],
        ),
        array(
            'name' => 'heading_label',
            'label' => esc_html__('Label', 'konstruc' ),
            'type'  => \Elementor\Controls_Manager::HEADING,
            'separator' => 'before',
        ),
        array(
            'name' => 'color_label',
            'label' => esc_html__('Color', 'konstruc' ),
            'type' => \Elementor\Controls_Manager::COLOR,
            'selectors' => [
                '{{WRAPPER}} .pxl-item--label' => 'color: {{VALUE}};',
            ],
        ),
        array(
            'name' => 'typography_label',
            'label' => esc_html__('Typography', 'konstruc' ),
            'type' => \Elementor\Group_Control_Typography::get_type(),
            'control_type' => 'group',
            'selector' => '{{WRAPPER}} .pxl-item--label',
        ),
    ),
),
konstruc_widget_animation_settings(),
),
),
),
konstruc_get_class_widget_path()
);