<?php
pxl_add_custom_widget(
    array(
        'name' => 'pxl_list',
        'title' => esc_html__('BR List', 'konstruc'),
        'icon' => 'eicon-editor-list-ul',
        'categories' => array('pxltheme-core'),
        'params' => array(
            'sections' => array(
                array(
                    'name' => 'section_content',
                    'label' => esc_html__('Content', 'konstruc'),
                    'tab' => \Elementor\Controls_Manager::TAB_CONTENT,
                    'controls' => array(
                        array(
                            'name' => 'title',
                            'label' => esc_html__('Title', 'konstruc' ),
                            'type' => \Elementor\Controls_Manager::TEXT,
                            'label_block' => true,
                        ),
                        array(
                            'name' => 'lists',
                            'label' => esc_html__('Content', 'konstruc'),
                            'type' => \Elementor\Controls_Manager::REPEATER,
                            'controls' => array(
                                array(
                                    'name' => 'content',
                                    'label' => esc_html__('Content', 'konstruc' ),
                                    'type' => \Elementor\Controls_Manager::TEXTAREA,
                                    'rows' => 10,
                                    'show_label' => false,
                                ),
                                array(
                                    'name' => 'link',
                                    'label' => esc_html__('Link', 'konstruc'),
                                    'type' => \Elementor\Controls_Manager::URL,
                                    'label_block' => true,
                                    'default'   => [
                                        'url'   => '#',
                                    ],
                                ),
                            ),
                            'title_field' => '{{{ content }}}',
                        ),
                        array(
                            'name' => 'pxl_icon',
                            'label' => esc_html__('Icon', 'konstruc' ),
                            'type' => \Elementor\Controls_Manager::ICONS,
                            'fa4compatibility' => 'icon',
                        ),
                    ),
                ),
                array(
                    'name' => 'section_style_general',
                    'label' => esc_html__('General', 'konstruc' ),
                    'tab' => \Elementor\Controls_Manager::TAB_STYLE,
                    'controls' => array(
                        array(
                            'name' => 'item_spacer',
                            'label' => esc_html__('Item Spacer', 'konstruc' ),
                            'type' => \Elementor\Controls_Manager::SLIDER,
                            'control_type' => 'responsive',
                            'size_units' => [ 'px' ],
                            'range' => [
                                'px' => [
                                    'min' => 0,
                                    'max' => 3000,
                                ],
                            ],
                            'selectors' => [
                                '{{WRAPPER}} .pxl-list .pxl--item' => 'margin-bottom: {{SIZE}}{{UNIT}};',
                            ],
                        ),

                        array(
                            'name' => 'item_gap',
                            'label' => esc_html__('Item Gap', 'konstruc' ),
                            'type' => \Elementor\Controls_Manager::SLIDER,
                            'control_type' => 'responsive',
                            'size_units' => [ 'px' ],
                            'range' => [
                                'px' => [
                                    'min' => 0,
                                    'max' => 3000,
                                ],
                            ],
                            'selectors' => [
                                '{{WRAPPER}} .pxl-list .pxl--item' => 'gap: {{SIZE}}{{UNIT}};',
                            ],
                        ),

                        array(
                            'name'  => 'heading_title',
                            'label' => esc_html__('TITLE','konstruc'),
                            'type'  => \Elementor\Controls_Manager::HEADING,
                            'separator' => 'before',
                        ),
                        array(
                            'name' => 'title_color',
                            'label' => esc_html__('Color', 'konstruc' ),
                            'type' => \Elementor\Controls_Manager::COLOR,
                            'selectors' => [
                                '{{WRAPPER}} .pxl-list .pxl-item--title ' => 'color: {{VALUE}};',
                            ],
                        ),
                        array(
                            'name' => 'title_typography',
                            'label' => esc_html__('Typography', 'konstruc' ),
                            'type' => \Elementor\Group_Control_Typography::get_type(),
                            'control_type' => 'group',
                            'selector' => '{{WRAPPER}} .pxl-list .pxl-item--title ',
                        ),

                        array(
                            'name' => 'title_margin_bottom',
                            'label' => esc_html__('Margin Bottom', 'konstruc' ),
                            'type' => \Elementor\Controls_Manager::SLIDER,
                            'control_type' => 'responsive',
                            'size_units' => [ 'px' ],
                            'range' => [
                                'px' => [
                                    'min' => 0,
                                    'max' => 3000,
                                ],
                            ],
                            'selectors' => [
                                '{{WRAPPER}} .pxl-list .pxl-item--title' => 'margin-bottom: {{SIZE}}{{UNIT}};',
                            ],
                        ),


                        array(
                            'name'  => 'heading_content',
                            'label' => esc_html__('CONTENT','konstruc'),
                            'type'  => \Elementor\Controls_Manager::HEADING,
                            'separator' => 'before',
                        ),
                        array(
                            'name' => 'content_color',
                            'label' => esc_html__('Color', 'konstruc' ),
                            'type' => \Elementor\Controls_Manager::COLOR,
                            'selectors' => [
                                '{{WRAPPER}} .pxl-list .pxl-item-content a' => 'color: {{VALUE}};',
                            ],
                        ),
                        array(
                            'name' => 'content_color_hv',
                            'label' => esc_html__('Color Hover', 'konstruc' ),
                            'type' => \Elementor\Controls_Manager::COLOR,
                            'selectors' => [
                                '{{WRAPPER}} .pxl-list .pxl-item-content a:hover' => 'color: {{VALUE}};',
                            ],
                        ),
                        array(
                            'name' => 'content_typography',
                            'label' => esc_html__('Typography', 'konstruc' ),
                            'type' => \Elementor\Group_Control_Typography::get_type(),
                            'control_type' => 'group',
                            'selector' => '{{WRAPPER}} .pxl-list .pxl-item-content a',
                        ),


                    ),
                ),

                array(
                    'name' => 'section_style_icon',
                    'label' => esc_html__('Icon', 'konstruc' ),
                    'tab' => \Elementor\Controls_Manager::TAB_STYLE,
                    'controls' => array(

                        array(
                            'name'  => 'general_tabs_controls',
                            'control_type'  => 'tab',
                            'tabs'  => [
                                [
                                    'name'  => 'tab_icon_normal',
                                    'label' => esc_html__('Normal','konstruc'),
                                    'type'  => 'tab',
                                    'controls'  => [
                                        array(
                                            'name' => 'icon_color',
                                            'label' => esc_html__('Color', 'konstruc' ),
                                            'type' => \Elementor\Controls_Manager::COLOR,
                                            'selectors' => [
                                            '{{WRAPPER}} .pxl-list .pxl-item--icon' => 'color: {{VALUE}};',
                                            '{{WRAPPER}} .pxl-list .pxl-item--icon svg' => 'fill: {{VALUE}};',
                                        ],
                                    ),

                                        array(
                                            'name' => 'icon_bg_color',
                                            'label' => esc_html__('Background Color', 'konstruc' ),
                                            'type' => \Elementor\Controls_Manager::COLOR,
                                            'selectors' => [
                                            '{{WRAPPER}} .pxl-list .pxl-item--icon' => 'background: {{VALUE}};',
                                        ],
                                    ),

                                        array(
                                            'name'  => 'box_shadow_icon',
                                            'label' => esc_html__('Box Shadow','konstruc'),
                                            'type'  => \Elementor\Group_Control_Box_Shadow::get_type(),
                                            'control_type'  => 'group',
                                            'selector'  => '{{WRAPPER}} .pxl-list .pxl-item--icon',
                                        ),
                                    ],


                                ],
                                [
                                    'name'  => 'tab_icon_hover',
                                    'label' => esc_html__('Hover','konstruc'),
                                    'type'  => 'tab',
                                    'controls'  => [

                                        array(
                                            'name' => 'icon_color_hover',
                                            'label' => esc_html__('Color', 'konstruc' ),
                                            'type' => \Elementor\Controls_Manager::COLOR,
                                            'selectors' => [
                                            '{{WRAPPER}} .pxl-list .pxl--item:hover .pxl-item--icon' => 'color: {{VALUE}};',
                                            '{{WRAPPER}} .pxl-list .pxl--item:hover .pxl-item--icon svg' => 'fill: {{VALUE}};',
                                        ],
                                    ),

                                        array(
                                            'name' => 'icon_bg_color_hover',
                                            'label' => esc_html__('Background Color', 'konstruc' ),
                                            'type' => \Elementor\Controls_Manager::COLOR,
                                            'selectors' => [
                                            '{{WRAPPER}} .pxl-list .pxl--item:hover .pxl-item--icon' => 'background: {{VALUE}};',
                                        ],
                                    ),

                                        array(
                                            'name'  => 'box_shadow_icon_hover',
                                            'label' => esc_html__('Box Shadow','konstruc'),
                                            'type'  => \Elementor\Group_Control_Box_Shadow::get_type(),
                                            'control_type'  => 'group',
                                            'selector'  => '{{WRAPPER}} .pxl-list .pxl--item:hover .pxl-item--icon',
                                        ),
                                    ],
                                ],

                            ],
                        ),


                        array(
                            'name' => 'icon_margin',
                            'label' => esc_html__('Icon Margin', 'konstruc' ),
                            'type' => \Elementor\Controls_Manager::DIMENSIONS,
                            'size_units' => [ 'px' ],
                            'selectors' => [
                                '{{WRAPPER}} .pxl-list .pxl-item--icon' => 'margin: {{TOP}}{{UNIT}} {{RIGHT}}{{UNIT}} {{BOTTOM}}{{UNIT}} {{LEFT}}{{UNIT}};',
                            ],
                            'control_type' => 'responsive',
                        ),
                        array(
                            'name' => 'icon_border_radius',
                            'label' => esc_html__('Icon Border Radius', 'konstruc' ),
                            'type' => \Elementor\Controls_Manager::DIMENSIONS,
                            'size_units' => [ 'px' ],
                            'selectors' => [
                                '{{WRAPPER}} .pxl-list .pxl-item--icon' => 'border-radius: {{TOP}}{{UNIT}} {{RIGHT}}{{UNIT}} {{BOTTOM}}{{UNIT}} {{LEFT}}{{UNIT}};',
                            ],
                            'control_type' => 'responsive',
                        ),
                        array(
                            'name' => 'icon_font_size',
                            'label' => esc_html__('Icon Font Size', 'konstruc' ),
                            'type' => \Elementor\Controls_Manager::SLIDER,
                            'control_type' => 'responsive',
                            'size_units' => [ 'px' ],
                            'range' => [
                                'px' => [
                                    'min' => 0,
                                    'max' => 3000,
                                ],
                            ],
                            'selectors' => [
                                '{{WRAPPER}} .pxl-list .pxl-item--icon' => 'font-size: {{SIZE}}{{UNIT}};',
                            ],
                        ),
                        array(
                            'name' => 'icon_box_size',
                            'label' => esc_html__('Size Box Icon', 'konstruc' ),
                            'type' => \Elementor\Controls_Manager::SLIDER,
                            'size_units' => [ 'px' ],
                            'selectors' => [
                                '{{WRAPPER}} .pxl-list .pxl-item--icon' => 'height: {{SIZE}}{{UNIT}};width: {{SIZE}}{{UNIT}};',
                            ],
                            'control_type' => 'responsive',
                        ),
                        
                    ),
),

konstruc_widget_animation_settings(),
),
),
),
konstruc_get_class_widget_path()
);