<?php
pxl_add_custom_widget(
    array(
        'name' => 'pxl_marquee',
        'title' => esc_html__('BR Marquee', 'konstruc'),
        'icon' => 'eicon-testimonial',
        'categories' => array('pxltheme-core'),
        'params' => array(
            'sections' => array(
                array(
                    'name' => 'section_content',
                    'label' => esc_html__('Content', 'konstruc'),
                    'tab' => \Elementor\Controls_Manager::TAB_CONTENT,
                    'controls' => array(
                        array(
                            'name' => 'items',
                            'label' => esc_html__('Items', 'konstruc'),
                            'type' => \Elementor\Controls_Manager::REPEATER,
                            'controls' => array(
                                array(
                                    'name' => 'type',
                                    'label' => esc_html__('Type', 'konstruc'),
                                    'type' => \Elementor\Controls_Manager::SELECT,
                                    'options' => array(
                                        'icon' => esc_html__('Icon', 'konstruc'),
                                        'image' => esc_html__('Image', 'konstruc'),
                                        'text' => esc_html__('Text', 'konstruc'),
                                    ),
                                    'default' => 'icon',
                                ),
                                array(
                                    'name' => 'pxl_icon',
                                    'label' => esc_html__('Icon', 'konstruc'),
                                    'type' => \Elementor\Controls_Manager::ICONS,
                                    'fa4compatibility' => 'icon',
                                    'condition' => array(
                                        'type' => 'icon',
                                    ),
                                ),
                                array(
                                    'name' => 'image',
                                    'label' => esc_html__('Image', 'konstruc'),
                                    'type' => \Elementor\Controls_Manager::MEDIA,
                                    'condition' => [
                                        'type' => 'image',
                                    ],
                                ),
                                array(
                                    'name' => 'image_type',
                                    'label' => esc_html__('Image Type', 'konstruc'),
                                    'type' => \Elementor\Controls_Manager::SELECT,
                                    'options' => array(
                                        'image' => esc_html__('Image', 'konstruc'),
                                        'bg' => esc_html__('Background', 'konstruc'),
                                    ),
                                    'default' => 'image',
                                    'condition' => [
                                        'type' => 'image',
                                    ],
                                ),
                                array(
                                    'name' => 'text',
                                    'label' => esc_html__('Text', 'konstruc'),
                                    'type' => \Elementor\Controls_Manager::TEXT,
                                    'condition' => array(
                                        'type' => ['text','image'],
                                    ),
                                ),
                                array(
                                    'name' => 'link',
                                    'label' => esc_html__('Link', 'konstruc' ),
                                    'type' => \Elementor\Controls_Manager::URL,
                                ),
                            ),
                        ),
                    ),
                ),

                array(
                    'name' => 'section_settings_carousel',
                    'label' => esc_html__('Carousel', 'konstruc'),
                    'tab' => \Elementor\Controls_Manager::TAB_SETTINGS,
                    'controls' => array(
                        array(
                            'name' => 'overflow_hidden',
                            'label' => esc_html__('Overflow Hidden', 'konstruc'),
                            'type' => \Elementor\Controls_Manager::SWITCHER,
                            'default' => 'false',
                        ),
                        array(
                            'name' => 'infinite',
                            'label' => esc_html__('Infinite Loop', 'konstruc'),
                            'type' => \Elementor\Controls_Manager::SWITCHER,
                            'default' => 'true',
                        ),
                        array(
                            'name' => 'direction',
                            'label' => esc_html__('Direction', 'konstruc'),
                            'type' => \Elementor\Controls_Manager::SELECT,
                            'default' => 'ltr',
                            'options' => [
                                'ltr' => esc_html__('Left to Right', 'konstruc'), 
                                'rtl' => esc_html__('Right to Left', 'konstruc'), 
                            ]
                        ),
                        array(
                            'name' => 'duration',
                            'label' => esc_html__('Duration', 'konstruc'),
                            'type' => \Elementor\Controls_Manager::NUMBER,
                            'min' => 1,
                            'description' => esc_html__('Enter number. Unit is ms', 'konstruc'),
                            'control_type' => 'responsive',
                            'selectors' => [
                                '{{WRAPPER}} .pxl-marquee .pxl-item--inner .pxl-item--list' => 'animation-duration: {{VALUE}}ms',
                            ],
                        ),
                        array(
                            'name' => 'delay',
                            'label' => esc_html__('Delay', 'konstruc'),
                            'type' => \Elementor\Controls_Manager::NUMBER,
                            'min' => 1,
                            'description' => esc_html__('Enter number. Unit is ms', 'konstruc'),
                            'selectors' => [
                                '{{WRAPPER}} .pxl-marquee .pxl-item--inner .pxl-item--list' => 'animation-delay: {{VALUE}}ms',
                            ],
                        ),
                        array(
                            'name' => 'pause_on_hover',
                            'label' => esc_html__('Pause On Hover', 'konstruc'),
                            'type' => \Elementor\Controls_Manager::SWITCHER,
                            'default' => '',
                        ),
                    ),
                ),
                array(
                    'name' => 'section_style_general',
                    'label' => esc_html__('General', 'konstruc' ),
                    'tab' => \Elementor\Controls_Manager::TAB_STYLE,
                    'controls' => array(
                       array(
                        'name' => 'style_marquee',
                        'label' => esc_html__('Style', 'konstruc'),
                        'type' => \Elementor\Controls_Manager::SELECT,
                        'default' => '',
                        'options' => [
                            '' => esc_html__('Default', 'konstruc'), 
                            'style-overlay' => esc_html__('Overlay', 'konstruc'), 
                        ]
                    ),

                       array(
                        'name' => 'inner',
                        'label' => esc_html__('INNER', 'konstruc'),
                        'type' => \Elementor\Controls_Manager::HEADING,
                    ),
                       array(
                        'name' => 'spacing_x',
                        'label' => esc_html__('Spacer X', 'konstruc'),
                        'type' => \Elementor\Controls_Manager::SLIDER,
                        'size_units' => ['px', '%', 'rem', 'em', 'custom'],
                        'control_type' => 'responsive',
                        'selectors' => [
                            '{{WRAPPER}} .pxl-marquee .pxl-item--inner' => '--x: {{SIZE}}{{UNIT}};--gap: {{SIZE}}{{UNIT}};',
                        ],
                    ),
                       array(
                        'name' => 'max_width',
                        'label' => esc_html__('Max Width', 'konstruc'),
                        'type' => \Elementor\Controls_Manager::SLIDER,
                        'size_units' => ['px', '%', 'rem', 'em', 'custom'],
                        'control_type' => 'responsive',
                        'selectors' => [
                            '{{WRAPPER}} .pxl-marquee .pxl-item--container' => 'max-width: {{SIZE}}{{UNIT}};',
                        ],
                    ),
                   ),
                ),

                array(
                    'name' => 'tab_style_label',
                    'label' => esc_html__('Label', 'konstruc' ),
                    'tab' => \Elementor\Controls_Manager::TAB_STYLE,
                    'controls' => array(
                        array(
                            'name' => 'label_normal',
                            'label' => esc_html__('NORMAL', 'konstruc' ),
                            'type' => \Elementor\Controls_Manager::HEADING,
                            'separator' => 'after', 
                        ),
                        array(
                            'name' => 'label_color',
                            'label' => esc_html__('Color', 'konstruc' ),
                            'type' => \Elementor\Controls_Manager::COLOR,
                            'selectors' => [
                                '{{WRAPPER}} .pxl-marquee .pxl-item--text' => 'color: {{VALUE}}'
                            ],
                        ),
                        array(
                            'name' => 'label_typography',
                            'label' => esc_html__('Typography', 'konstruc' ),
                            'type' => \Elementor\Group_Control_Typography::get_type(),
                            'control_type' => 'group',
                            'selector' => '{{WRAPPER}} .pxl-marquee .pxl-item--text',
                        ),
                        array(
                            'name' => 'label_spacer_bottom',
                            'label' => esc_html__('Spacing Bottom', 'konstruc'),
                            'type' => \Elementor\Controls_Manager::SLIDER,
                            'size_units' => ['px', '%', 'rem', 'em', 'custom'],
                            'control_type' => 'responsive',
                            'selectors' => [
                                '{{WRAPPER}} .pxl-marquee .pxl-item--text' => 'margin-bottom: {{SIZE}}{{UNIT}};',
                            ],
                        ),
                        array(
                            'name' => 'label_padding',
                            'label' => esc_html__( 'Padding', 'konstruc' ),
                            'type' => \Elementor\Controls_Manager::DIMENSIONS,
                            'size_units' => [ 'px', '%', 'em', 'rem', 'custom' ],
                            'control_type' => 'responsive',
                            'selectors' => [
                                '{{WRAPPER}} .pxl-marquee .pxl-item--text' => 'padding: {{TOP}}{{UNIT}} {{RIGHT}}{{UNIT}} {{BOTTOM}}{{UNIT}} {{LEFT}}{{UNIT}};',
                            ],
                        ),

                        array(
                            'name' => 'title_style',
                            'label' => esc_html__('Style', 'konstruc' ),
                            'type' => \Elementor\Controls_Manager::SELECT,
                            'options' => [
                                '' => 'Default',
                                'style-outline' => 'Outline',
                            ],
                            'default' => '',
                        ),
                        array(
                            'name'         => 'title_style_outline',
                            'label' => esc_html__( 'Text Stroke', 'konstruc' ),
                            'type'         => \Elementor\Group_Control_Text_Stroke::get_type(),
                            'control_type' => 'group',
                            'selector'     => '{{WRAPPER}} .pxl-marquee .pxl-item--text',
                            'condition' => [
                             'title_style'  =>  'style-outline',
                         ],
                     ),

                        array(
                            'name' => 'title_style_fill',
                            'label' => esc_html__('Text Fill', 'konstruc' ),
                            'type' => \Elementor\Controls_Manager::COLOR,
                            'selectors' => [
                                '{{WRAPPER}} .pxl-marquee .pxl-item--text' => '-webkit-text-fill-color: {{VALUE}};',
                            ],
                            'condition' => [
                                'title_style' => 'style-outline',
                            ],
                        ),

                    ),
),

array(
    'name' => 'tab_style_img',
    'label' => esc_html__('Image', 'konstruc' ),
    'tab' => \Elementor\Controls_Manager::TAB_STYLE,
    'controls' => array(
        array(
            'name' => 'normal',
            'label' => esc_html__('NORMAL', 'konstruc'),
            'type' => Elementor\Controls_Manager::HEADING,
            'separator' => 'after',
        ),
        array(
            'name' => 'img_size',
            'label' => esc_html__('Image Size', 'konstruc'),
            'type' => \Elementor\Controls_Manager::TEXT,
        ),
        array(
            'name' => 'filters',
            'label' => esc_html__('Filters', 'konstruc'),
            'type' => \Elementor\Group_Control_Css_Filter::get_type(),
            'control_type' => 'group',
            'selector' => '{{WRAPPER}} .pxl-marquee .pxl-item--inner .pxl-item--img img, 
            {{WRAPPER}} .pxl-marquee .pxl-item--inner .pxl-item--bg' 
        ),
        array(
            'name'         => 'box_shadow',
            'label' => esc_html__( 'Box Shadow', 'konstruc' ),
            'type'         => \Elementor\Group_Control_Box_Shadow::get_type(),
            'control_type' => 'group',
            'selector'     => '{{WRAPPER}} .pxl-marquee .pxl-item--inner .pxl-item--img img, 
            {{WRAPPER}} .pxl-marquee .pxl-item--inner .pxl-item--bg'
        ),
        array(
            'name' => 'divider',
            'type' => Elementor\Controls_Manager::DIVIDER,
        ),
        array(
            'name' => 'dimension',
            'label' => esc_html__('DIMENSION', 'konstruc'),
            'type' => Elementor\Controls_Manager::HEADING,
            'separator' => 'after',
        ),
        array(
            'name' => 'image_height',
            'label' => esc_html__('Height', 'konstruc' ),
            'type' => \Elementor\Controls_Manager::SLIDER,
            'unit' => ['px', '%'],  
            'range' => [
                'px' => [
                    'min' => 0,
                    'max' => 3000,
                ],
            ],
            'separator' => 'before',
            'control_type' => 'responsive',
            'selectors' => [
                '{{WRAPPER}} .pxl-marquee .pxl-item--inner .pxl-item--img img,
                {{WRAPPER}} .pxl-marquee .pxl-item--inner .pxl-item--bg' => 'height: {{SIZE}}{{UNIT}};',
            ],
        ),
        array(
            'name' => 'image_min_height',
            'label' => esc_html__('Min Height', 'konstruc' ),
            'type' => \Elementor\Controls_Manager::SLIDER,
            'range' => [
                'px' => [
                    'min' => 0,
                    'max' => 3000,
                ],
            ],
            'control_type' => 'responsive',
            'selectors' => [
                '{{WRAPPER}} .pxl-marquee .pxl-item--inner .pxl-item--img img,
                {{WRAPPER}} .pxl-marquee .pxl-item--inner .pxl-item--bg' => 'min-height: {{SIZE}}{{UNIT}};',
            ],
        ),
        array(
            'name' => 'image_max_height',
            'label' => esc_html__('Max Height', 'konstruc' ),
            'type' => \Elementor\Controls_Manager::SLIDER,
            'range' => [
                'px' => [
                    'min' => 0,
                    'max' => 3000,
                ],
            ],
            'control_type' => 'responsive',
            'selectors' => [
                '{{WRAPPER}} .pxl-marquee .pxl-item--inner .pxl-item--img img,
                {{WRAPPER}} .pxl-marquee .pxl-item--inner .pxl-item--bg' => 'max-height: {{SIZE}}{{UNIT}};',
            ],
        ),
        array(
            'name' => 'image_min_width',
            'label' => esc_html__('Min Width', 'konstruc' ),
            'type' => \Elementor\Controls_Manager::SLIDER,
            'range' => [
                'px' => [
                    'min' => 0,
                    'max' => 3000,
                ],
            ],
            'control_type' => 'responsive',
            'selectors' => [
                '{{WRAPPER}} .pxl-marquee .pxl-item--inner .pxl-item--img img,
                {{WRAPPER}} .pxl-marquee .pxl-item--inner .pxl-item--bg' => 'min-width: {{SIZE}}{{UNIT}};',
            ],
        ),
    ),
),

array(
    'name' => 'section_style_icon',
    'label' => esc_html__('Icon', 'konstruc' ),
    'tab' => \Elementor\Controls_Manager::TAB_STYLE,
    'controls' => array(   
        array(
            'name' => 'icon_normal_options',
            'label' => esc_html__( 'NORMAL', 'konstruc' ),
            'type' => \Elementor\Controls_Manager::HEADING,
            'separator' => 'after',
        ),    
        array(
            'name' => 'icon_color',
            'label' => esc_html__( 'Color', 'konstruc' ),
            'type' => \Elementor\Controls_Manager::COLOR,
            'selectors' => [
                '{{WRAPPER}} .pxl-marquee .pxl-item--inner .pxl-item--icon' => 'color: {{VALUE}}',
                '{{WRAPPER}} .pxl-marquee .pxl-item--inner .pxl-item--icon svg path:not(.not-fill)' => 'fill: {{VALUE}}',
            ],
        ),

        array(
            'name' => 'icon_color_hv',
            'label' => esc_html__( 'Color Hover', 'konstruc' ),
            'type' => \Elementor\Controls_Manager::COLOR,
            'selectors' => [
                '{{WRAPPER}} .pxl-marquee .pxl-item--inner .pxl-item--single:hover .pxl-item--icon' => 'color: {{VALUE}}',
                '{{WRAPPER}} .pxl-marquee .pxl-item--inner .pxl-item--single:hover .pxl-item--icon svg path:not(.not-fill)' => 'fill: {{VALUE}}',
            ],
        ),
        array(
            'name' => 'icon_opacity',
            'label' => esc_html__( 'Opacity', 'konstruc' ),
            'type' => \Elementor\Controls_Manager::NUMBER,
            'min' => 0,
            'max' => 1,
            'step' => 0.1,
            'selectors' => [
                '{{WRAPPER}} .pxl-marquee .pxl-item--inner .pxl-item--icon' => 'opacity: {{VALUE}}',
                '{{WRAPPER}} .pxl-marquee .pxl-item--inner .pxl-item--icon svg path' => 'fill-opacity: {{VALUE}}',
            ],
        ),
        array(
            'name' => 'icon_bg_color',
            'label' => esc_html__( 'Background Color', 'konstruc' ),
            'type' => \Elementor\Controls_Manager::COLOR,
            'selectors' => [
                '{{WRAPPER}} .pxl-marquee .pxl-item--inner .pxl-item--icon' => 'background-color: {{VALUE}}',
            ],
        ),
        array(
            'name' => 'icon_box_border',
            'label' => esc_html__('Border', 'konstruc'),
            'type' => \Elementor\Group_Control_Border::get_type(),
            'control_type' => 'group',
            'selector' => '{{WRAPPER}} .pxl-marquee .pxl-item--inner .pxl-item--icon',
        ),
        array(
            'name' => 'icon_size',
            'label' => esc_html__('Font Size', 'konstruc'),
            'type' => \Elementor\Controls_Manager::SLIDER,
            'size_units' => ['px', '%', 'rem', 'em', 'custom'],
            'control_type' => 'responsive',
            'range' => [
                'px' => [
                    'min' => 0,
                    'max' => 1000,
                ],
            ],
            'selectors' => [
                '{{WRAPPER}} .pxl-marquee .pxl-item--inner .pxl-item--icon' => 'font-size: {{SIZE}}{{UNIT}};',
            ],
        ),
        array(
            'name' => 'icon_box_size',
            'label' => esc_html__('Box Size', 'konstruc'),
            'type' => \Elementor\Controls_Manager::SLIDER,
            'size_units' => ['px', '%', 'rem', 'em', 'custom'],
            'control_type' => 'responsive',
            'range' => [
                'px' => [
                    'min' => 0,
                    'max' => 1000,
                ],
            ],
            'selectors' => [
                '{{WRAPPER}} .pxl-marquee .pxl-item--inner .pxl-item--icon' => '--size: {{SIZE}}{{UNIT}};',
            ],
        ),
        array(
            'name' => 'icon_border_radius',
            'label' => esc_html__( 'Border Radius', 'konstruc' ),
            'type' => \Elementor\Controls_Manager::DIMENSIONS,
            'size_units' => [ 'px', '%', 'em', 'rem', 'custom' ],
            'control_type' => 'responsive',
            'selectors' => [
                '{{WRAPPER}} .pxl-marquee .pxl-item--inner .pxl-item--icon' => 'border-radius: {{TOP}}{{UNIT}} {{RIGHT}}{{UNIT}} {{BOTTOM}}{{UNIT}} {{LEFT}}{{UNIT}};',
            ],
        ),
        array(
            'name' => 'divider2',
            'type' => \Elementor\Controls_Manager::DIVIDER,
        ),
        array(
            'name' => 'svg_options',
            'label' => esc_html__( 'SVG', 'konstruc' ),
            'type' => \Elementor\Controls_Manager::HEADING,
            'separator' => 'after',
        ),
        array(
            'name' => 'svg_width',
            'label' => esc_html__('Width', 'konstruc'),
            'type' => \Elementor\Controls_Manager::SLIDER,
            'size_units' => ['px', '%', 'rem', 'em', 'custom'],
            'control_type' => 'responsive',
            'range' => [
                'px' => [
                    'min' => 0,
                    'max' => 1000,
                ],
            ],
            'selectors' => [
                '{{WRAPPER}} .pxl-marquee .pxl-item--inner .pxl-item--icon svg' => 'width: {{SIZE}}{{UNIT}};',
            ],
        ),
        array(
            'name' => 'svg_height',
            'label' => esc_html__('Height', 'konstruc'),
            'type' => \Elementor\Controls_Manager::SLIDER,
            'size_units' => ['px', '%', 'rem', 'em', 'custom'],
            'control_type' => 'responsive',
            'range' => [
                'px' => [
                    'min' => 0,
                    'max' => 1000,
                ],
            ],
            'selectors' => [
                '{{WRAPPER}} .pxl-marquee .pxl-item--inner .pxl-item--icon svg' => 'height: {{SIZE}}{{UNIT}};',
            ],
        ),
    ),
),

array(
    'name' => 'tab_style_overlay',
    'label' => esc_html__('Overlay', 'konstruc' ),
    'tab' => \Elementor\Controls_Manager::TAB_STYLE,
    'controls' => array(
        array(
            'name' => 'overlay',
            'label' => esc_html__('Overlay', 'konstruc'),
            'type' => \Elementor\Controls_Manager::SWITCHER,
            'default' => '',
        ),
        array(
            'name' => 'overlay_bg',
            'label' => esc_html__('Background', 'konstruc'),
            'type' => \Elementor\Group_Control_Background::get_type(),
            'types' => [ 'classic', 'gradient', 'video' ],
            'control_type' => 'group',
            'selector' => '{{WRAPPER}} .pxl-marquee .pxl-item--inner .pxl-item--overlay' ,
            'condition' => [
                'overlay!' => '',
            ] ,
        ),
        array(                            
            'name' => 'overlay_orientation_v',
            'label' => esc_html__('Vertical Orientation', 'konstruc'),
            'type' => \Elementor\Controls_Manager::CHOOSE,
            'control_type' => 'responsive',
            'options' => [
                'top' => [
                    'label' => esc_html__('Top', 'konstruc'), 
                    'icon' => 'eicon-v-align-top'
                ],
                'bottom' => [
                    'label' => esc_html__('Bottom', 'konstruc'), 
                    'icon' => 'eicon-v-align-bottom'
                ],
            ],
            'selectors' => [
                '{{WRAPPER}} .pxl-marquee .pxl-item--inner .pxl-item--overlay' => '{{VALUE}}: 0;',
            ],
            'condition' => [
                'overlay!' => '',
            ] ,
        ),
        array(
            'name' => 'overlay_offset_top',
            'label' => esc_html__('Top', 'konstruc' ),
            'type' => \Elementor\Controls_Manager::SLIDER,
            'size_units' => [ 'px','%','em','rem', 'custom' ],
            'control_type' => 'responsive',
            'default' => [
                'unit' => 'px',
                'size' => 0,
            ],
            'range' => [
                'px' => [
                    'min' => 1,
                    'max' => 1000,
                ],
            ],
            'condition' => [
                'overlay_orientation_v' => 'top',

            ],
            'selectors' => [
                '{{WRAPPER}} .pxl-marquee .pxl-item--inner .pxl-item--overlay' => 'top: {{SIZE}}{{UNIT}};bottom: auto;',
            ],
        ),
        array(
            'name' => 'overlay_offset_bottom',
            'label' => esc_html__('Bottom', 'konstruc' ),
            'type' => \Elementor\Controls_Manager::SLIDER,
            'size_units' => [ 'px','%','em','rem', 'custom' ],
            'control_type' => 'responsive',
            'range' => [
                'px' => [
                    'min' => 1,
                    'max' => 1000,
                ],
            ],
            'default' => [
                'unit' => 'px',
                'size' => 0,
            ],
            'condition' => [
                'overlay_orientation_v' => 'bottom',
            ],
            'selectors' => [
                '{{WRAPPER}} .pxl-marquee .pxl-item--inner .pxl-item--overlay' => 'bottom: {{SIZE}}{{UNIT}};top: auto;',
            ],
        ),
        array(
            'name' => 'overlay_filters',
            'label' => esc_html__('Filters', 'konstruc'),
            'type' => \Elementor\Group_Control_Css_Filter::get_type(),
            'control_type' => 'group',
            'selector' => '{{WRAPPER}} .pxl-marquee .pxl-item--inner .pxl-item--overlay' ,
            'condition' => [
                'overlay!' => '',
            ] ,
        ),
        array(
            'name' => 'overlay_height',
            'label' => esc_html__('Height', 'konstruc' ),
            'type' => \Elementor\Controls_Manager::SLIDER,
            'unit' => ['px', '%'],  
            'range' => [
                'px' => [
                    'min' => 0,
                    'max' => 3000,
                ],
            ],
            'control_type' => 'responsive',
            'selectors' => [
                '{{WRAPPER}} .pxl-marquee .pxl-item--inner .pxl-item--overlay' => 'height: {{SIZE}}{{UNIT}};',
            ],
            'condition' => [
                'overlay!' => '',
            ] ,
        ),
    ),
),
konstruc_widget_animation_settings(),
),
),
),
konstruc_get_class_widget_path()
);