<?php
pxl_add_custom_widget(
    array(
        'name' => 'pxl_post_box',
        'title' => esc_html__('BR Post Box', 'konstruc'),
        'icon' => 'eicon-flip-box',
        'categories' => array('pxltheme-core'),
        'params' => array(
            'sections' => array(
                array(
                    'name' => 'tab_layout',
                    'label' => esc_html__('Layout', 'konstruc' ),
                    'tab' => \Elementor\Controls_Manager::TAB_LAYOUT,
                    'controls' => array(
                        array(
                            'name' => 'layout',
                            'label' => esc_html__('Templates', 'konstruc' ),
                            'type' => 'layoutcontrol',
                            'default' => '1',
                            'options' => [
                                '1' => [
                                    'label' => esc_html__('Layout 1', 'konstruc' ),
                                    'image' => get_template_directory_uri() . '/elements/widgets/img-layout/pxl_post_box/layout1.jpg'
                                ],
                            ],
                        ),
                    ),
                ),
                array(
                    'name' => 'tab_content',
                    'label' => esc_html__('Content', 'konstruc'),
                    'tab' => \Elementor\Controls_Manager::TAB_CONTENT,
                    'controls' => array(
                        array(
                            'name' => 'heading_box',
                            'label' => esc_html__('Heading', 'konstruc'),
                            'type' => \Elementor\Controls_Manager::TEXT,
                            'label_block' => true,
                        ),
                        array(
                            'name' => 'post_box',
                            'label' => esc_html__('Post Box', 'konstruc'),
                            'type' => \Elementor\Controls_Manager::REPEATER,
                            'controls' => array(
                                array(
                                    'name' => 'title',
                                    'label' => esc_html__('Title', 'konstruc'),
                                    'type' => \Elementor\Controls_Manager::TEXT,
                                    'label_block' => true,
                                ),
                                array(
                                    'name' => 'data_field',
                                    'label' => esc_html__('Data Field', 'konstruc'),
                                    'type' => \Elementor\Controls_Manager::TEXT,
                                    'label_block' => true,
                                    'description'   => 'Data Field: category, date, author, tags!
                                    </br> If no data field is present, custom text will be displayed.',

                                ),
                                array(
                                    'name' => 'link_item',
                                    'label' => esc_html__('Link', 'konstruc' ),
                                    'type' => \Elementor\Controls_Manager::URL,
                                ),
                            ),
                            'title_field' => '{{{ title }}}',
                        ),

                    ),
                ),


                array(
                    'name' => 'section_style_general',
                    'label' => esc_html__('General', 'konstruc'),
                    'tab' => \Elementor\Controls_Manager::TAB_STYLE,
                    'controls' => array(
                     array(
                        'name' => 'item_padding',
                        'label' => esc_html__('Padding', 'konstruc' ),
                        'type' => \Elementor\Controls_Manager::DIMENSIONS,
                        'control_type' => 'responsive',
                        'size_units' => [ 'px', 'em', '%', 'rem' ],
                        'selectors' => [
                            '{{WRAPPER}} .pxl-post-box .pxl-item--content' => 'padding: {{TOP}}{{UNIT}} {{RIGHT}}{{UNIT}} {{BOTTOM}}{{UNIT}} {{LEFT}}{{UNIT}};',
                        ],
                    ),
                     array(
                        'name' => 'item_border_radius',
                        'label' => esc_html__('Border Radius', 'konstruc' ),
                        'type' => \Elementor\Controls_Manager::DIMENSIONS,
                        'control_type' => 'responsive',
                        'size_units' => [ 'px', 'em', '%', 'rem' ],
                        'selectors' => [
                            '{{WRAPPER}} .pxl-post-box .pxl-item--content' => 'border-radius: {{TOP}}{{UNIT}} {{RIGHT}}{{UNIT}} {{BOTTOM}}{{UNIT}} {{LEFT}}{{UNIT}};',
                        ],
                    ),
                     array(
                        'name'  => 'heading_title',
                        'label' => esc_html__('TITLE','konstruc'),
                        'type'  => \Elementor\Controls_Manager::HEADING,
                        'separator' => 'before',
                    ),
                     array(
                        'name' => 'title_color',
                        'label' => esc_html__('Color', 'konstruc' ),
                        'type' => \Elementor\Controls_Manager::COLOR,
                        'selectors' => [
                            '{{WRAPPER}} .pxl-post-box .pxl-item--title' => 'color: {{VALUE}};',
                        ],
                    ),
                     array(
                        'name' => 'title_typography',
                        'label' => esc_html__('Typography', 'konstruc' ),
                        'type' => \Elementor\Group_Control_Typography::get_type(),
                        'control_type' => 'group',
                        'selector' => '{{WRAPPER}} .pxl-post-box .pxl-item--title',
                    ),

                     array(
                        'name'  => 'heading_data_field',
                        'label' => esc_html__('DATA FIELD','konstruc'),
                        'type'  => \Elementor\Controls_Manager::HEADING,
                        'separator' => 'before',
                    ),
                     array(
                        'name' => 'data_field_color',
                        'label' => esc_html__('Color', 'konstruc' ),
                        'type' => \Elementor\Controls_Manager::COLOR,
                        'selectors' => [
                            '{{WRAPPER}} .pxl-post-box.pxl-post-box1 .data-field,
                            {{WRAPPER}} .pxl-post-box.pxl-post-box1 .data-field a' => 'color: {{VALUE}};',
                        ],
                    ),
                     array(
                        'name' => 'data_field_typography',
                        'label' => esc_html__('Typography', 'konstruc' ),
                        'type' => \Elementor\Group_Control_Typography::get_type(),
                        'control_type' => 'group',
                        'selector' => '{{WRAPPER}} .pxl-post-box.pxl-post-box1 .data-field,{{WRAPPER}} .pxl-post-box.pxl-post-box1 .data-field a',
                    ),

                 ),
                ),

                konstruc_widget_animation_settings(),
            ),
),
),
konstruc_get_class_widget_path()
);