<?php
pxl_add_custom_widget(
    array(
        'name' => 'pxl_pricing',
        'title' => esc_html__('BR Pricing', 'konstruc'),
        'icon' => 'eicon-settings',
        'categories' => array('pxltheme-core'),
        'params' => array(
            'sections' => array(
                array(
                    'name' => 'section_layout',
                    'label' => esc_html__('Layout', 'konstruc' ),
                    'tab' => \Elementor\Controls_Manager::TAB_LAYOUT,
                    'controls' => array(
                        array(
                            'name' => 'layout',
                            'label' => esc_html__('Templates', 'konstruc' ),
                            'type' => 'layoutcontrol',
                            'default' => '1',
                            'options' => [
                                '1' => [
                                    'label' => esc_html__('Layout 1', 'konstruc' ),
                                    'image' => get_template_directory_uri() . '/elements/widgets/img-layout/pxl_pricing/layout1.jpg'
                                ],
                            ],
                        ),
                    ),
                ),
                array(
                    'name' => 'section_content',
                    'label' => esc_html__('Content', 'konstruc'),
                    'tab' => \Elementor\Controls_Manager::TAB_CONTENT,
                    'controls' => array(
                        array(
                            'name' => 'popular',
                            'label' => esc_html__('Popular', 'konstruc' ),
                            'type' => \Elementor\Controls_Manager::SELECT,
                            'options' => [
                                'is-popular' => 'Yes',
                                '' => 'No',
                            ],
                            'default' => '',
                        ),

                        array(
                            'name' => 'plan_box',
                            'label' => esc_html__('Plan Box', 'konstruc' ),
                            'type' => \Elementor\Controls_Manager::TEXT,
                            'label_block' => true,
                            'condition' => [
                                'popular'   => 'is-popular',
                            ],
                        ),

                        array(
                            'name' => 'title_box',
                            'label' => esc_html__('Box Title ', 'konstruc' ),
                            'type' => \Elementor\Controls_Manager::TEXT,
                            'label_block' => true,
                        ),

                        array(
                            'name' => 'desc',
                            'label' => esc_html__('Description ', 'konstruc' ),
                            'type' => \Elementor\Controls_Manager::TEXTAREA,
                            'label_block' => true,
                        ),
                        
                        array(
                            'name' => 'currency',
                            'label' => esc_html__('Currency', 'konstruc' ),
                            'type' => \Elementor\Controls_Manager::TEXT,
                        ),

                        array(
                            'name' => 'price',
                            'label' => esc_html__('Price', 'konstruc' ),
                            'type' => \Elementor\Controls_Manager::TEXT,
                        ),

                        array(
                            'name' => 'billing_cycle',
                            'label' => esc_html__('Billing Cycle', 'konstruc' ),
                            'type' => \Elementor\Controls_Manager::TEXT,
                        ),

                        array(
                            'name' => 'button_text',
                            'label' => esc_html__('Button Text', 'konstruc' ),
                            'type' => \Elementor\Controls_Manager::TEXT,
                            'default' => '',
                        ),
                        array(
                            'name' => 'button_link',
                            'label' => esc_html__('Button Link', 'konstruc' ),
                            'type' => \Elementor\Controls_Manager::URL,
                            'default'  => [
                                'url'   => '#',
                            ],
                        ),

                        array(
                            'name' => 'title_feature',
                            'label' => esc_html__('Title Feature', 'konstruc' ),
                            'type' => \Elementor\Controls_Manager::TEXT,
                            'label_block' => true,
                        ),
                        array(
                            'name' => 'feature',
                            'label' => esc_html__('List Feature', 'konstruc'),
                            'type' => \Elementor\Controls_Manager::REPEATER,
                            'controls' => array(
                                array(
                                    'name' => 'feature_text',
                                    'label' => esc_html__('Text', 'konstruc'),
                                    'type' => \Elementor\Controls_Manager::TEXT,
                                    'label_block' => true,
                                ),
                                array(
                                    'name' => 'active',
                                    'label' => esc_html__('Active', 'konstruc' ),
                                    'type' => \Elementor\Controls_Manager::SELECT,
                                    'options' => [
                                        'non-active' => 'No',
                                        'is-active' => 'Yes',
                                    ],
                                    'default' => 'is-active',
                                ),
                            ),
                            'title_field' => '{{{ feature_text }}}',

                        ),
                    ),
                ),
array(
    'name' => 'section_style_general',
    'label' => esc_html__('Box', 'konstruc' ),
    'tab' => \Elementor\Controls_Manager::TAB_STYLE,
    'controls' => array(
        array(
            'name' => 'padding',
            'label' => esc_html__('Content Padding', 'konstruc' ),
            'type' => \Elementor\Controls_Manager::DIMENSIONS,
            'size_units' => [ 'px' ],
            'control_type' => 'responsive',
            'selectors' => [
                '{{WRAPPER}} .pxl-pricing' => 'padding: {{TOP}}{{UNIT}} {{RIGHT}}{{UNIT}} {{BOTTOM}}{{UNIT}} {{LEFT}}{{UNIT}};',
            ],
        ),
        array(
            'name' => 'box_color',
            'label' => esc_html__('Box Color', 'konstruc' ),
            'type' => \Elementor\Controls_Manager::COLOR,
            'selectors' => [
                '{{WRAPPER}} .pxl-pricing' => 'background-color: {{VALUE}} !important;',
            ],
        ),
        array(
            'name'         => 'btn_box_shadow',
            'label' => esc_html__( 'Box Shadow', 'konstruc' ),
            'type'         => \Elementor\Group_Control_Box_Shadow::get_type(),
            'control_type' => 'group',
            'selector'     => '{{WRAPPER}} .pxl-pricing',
        ),
        array(
            'name' => 'border_box',
            'label' => esc_html__('Border', 'konstruc' ),
            'type' => \Elementor\Group_Control_Border::get_type(),
            'control_type' => 'group',
            'selector' => '{{WRAPPER}} .pxl-pricing',
        ),

        
    ),
),
array(
    'name' => 'section_style_tlb',
    'label' => esc_html__('Title Box', 'konstruc' ),
    'tab' => \Elementor\Controls_Manager::TAB_STYLE,
    'controls' => array(
        array(
            'name' => 'tlb_typography',
            'label' => esc_html__('Typography', 'konstruc' ),
            'type' => \Elementor\Group_Control_Typography::get_type(),
            'control_type' => 'group',
            'selector' => '{{WRAPPER}} .pxl-pricing .pxl-item--title-box',
        ),
        array(
            'name' => 'title_color',
            'label' => esc_html__('Title Color', 'konstruc' ),
            'type' => \Elementor\Controls_Manager::COLOR,
            'selectors' => [
                '{{WRAPPER}} .pxl-pricing .pxl-item--title-box' => 'color: {{VALUE}} !important;',
                '{{WRAPPER}} .pxl-pricing .pxl-item--title-box svg path' => 'fill: {{VALUE}} !important;',
            ],
        ),
    ),
),
array(
    'name' => 'section_style_pr',
    'label' => esc_html__('Pricing', 'konstruc' ),
    'tab' => \Elementor\Controls_Manager::TAB_STYLE,
    'controls' => array(
        
        array(
            'name' => 'price_color',
            'label' => esc_html__('Price', 'konstruc' ),
            'type' => \Elementor\Controls_Manager::COLOR,
            'selectors' => [
                '{{WRAPPER}} .pxl-pricing .pxl--price ' => 'color: {{VALUE}};',
            ],
        ),
        array(
            'name' => 'price_typography',
            'label' => esc_html__('Typography', 'konstruc' ),
            'type' => \Elementor\Group_Control_Typography::get_type(),
            'control_type' => 'group',
            'selector' => '{{WRAPPER}} .pxl-pricing .pxl--price .pxl-item--cost',
        ),


        array(
            'name'  => 'heading_billing_cycle',
            'label' => esc_html__('Billing Cycle','konstruc'),
            'type'  => \Elementor\Controls_Manager::HEADING,
            'separator' => 'before',
        ),
        array(
            'name' => 'billing_color',
            'label' => esc_html__('Color', 'konstruc' ),
            'type' => \Elementor\Controls_Manager::COLOR,
            'selectors' => [
                '{{WRAPPER}} .pxl-pricing .pxl-item--price span' => 'color: {{VALUE}};',
            ],
        ),
        array(
            'name' => 'billing_typography',
            'label' => esc_html__('Typography', 'konstruc' ),
            'type' => \Elementor\Group_Control_Typography::get_type(),
            'control_type' => 'group',
            'selector' => '{{WRAPPER}} .pxl-pricing .pxl-item--price span',
        ),
    ),
),
array(
    'name' => 'section_style_des',
    'label' => esc_html__('Description', 'konstruc' ),
    'tab' => \Elementor\Controls_Manager::TAB_STYLE,
    'controls' => array(

        array(
            'name' => 'ds_typography',
            'label' => esc_html__('Typography', 'konstruc' ),
            'type' => \Elementor\Group_Control_Typography::get_type(),
            'control_type' => 'group',
            'selector' => '{{WRAPPER}} .pxl-pricing .pxl-item-description',
        ),
        array(
            'name' => 'des_color',
            'label' => esc_html__('Description Color', 'konstruc' ),
            'type' => \Elementor\Controls_Manager::COLOR,
            'selectors' => [
                '{{WRAPPER}} .pxl-pricing .pxl-item-description' => 'color: {{VALUE}};',
            ],
        ),
    ),
),
array(
    'name' => 'section_style_feature',
    'label' => esc_html__('Feature', 'konstruc' ),
    'tab' => \Elementor\Controls_Manager::TAB_STYLE,
    'controls' => array(
        array(
            'name' => 'ft_typography',
            'label' => esc_html__('Typography', 'konstruc' ),
            'type' => \Elementor\Group_Control_Typography::get_type(),
            'control_type' => 'group',
            'selector' => '{{WRAPPER}} .pxl-pricing .pxl-item--feature .content',
        ),
        array(
            'name' => 'feature_color',
            'label' => esc_html__('Feature Color', 'konstruc' ),
            'type' => \Elementor\Controls_Manager::COLOR,
            'selectors' => [
                '{{WRAPPER}} .pxl-pricing .pxl-text--feature' => 'color: {{VALUE}} !important;',
                '{{WRAPPER}} .pxl-pricing .pxl-text--feature i' => 'color: {{VALUE}} !important;',
            ],
        ),
        array(
            'name' => 'ic_color_noactive',
            'label' => esc_html__('Feature Color (No Active)', 'konstruc' ),
            'type' => \Elementor\Controls_Manager::COLOR,
            'selectors' => [
                '{{WRAPPER}} .pxl-pricing .pxl-item--feature .non-active svg path' => 'fill: {{VALUE}} !important;',
                '{{WRAPPER}} .pxl-pricing .pxl-item--feature .non-active .content' => 'color: {{VALUE}} !important;',
            ],
        ),
    ),
),

array(
    'name' => 'section_style_button',
    'label' => esc_html__('Button', 'konstruc' ),
    'tab' => \Elementor\Controls_Manager::TAB_STYLE,
    'controls' => array(


        array(
            'name' => 'button_color',
            'label' => esc_html__(' Color', 'konstruc' ),
            'type' => \Elementor\Controls_Manager::COLOR,
            'selectors' => [
                '{{WRAPPER}} .pxl-pricing .pxl-item--button' => 'color: {{VALUE}} !important;',
            ],
        ),
        array(
            'name' => 'button_color_hv',
            'label' => esc_html__(' Color Hover', 'konstruc' ),
            'type' => \Elementor\Controls_Manager::COLOR,
            'selectors' => [
                '{{WRAPPER}} .pxl-pricing .pxl-item--button:hover' => 'color: {{VALUE}} !important;',
            ],
        ),

        array(
            'name' => 'buttonbg_color',
            'label' => esc_html__('Background Color', 'konstruc' ),
            'type' => \Elementor\Controls_Manager::COLOR,
            'selectors' => [
                '{{WRAPPER}} .pxl-pricing .pxl-item--button' => 'background-color: {{VALUE}} !important;',
            ],
        ),
        array(
            'name' => 'buttonbg_color_hv',
            'label' => esc_html__('Background Color Hover', 'konstruc' ),
            'type' => \Elementor\Controls_Manager::COLOR,
            'selectors' => [
                '{{WRAPPER}} .pxl-pricing .pxl-item--button:hover' => 'background-color: {{VALUE}} !important;',
            ],
        ),


        array(
            'name'  => 'heading_icon',
            'label' => esc_html__('Icon','konstruc'),
            'type'  => \Elementor\Controls_Manager::HEADING,
            'separator' => 'before',
        ),

        array(
            'name' => 'button_icon_color',
            'label' => esc_html__('Color', 'konstruc' ),
            'type' => \Elementor\Controls_Manager::COLOR,
            'selectors' => [
                '{{WRAPPER}} .pxl-pricing .pxl-item--button .pxl--btn-icon svg' => 'color: {{VALUE}};',
            ],
        ),

        array(
            'name' => 'button_icon_bg_color',
            'label' => esc_html__('Background', 'konstruc' ),
            'type' => \Elementor\Controls_Manager::COLOR,
            'selectors' => [
                '{{WRAPPER}} .pxl-pricing .pxl-item--button .pxl--btn-icon' => 'background: {{VALUE}};',
            ],
        ),


        array(
            'name' => 'border_box_button',
            'label' => esc_html__('Border', 'konstruc' ),
            'type' => \Elementor\Group_Control_Border::get_type(),
            'control_type' => 'group',
            'selector' => '{{WRAPPER}} .pxl-pricing .pxl-item--button',
        ),
    ),
),konstruc_widget_animation_settings(),
),
),
),konstruc_get_class_widget_path()
);