<?php
// Register Logo Widget
pxl_add_custom_widget(
    array(
        'name' => 'pxl_showcase',
        'title' => esc_html__('BR Showcase', 'konstruc' ),
        'icon' => 'eicon-editor-list-ul',
        'categories' => array('pxltheme-core'),
        'params' => array(
            'sections' => array(
                array(
                    'name' => 'tab_layout',
                    'label' => esc_html__('Layout', 'konstruc'),
                    'tab' => \Elementor\Controls_Manager::TAB_LAYOUT,
                    'controls' => array(
                        array(
                            'name' => 'layout',
                            'label' => esc_html__('Templates', 'konstruc'),
                            'type' => 'layoutcontrol',
                            'default' => '1',
                            'options' => array(
                                '1' => array(
                                    'label' => esc_html__('Layout 1', 'konstruc'),
                                    'image' => get_template_directory_uri() . '/elements/assets/img/pxl_showcase/layout1.jpg',
                                ),
                            ),
                        ),
                    ),
                ),
                array(
                    'name' => 'section_content',
                    'label' => esc_html__('Items', 'konstruc' ),
                    'tab' => \Elementor\Controls_Manager::TAB_CONTENT,
                    'controls' => array(
                        array(
                            'name' => 'img_size',
                            'label' => esc_html__('Image Size', 'konstruc' ),
                            'type' => \Elementor\Controls_Manager::TEXT,
                            'placeholder' => 'Ex: 200x100(WxH), thumbnail, medium...',
                        ),
                        array(
                            'name' => 'image_min_height',
                            'label' => esc_html__('Image Min Height', 'konstruc' ),
                            'type' => \Elementor\Controls_Manager::SLIDER,
                            'control_type' => 'responsive',
                            'size_units' => [ 'px' ],
                            'range' => [
                                'px' => [
                                    'min' => 0,
                                    'max' => 500,
                                ],
                            ],
                            'selectors' => [
                                '{{WRAPPER}} .pxl-showcase .pxl-item--showcase' => '--height: {{SIZE}}{{UNIT}};',
                            ],
                        ),
                        array(
                            'name' => 'button_text',
                            'label' => esc_html__('Button Text', 'konstruc' ),
                            'type' => \Elementor\Controls_Manager::TEXT,
                            'default' => esc_html__('MULTIPAGE DEMOS', 'konstruc'),
                        ),
                        array(
                            'name' => 'button_text2',
                            'label' => esc_html__('Button Text 2', 'konstruc' ),
                            'type' => \Elementor\Controls_Manager::TEXT,
                            'default' => esc_html__('SINGLE DEMOS', 'konstruc'),
                        ),
                        array(
                            'name' => 'coming_soon_text',
                            'label' => esc_html__('Coming Soon Text', 'konstruc' ),
                            'type' => \Elementor\Controls_Manager::TEXT,
                            'default' => esc_html__('Coming Soon', 'konstruc'),
                        ),
                        array(
                            'name' => 'cases',
                            'label' => esc_html__('Cases', 'konstruc'),
                            'type' => \Elementor\Controls_Manager::REPEATER,
                            'controls' => array(
                                array(
                                    'name' => 'is_coming_soon',
                                    'label' => esc_html__('Cooming Soon', 'konstruc' ),
                                    'type' => \Elementor\Controls_Manager::SWITCHER,
                                    'return_value' => 'yes',
                                    'default'   => 'no',
                                ),
                                
                                array(
                                    'name' => 'title',
                                    'label' => esc_html__('Title', 'konstruc' ),
                                    'type' => \Elementor\Controls_Manager::TEXT,
                                    
                                ),
                                
                                array(
                                    'name' => 'image',
                                    'label' => esc_html__('Upload', 'konstruc' ),
                                    'type' => \Elementor\Controls_Manager::MEDIA,
                                ),
                                array(
                                    'name' => 'link',
                                    'label' => esc_html__('Link', 'konstruc' ),
                                    'type' => \Elementor\Controls_Manager::URL,
                                ),
                                array(
                                    'name' => 'link2',
                                    'label' => esc_html__('Link 2', 'konstruc' ),
                                    'type' => \Elementor\Controls_Manager::URL,
                                ),
                            ),
                        ),
                        array(
                            'name' => 'pxl_icon',
                            'label' => esc_html__('Icon', 'konstruc' ),
                            'type' => \Elementor\Controls_Manager::ICONS,
                            'fa4compatibility' => 'icon',
                            'condition' => [
                                'layout'    => '2',
                            ],
                        ),
                    ),
),
array(
    'name' => 'tab_style',
    'label' => esc_html__('General', 'konstruc' ),
    'tab' => \Elementor\Controls_Manager::TAB_STYLE,
    'controls' => array_merge(
        array(

            array(
                'name' => 'padding_item',
                'label' => esc_html__('Padding Item', 'konstruc' ),
                'type' => \Elementor\Controls_Manager::DIMENSIONS,
                'size_units' => [ 'px', 'custom'],
                'selectors' => [
                    '{{WRAPPER}} .pxl-showcase .pxl-item--showcase' => 'padding: {{TOP}}{{UNIT}} {{RIGHT}}{{UNIT}} {{BOTTOM}}{{UNIT}} {{LEFT}}{{UNIT}};',
                ],
                'control_type' => 'responsive',
            ),

            array(
                'name' => 'border_radius_item',
                'label' => esc_html__('Border Radius Item', 'konstruc' ),
                'type' => \Elementor\Controls_Manager::DIMENSIONS,
                'size_units' => [ 'px', 'custom'],
                'selectors' => [
                    '{{WRAPPER}} .pxl-showcase .pxl-item--showcase' => 'border-radius: {{TOP}}{{UNIT}} {{RIGHT}}{{UNIT}} {{BOTTOM}}{{UNIT}} {{LEFT}}{{UNIT}};',
                ],
                'control_type' => 'responsive',
            ),

            array(
                'name' => 'border_item',
                'label' => esc_html__('Border', 'konstruc' ),
                'type' => \Elementor\Group_Control_Border::get_type(),
                'control_type' => 'group',
                'selector' => '{{WRAPPER}} .pxl-showcase .pxl-item--showcase',
            ),

            array(
                'name'  => 'heading_title',
                'label' => esc_html__('TITLE','konstruc'),
                'type'  => \Elementor\Controls_Manager::HEADING,
                'separator' => 'before',
            ),
            array(
                'name' => 'title_color',
                'label' => esc_html__('Color', 'konstruc' ),
                'type' => \Elementor\Controls_Manager::COLOR,
                'selectors' => [
                    '{{WRAPPER}} .pxl-showcase .pxl-item--title' => 'color: {{VALUE}};',
                ],
            ),
            array(
                'name' => 't_typography',
                'label' => esc_html__('Typography', 'konstruc' ),
                'type' => \Elementor\Group_Control_Typography::get_type(),
                'control_type' => 'group',
                'selector' => '{{WRAPPER}} .pxl-showcase .pxl-item--title',
            ),


            array(
                'name' => 'title_spacer',
                'label' => esc_html__( 'Title Margin', 'konstruc' ),
                'type' => \Elementor\Controls_Manager::DIMENSIONS,
                'control_type' => 'responsive',
                'selectors' => [
                    '{{WRAPPER}} .pxl-showcase .pxl-item--title' => 'margin: {{TOP}}{{UNIT}} {{RIGHT}}{{UNIT}} {{BOTTOM}}{{UNIT}} {{LEFT}}{{UNIT}};',
                ],
                'responsive' => true,
            ),


            array(
                'name'  => 'heading_button',
                'label' => esc_html__('BUTTON','konstruc'),
                'type'  => \Elementor\Controls_Manager::HEADING,
            ),
            array(
                'name' => 'button_color',
                'label' => esc_html__('Color', 'konstruc' ),
                'type' => \Elementor\Controls_Manager::COLOR,
                'selectors' => [
                    '{{WRAPPER}} .pxl-showcase .pxl-item--btn' => 'color: {{VALUE}};',
                ],
            ),
            array(
                'name' => 'button_typography',
                'label' => esc_html__('Typography', 'konstruc' ),
                'type' => \Elementor\Group_Control_Typography::get_type(),
                'control_type' => 'group',
                'selector' => '{{WRAPPER}} .pxl-showcase .pxl-item--btn',
            ),

            array(
                'name' => 'min_width',
                'label' => esc_html__('Min Width', 'konstruc' ),
                'type' => \Elementor\Controls_Manager::SLIDER,
                'control_type' => 'responsive',
                'range' => [
                    'px' => [
                        'min' => 0,
                        'max' => 1000,
                    ],
                ],
                'selectors' => [
                    '{{WRAPPER}} .pxl-showcase .pxl-item--btn' => 'min-width: {{SIZE}}px;',
                ],
            ),


            array(
                'name' => 'justify_content',
                'label' => esc_html__('Justify Content', 'konstruc' ),
                'type' => \Elementor\Controls_Manager::CHOOSE,
                'default' => '',
                'options' => [
                    'start' =>  [
                        'title' => esc_html__('Start', 'konstruc'),
                        'icon' => 'eicon-justify-start-h',
                    ],
                    'center' =>  [
                        'title' => esc_html__('Center', 'konstruc'),
                        'icon' => 'eicon-justify-center-h',
                    ],
                    'end' =>  [
                        'title' => esc_html__('End', 'konstruc'),
                        'icon' => 'eicon-justify-end-h',
                    ],
                ],
                'selectors' => [
                    '{{WRAPPER}} .pxl-showcase .pxl-item--inner' => 'justify-content: {{VALUE}}'
                ],
            ),
        ),
),
),

konstruc_grid_settings(false),
konstruc_widget_animation_settings(),
),
),
),
konstruc_get_class_widget_path(),
);