<?php
$slides_to_show = range( 1, 10 );
$slides_to_show = array_combine( $slides_to_show, $slides_to_show );
$templates_df = ['0' => esc_html__('None', 'konstruc')];
$templates = $templates_df + konstruc_get_templates_option('popup') ;
pxl_add_custom_widget(
    array(
        'name' => 'pxl_team_carousel',
        'title' => esc_html__('BR Team Carousel', 'konstruc'),
        'icon' => 'eicon-lock-user',
        'categories' => array('pxltheme-core'),
        'scripts' => array(
            'swiper',
            'pxl-swiper',
        ),
        'params' => array(
            'sections' => array(
                array(
                    'name' => 'tab_layout',
                    'label' => esc_html__('Layout', 'konstruc' ),
                    'tab' => \Elementor\Controls_Manager::TAB_LAYOUT,
                    'controls' => array(
                        array(
                            'name' => 'layout',
                            'label' => esc_html__('Templates', 'konstruc' ),
                            'type' => 'layoutcontrol',
                            'default' => '1',
                            'options' => [
                                '1' => [
                                    'label' => esc_html__('Layout 1', 'konstruc' ),
                                    'image' => get_template_directory_uri() . '/elements/widgets/img-layout/pxl_team_carousel/layout1.jpg'
                                ],
                                '2' => [
                                    'label' => esc_html__('Layout 2', 'konstruc' ),
                                    'image' => get_template_directory_uri() . '/elements/widgets/img-layout/pxl_team_carousel/layout2.jpg'
                                ],
                            ],
                        ),
                    ),
                ),
                array(
                    'name' => 'tab_content',
                    'label' => esc_html__('Content', 'konstruc'),
                    'tab' => \Elementor\Controls_Manager::TAB_CONTENT,
                    'controls' => array(
                     array(
                        'name' => 'team',
                        'label' => esc_html__('Team', 'konstruc'),
                        'type' => \Elementor\Controls_Manager::REPEATER,
                        'default' => [],
                        'controls' => array(
                            array(
                                'name' => 'image',
                                'label' => esc_html__('Image', 'konstruc' ),
                                'type' => \Elementor\Controls_Manager::MEDIA,
                            ),
                            array(
                                'name' => 'title',
                                'label' => esc_html__('Title', 'konstruc'),
                                'type' => \Elementor\Controls_Manager::TEXT,
                                'label_block' => true,
                            ),
                            array(
                                'name' => 'position',
                                'label' => esc_html__('Position', 'konstruc'),
                                'type' => \Elementor\Controls_Manager::TEXT,
                            ),
                            array(
                                'name' => 'description',
                                'label' => esc_html__('Description', 'konstruc'),
                                'type' => \Elementor\Controls_Manager::TEXTAREA,
                            ),
                            array(
                                'name' => 'link',
                                'label' => esc_html__('Link', 'konstruc' ),
                                'type' => \Elementor\Controls_Manager::URL,
                                'default' => [
                                    'url' => '#',
                                ],
                            ),
                            array(
                                'name' => 'social',
                                'label' => esc_html__( 'Social', 'konstruc' ),
                                'type' => 'pxl_icons',
                            ),
                        ),
                        'title_field' => '{{{ title }}}',
                    ),
                 ),
                ),
                
                array(
                    'name' => 'section_carousel_settings',
                    'label' => esc_html__('Carousel Settings', 'konstruc'),
                    'tab' => \Elementor\Controls_Manager::TAB_SETTINGS,
                    'controls' => array(
                        array(
                            'name' => 'img_size',
                            'label' => esc_html__('Image Size', 'konstruc' ),
                            'type' => \Elementor\Controls_Manager::TEXT,
                            'description' => 'Enter image size (Example: "thumbnail", "medium", "large", "full" or other sizes defined by theme). Alternatively enter size in pixels (Default: 370x300 (Width x Height)).',
                        ),
                        array(
                            'name' => 'col_xs',
                            'label' => esc_html__('Columns XS Devices', 'konstruc' ),
                            'type' => \Elementor\Controls_Manager::SELECT,
                            'default' => '1',
                            'options' => [
                                '1' => '1',
                                '2' => '2',
                                '3' => '3',
                                '4' => '4',
                                '6' => '6',
                            ],
                        ),
                        array(
                            'name' => 'col_sm',
                            'label' => esc_html__('Columns SM Devices', 'konstruc' ),
                            'type' => \Elementor\Controls_Manager::SELECT,
                            'default' => '2',
                            'options' => [
                                '1' => '1',
                                '2' => '2',
                                '3' => '3',
                                '4' => '4',
                                '6' => '6',
                            ],
                        ),
                        array(
                            'name' => 'col_md',
                            'label' => esc_html__('Columns MD Devices', 'konstruc' ),
                            'type' => \Elementor\Controls_Manager::SELECT,
                            'default' => '2',
                            'options' => [
                                '1' => '1',
                                '2' => '2',
                                '3' => '3',
                                '4' => '4',
                                '6' => '6',
                            ],
                        ),
                        array(
                            'name' => 'col_lg',
                            'label' => esc_html__('Columns LG Devices', 'konstruc' ),
                            'type' => \Elementor\Controls_Manager::SELECT,
                            'default' => '3',
                            'options' => [
                                '1' => '1',
                                '2' => '2',
                                '3' => '3',
                                '4' => '4',
                                '6' => '6',
                            ],
                        ),
                        array(
                            'name' => 'col_xl',
                            'label' => esc_html__('Columns XL Devices', 'konstruc' ),
                            'type' => \Elementor\Controls_Manager::SELECT,
                            'default' => '3',
                            'options' => [
                                '1' => '1',
                                '2' => '2',
                                '3' => '3',
                                '4' => '4',
                                '5' => '5',
                                '6' => '6',
                            ],
                        ),
                        array(
                            'name' => 'col_xxl',
                            'label' => esc_html__('Columns XXL Devices', 'konstruc' ),
                            'type' => \Elementor\Controls_Manager::SELECT,
                            'default' => '3',
                            'options' => [
                                '1' => '1',
                                '2' => '2',
                                '3' => '3',
                                '4' => '4',
                                '5' => '5',
                                '6' => '6',
                            ],
                        ),

                        array(
                            'name' => 'slides_to_scroll',
                            'label' => esc_html__('Slides to scroll', 'konstruc' ),
                            'type' => \Elementor\Controls_Manager::SELECT,
                            'default' => '1',
                            'options' => [
                                '1' => '1',
                                '2' => '2',
                                '3' => '3',
                                '4' => '4',
                                '5' => '5',
                                '6' => '6',
                            ],
                        ),
                        array(
                            'name' => 'arrows',
                            'label' => esc_html__('Show Arrows', 'konstruc'),
                            'type' => \Elementor\Controls_Manager::SWITCHER,
                        ),
                        array(
                            'name' => 'pagination',
                            'label' => esc_html__('Show Pagination', 'konstruc'),
                            'type' => \Elementor\Controls_Manager::SWITCHER,
                            'default' => false,
                        ),
                        array(
                            'name' => 'pagination_type',
                            'label' => esc_html__('Pagination Type', 'konstruc' ),
                            'type' => \Elementor\Controls_Manager::SELECT,
                            'default' => 'bullets',
                            'options' => [
                                'bullets' => 'Bullets',
                                'fraction' => 'Fraction',
                            ],
                            'condition' => [
                                'pagination' => 'true'
                            ]
                        ),
                        
                        array(
                            'name' => 'color_dot',
                            'label' => esc_html__('Color Dot', 'konstruc' ),
                            'type' => \Elementor\Controls_Manager::COLOR,
                            'selectors' => [
                                '{{WRAPPER}} .pxl-swiper-pagination-bullet' => 'background-color: {{VALUE}} !important;',
                            ],
                            'condition' => [
                                'pagination' => 'true'
                            ]
                        ),
                        array(
                            'name' => 'color_dotat',
                            'label' => esc_html__('Color Dot Active', 'konstruc' ),
                            'type' => \Elementor\Controls_Manager::COLOR,
                            'selectors' => [
                                '{{WRAPPER}} .pxl-swiper-pagination-bullet.swiper-pagination-bullet-active' => 'background-color: {{VALUE}} !important;',
                            ],
                            'condition' => [
                                'pagination' => 'true'
                            ]
                        ),
                        array(
                            'name' => 'pause_on_hover',
                            'label' => esc_html__('Pause on Hover', 'konstruc'),
                            'type' => \Elementor\Controls_Manager::SWITCHER,
                        ),
                        array(
                            'name' => 'autoplay',
                            'label' => esc_html__('Autoplay', 'konstruc'),
                            'type' => \Elementor\Controls_Manager::SWITCHER,
                        ),
                        array(
                            'name' => 'autoplay_speed',
                            'label' => esc_html__('Autoplay Delay', 'konstruc'),
                            'type' => \Elementor\Controls_Manager::NUMBER,
                            'default' => 5000,
                            'condition' => [
                                'autoplay' => 'true'
                            ]
                        ),
                        array(
                            'name' => 'infinite',
                            'label' => esc_html__('Infinite Loop', 'konstruc'),
                            'type' => \Elementor\Controls_Manager::SWITCHER,
                        ),
                        array(
                            'name' => 'speed',
                            'label' => esc_html__('Animation Speed', 'konstruc'),
                            'type' => \Elementor\Controls_Manager::NUMBER,
                            'default' => 500,
                        ),
                        array(
                            'name' => 'drap',
                            'label' => esc_html__('Show Scroll Drap', 'konstruc'),
                            'type' => \Elementor\Controls_Manager::SWITCHER,
                            'default' => false,
                        ),
                        array(
                            'name' => 'item_spacer',
                            'label' => esc_html__('Item Spacer', 'konstruc' ),
                            'type' => \Elementor\Controls_Manager::SLIDER,
                            'control_type' => 'responsive',
                            'description' => 'Default: 15',
                            'default'   => [
                                'size'  => '15',
                                'unit'  => 'px',
                            ],
                            'range' => [
                                'px' => [
                                    'min' => 0,
                                    'max' => 1000,
                                ],
                            ],
                            'selectors' => [
                                '{{WRAPPER}} .pxl-swiper-slider ..pxl-swiper-container' => 'margin-left:-{{SIZE}}px;margin-right:-{{SIZE}}px;',
                                '{{WRAPPER}} .pxl-swiper-slider .pxl-swiper-slide' => 'padding-left: {{SIZE}}px;padding-right: {{SIZE}}px;',
                            ],
                        ),
                    ),
),

array(
    'name' => 'section_style',
    'label' => esc_html__('Style', 'konstruc' ),
    'tab' => \Elementor\Controls_Manager::TAB_STYLE,
    'controls' => array(
        array(
            'name'  => 'heading_title',
            'label' => esc_html__('TITLE','konstruc'),
            'type'  => \Elementor\Controls_Manager::HEADING,
        ),
        array(
            'name' => 'title_color',
            'label' => esc_html__('Title Color', 'konstruc' ),
            'type' => \Elementor\Controls_Manager::COLOR,
            'selectors' => [
                '{{WRAPPER}} .pxl-team .pxl-item--title a' => 'color: {{VALUE}};',
            ],
        ),
        array(
            'name' => 'title_typography',
            'label' => esc_html__('Title Typography', 'konstruc' ),
            'type' => \Elementor\Group_Control_Typography::get_type(),
            'control_type' => 'group',
            'selector' => '{{WRAPPER}} .pxl-team .pxl-item--title a',
        ),

        array(
            'name'  => 'heading_pos',
            'label' => esc_html__('POSITION','konstruc'),
            'type'  => \Elementor\Controls_Manager::HEADING,
            'separator' => 'before',
        ),
        array(
            'name' => 'pos_color',
            'label' => esc_html__('Position Color', 'konstruc' ),
            'type' => \Elementor\Controls_Manager::COLOR,
            'selectors' => [
                '{{WRAPPER}} .pxl-team .pxl-item--position' => 'color: {{VALUE}};',
            ],
        ),
        array(
            'name' => 'pos_typography',
            'label' => esc_html__('Position Typography', 'konstruc' ),
            'type' => \Elementor\Group_Control_Typography::get_type(),
            'control_type' => 'group',
            'selector' => '{{WRAPPER}} .pxl-team .pxl-item--position',
        ),

        array(
            'name'  => 'heading_des',
            'label' => esc_html__('DESCRIPTION','konstruc'),
            'type'  => \Elementor\Controls_Manager::HEADING,
            'separator' => 'before',
        ),
        array(
            'name' => 'des_color',
            'label' => esc_html__('Description Color', 'konstruc' ),
            'type' => \Elementor\Controls_Manager::COLOR,
            'selectors' => [
                '{{WRAPPER}} .pxl-team .pxl-item--description' => 'color: {{VALUE}};',
            ],
        ),
        array(
            'name' => 'des_typography',
            'label' => esc_html__('Description Typography', 'konstruc' ),
            'type' => \Elementor\Group_Control_Typography::get_type(),
            'control_type' => 'group',
            'selector' => '{{WRAPPER}} .pxl-team .pxl-item--description',
        ),

        array(
            'name'  => 'heading_icon',
            'label' => esc_html__('ICON','konstruc'),
            'type'  => \Elementor\Controls_Manager::HEADING,
            'separator' => 'before',
        ),
        array(
            'name'          => 'tab_style_icon',
            'control_type'  => 'tab',
            'tabs'          => [
                [
                    'name'  => 'icon_style_normal',
                    'label' => esc_html__('Normal','konstruc'),
                    'type'  => 'tab',
                    'controls'  => 
                    [
                        array(
                            'name' => 'icon_color',
                            'label' => esc_html__('Icon Color', 'konstruc' ),
                            'type' => \Elementor\Controls_Manager::COLOR,
                            'selectors' => [
                            '{{WRAPPER}} .pxl-team .pxl-social--wrap .pxl-social a' => 'color: {{VALUE}};',
                        ],
                    ),
                        array(
                            'name' => 'icon_bg_color',
                            'label' => esc_html__('Icon Background', 'konstruc' ),
                            'type' => \Elementor\Controls_Manager::COLOR,
                            'selectors' => [
                            '{{WRAPPER}} .pxl-team .pxl-social--wrap .pxl-social a' => 'background: {{VALUE}};',
                        ],
                    ),

                        array(
                            'name'  => 'heading_icon_wrap',
                            'label' => esc_html__('Icon Wrap','konstruc'),
                            'type'  => \Elementor\Controls_Manager::HEADING,
                            'separator' => 'before',
                        ),

                        array(
                            'name' => 'icon_wrap_color',
                            'label' => esc_html__('Wrap Color', 'konstruc' ),
                            'type' => \Elementor\Controls_Manager::COLOR,
                            'selectors' => [
                            '{{WRAPPER}} .pxl-team .pxl-social--wrap .pxl-icon--wrap' => 'color: {{VALUE}};',
                        ],
                    ),
                        array(
                            'name' => 'icon_wrap_bg_color',
                            'label' => esc_html__('Wrap Background', 'konstruc' ),
                            'type' => \Elementor\Controls_Manager::COLOR,
                            'selectors' => [
                            '{{WRAPPER}} .pxl-team .pxl-social--wrap .pxl-icon--wrap' => 'background: {{VALUE}};',
                        ],
                    ),



                    ],
                ],
                [
                    'name'  => 'icon_style_hover',
                    'label' => esc_html__('Hover','konstruc'),
                    'type'  => 'tab',
                    'controls'  => 
                    [
                        array(
                            'name' => 'icon_color_hover',
                            'label' => esc_html__('Icon Color', 'konstruc' ),
                            'type' => \Elementor\Controls_Manager::COLOR,
                            'selectors' => [
                            '{{WRAPPER}} .pxl-team .pxl-social--wrap .pxl-social a:hover' => 'color: {{VALUE}};',
                        ],
                    ),
                        array(
                            'name' => 'icon_bg_color_hover',
                            'label' => esc_html__('Icon Background', 'konstruc' ),
                            'type' => \Elementor\Controls_Manager::COLOR,
                            'selectors' => [
                            '{{WRAPPER}} .pxl-team .pxl-social--wrap .pxl-social a:hover' => 'background: {{VALUE}};',
                        ],
                    ),

                        array(
                            'name'  => 'heading_icon_wrap_hover',
                            'label' => esc_html__('Icon Wrap','konstruc'),
                            'type'  => \Elementor\Controls_Manager::HEADING,
                            'separator' => 'before',
                        ),

                        array(
                            'name' => 'icon_wrap_color_hover',
                            'label' => esc_html__('Wrap Color', 'konstruc' ),
                            'type' => \Elementor\Controls_Manager::COLOR,
                            'selectors' => [
                            '{{WRAPPER}} .pxl-team .pxl-social--wrap:hover .pxl-icon--wrap' => 'color: {{VALUE}};',
                        ],
                    ),
                        array(
                            'name' => 'icon_wrap_bg_color_hover',
                            'label' => esc_html__('Wrap Background', 'konstruc' ),
                            'type' => \Elementor\Controls_Manager::COLOR,
                            'selectors' => [
                            '{{WRAPPER}} .pxl-team .pxl-social--wrap:hover .pxl-icon--wrap' => 'background: {{VALUE}};',
                        ],
                    ),
                    ],
                ],




            ],
        ),
),
),
konstruc_widget_animation_settings(),
),
),
),
konstruc_get_class_widget_path()
);