<?php
// Register Video Player Widget
pxl_add_custom_widget(
    array(
        'name' => 'pxl_video_player',
        'title' => esc_html__('BR Video Player', 'konstruc' ),
        'icon' => 'eicon-play',
        'categories' => array('pxltheme-core'),
        'scripts' => [
            'pxl-circle--text',
            'circle-text',
        ],
        'params' => array(
            'sections' => array(
                array(
                    'name' => 'section_content',
                    'label' => esc_html__('Content', 'konstruc' ),
                    'tab' => \Elementor\Controls_Manager::TAB_CONTENT,
                    'controls' => array(
                        array(
                            'name' => 'title',
                            'label' => esc_html__('Title', 'konstruc' ),
                            'type' => \Elementor\Controls_Manager::TEXT,
                            'label_block' => true,
                        ),
                        array(
                            'name' => 'video_link',
                            'label' => esc_html__('Link', 'konstruc' ),
                            'type' => \Elementor\Controls_Manager::TEXT,
                            'default' => 'https://www.youtube.com/watch?v=SF4aHwxHtZ0'                            
                        ),
                        array(
                            'name' => 'image_type',
                            'label' => esc_html__('Image Type', 'konstruc' ),
                            'type' => \Elementor\Controls_Manager::SELECT,
                            'options' => [
                                'none' => 'None',
                                'img' => 'Image',
                                'bg' => 'Background',
                                'video' => 'Video',
                            ],
                            'default' => 'none',
                        ),
                        array(
                            'name' => 'image',
                            'label' => esc_html__('Image', 'konstruc' ),
                            'type' => \Elementor\Controls_Manager::MEDIA,
                            'condition' => [
                                'image_type' => ['img', 'bg'],
                            ],
                        ),
                        array(
                            'name' => 'img_size',
                            'label' => esc_html__('Image Size', 'konstruc' ),
                            'type' => \Elementor\Controls_Manager::TEXT,
                            'description' => 'Enter image size (Example: "thumbnail", "medium", "large", "full" or other sizes defined by theme). Alternatively enter size in pixels (Example: 200x100 (Width x Height).',
                            'condition' => [
                                'image_type' => 'img',
                            ],
                        ),
                        array(
                            'name' => 'img_height',
                            'label' => esc_html__( 'Image Height', 'konstruc' ),
                            'type' => \Elementor\Controls_Manager::SLIDER,
                            'description' => 'Enter number.',
                            'control_type' => 'responsive',
                            'size_units' => [ 'px', '%' ],
                            'default' => [
                                'unit' => 'px',
                            ],
                            'range' => [
                                'px' => [
                                    'min' => 0,
                                    'max' => 3000,
                                ],
                                '%' => [
                                    'min' => 0,
                                    'max' => 100,
                                ],
                            ],
                            'condition' => [
                                'image_type' => 'img',
                            ],
                            'selectors' => [
                                '{{WRAPPER}} .pxl-video-player .pxl-video--holder img' => 'height: {{SIZE}}{{UNIT}};',
                            ],
                        ),
                        array(
                            'name' => 'image_height_bg',
                            'label' => esc_html__('Image Height', 'konstruc' ),
                            'type' => \Elementor\Controls_Manager::SLIDER,
                            'description' => 'Enter number.',
                            'condition' => [
                                'image_type' => 'bg',
                            ],
                            'range' => [
                                'px' => [
                                    'min' => 0,
                                    'max' => 3000,
                                ],
                            ],
                            'control_type' => 'responsive',
                            'selectors' => [
                                '{{WRAPPER}} .pxl-video-player .pxl-video--image' => 'height: {{SIZE}}{{UNIT}};',
                            ],
                        ),
                        array(
                            'name' => 'btn_video_position',
                            'label' => esc_html__('Button Video Position', 'konstruc' ),
                            'type' => \Elementor\Controls_Manager::SELECT,
                            'options' => [
                                'p-center' => 'Center',
                                'p-top-left' => 'Top Left',
                                'p-top-right' => 'Top Right',
                                'p-bottom-left' => 'Bottom Left',
                                'p-bottom-right' => 'Bottom Right',
                            ],
                            'default' => 'p-center',
                            'condition' => [
                                'image_type' => ['img','bg'],
                            ],
                        ),
                        array(
                            'name' => 'top_position',
                            'label' => esc_html__('Top Position', 'konstruc' ),
                            'type' => \Elementor\Controls_Manager::SLIDER,
                            'size_units' => [ 'px', '%' ],
                            'control_type' => 'responsive',
                            'default' => [
                                'size' => 0,
                                'unit' => '%',
                            ],
                            'range' => [
                                '%' => [
                                    'min' => 0,
                                    'max' => 100,
                                ],
                                'px' => [
                                    'min' => 0,
                                    'max' => 3000,
                                ],
                            ],
                            'selectors' => [
                                '{{WRAPPER}} .pxl-video--holder + .btn-video-wrap.p-top-left, {{WRAPPER}} .pxl-video--holder + .btn-video-wrap.p-top-right' => 'top: {{SIZE}}{{UNIT}};',
                            ],
                            'condition' => [
                                'btn_video_position' => ['p-top-left', 'p-top-right'],
                            ],
                        ),
                        array(
                            'name' => 'right_position',
                            'label' => esc_html__('Right Position', 'konstruc' ),
                            'type' => \Elementor\Controls_Manager::SLIDER,
                            'size_units' => [ 'px', '%' ],
                            'control_type' => 'responsive',
                            'default' => [
                                'size' => 0,
                                'unit' => '%',
                            ],
                            'range' => [
                                '%' => [
                                    'min' => 0,
                                    'max' => 100,
                                ],
                                'px' => [
                                    'min' => 0,
                                    'max' => 3000,
                                ],
                            ],
                            'selectors' => [
                                '{{WRAPPER}} .pxl-video--holder + .btn-video-wrap.p-top-right, {{WRAPPER}} .pxl-video--holder + .btn-video-wrap.p-bottom-right' => 'right: {{SIZE}}{{UNIT}};',
                            ],
                            'condition' => [
                                'btn_video_position' => ['p-top-right', 'p-bottom-right'],
                            ],
                        ),
                        array(
                            'name' => 'bottom_position',
                            'label' => esc_html__('Bottom Position', 'konstruc' ),
                            'type' => \Elementor\Controls_Manager::SLIDER,
                            'size_units' => [ 'px', '%' ],
                            'control_type' => 'responsive',
                            'default' => [
                                'size' => 0,
                                'unit' => '%',
                            ],
                            'range' => [
                                '%' => [
                                    'min' => 0,
                                    'max' => 100,
                                ],
                                'px' => [
                                    'min' => 0,
                                    'max' => 3000,
                                ],
                            ],
                            'selectors' => [
                                '{{WRAPPER}} .pxl-video--holder + .btn-video-wrap.p-bottom-left, {{WRAPPER}} .pxl-video--holder + .btn-video-wrap.p-bottom-right' => 'bottom: {{SIZE}}{{UNIT}};',
                            ],
                            'condition' => [
                                'btn_video_position' => ['p-bottom-left', 'p-bottom-right'],
                            ],
                        ),
                        array(
                            'name' => 'left_position',
                            'label' => esc_html__('Left Position', 'konstruc' ),
                            'type' => \Elementor\Controls_Manager::SLIDER,
                            'size_units' => [ 'px', '%' ],
                            'control_type' => 'responsive',
                            'default' => [
                                'size' => 0,
                                'unit' => '%',
                            ],
                            'range' => [
                                '%' => [
                                    'min' => 0,
                                    'max' => 100,
                                ],
                                'px' => [
                                    'min' => 0,
                                    'max' => 3000,
                                ],
                            ],
                            'selectors' => [
                                '{{WRAPPER}} .pxl-video--holder + .btn-video-wrap.p-top-left, {{WRAPPER}} .pxl-video--holder + .btn-video-wrap.p-bottom-left' => 'left: {{SIZE}}{{UNIT}};',
                            ],
                            'condition' => [
                                'btn_video_position' => ['p-top-left', 'p-bottom-left'],
                            ],
                        ),
                    ),
                ),
                array(
                    'name' => 'section_style_content',
                    'label' => esc_html__('Content', 'konstruc'),
                    'tab' => \Elementor\Controls_Manager::TAB_STYLE,
                    'controls' => array(
                        array(
                            'name' => 'title_color',
                            'label' => esc_html__('Title Color', 'konstruc' ),
                            'type' => \Elementor\Controls_Manager::COLOR,
                            'selectors' => [
                                '{{WRAPPER}} .pxl-video-player .pxl-item--title' => 'color: {{VALUE}};',
                            ],
                        ),
                        
                        array(
                            'name' => 'title_typography',
                            'label' => esc_html__('Title Typography', 'konstruc' ),
                            'type' => \Elementor\Group_Control_Typography::get_type(),
                            'control_type' => 'group',
                            'selector' => '{{WRAPPER}} .pxl-video-player .pxl-item--title',
                        ),
                        array(
                            'name' => 'title_width',
                            'label' => esc_html__('Title Max Width', 'konstruc' ),
                            'type' => \Elementor\Controls_Manager::SLIDER,
                            'control_type' => 'responsive',
                            'size_units' => [ 'px', '%' ],
                            'range' => [
                                'px' => [
                                    'min' => 0,
                                    'max' => 3000,
                                ],
                                '%' => [
                                    'min' => 0,
                                    'max' => 100,
                                ],
                            ],
                            'selectors' => [
                                '{{WRAPPER}} .pxl-video-player .pxl-item--title' => 'max-width: {{SIZE}}{{UNIT}};',
                            ],
                        ),
                        array(
                            'name' => 'title_margin',
                            'label' => esc_html__('Title Margin (px)', 'konstruc' ),
                            'type' => 'dimensions',
                            'control_type' => 'responsive',
                            'size_units' => [ 'px', '%' ],
                            'default' => [
                                'unit' => 'px',
                            ],
                            'range' => [
                                'px' => [
                                    'min' => 0,
                                    'max' => 3000,
                                ],
                                '%' => [
                                    'min' => 0,
                                    'max' => 100,
                                ],
                            ],
                            'selectors' => [
                                '{{WRAPPER}} .pxl-video-player .pxl-item--title' => 'margin: {{TOP}}{{UNIT}} {{RIGHT}}{{UNIT}} {{BOTTOM}}{{UNIT}} {{LEFT}}{{UNIT}};',
                            ],
                            'separator' => 'after',
                        ),
                        array(
                            'name' => 'icon_color',
                            'label' => esc_html__('Icon Color', 'konstruc' ),
                            'type' => \Elementor\Controls_Manager::COLOR,
                            'selectors' => [
                                '{{WRAPPER}} .pxl-video-player .pxl-icon--video' => 'color: {{VALUE}};',
                            ],
                        ),
                        
                        array(
                            'name'  => 'icon_size',
                            'label' => esc_html__('Icon Size (px)', 'konstruc' ),
                            'type'  => 'slider',
                            'control_type' => 'responsive',
                            'size_units' => ['px'],
                            'range' => [
                                'px' => [
                                    'min' => 0,
                                    'max' => 300,
                                ],
                            ],
                            'selectors' => [
                                '{{WRAPPER}} .pxl-video-player .pxl-icon--video i' => 'font-size: {{SIZE}}{{UNIT}};',
                            ],
                        ),
                        array(
                            'name' => 'icon_width',
                            'label' => esc_html__('Icon Width (px)', 'konstruc' ),
                            'type' => \Elementor\Controls_Manager::SLIDER,
                            'control_type' => 'responsive',
                            'size_units' => ['px'],
                            'range' => [
                                'px' => [
                                    'min' => 0,
                                    'max' => 3000,
                                ],
                            ],
                            'selectors' => [
                                '{{WRAPPER}} .pxl-video-player .btn-video' => 'width: {{SIZE}}{{UNIT}}; height: {{SIZE}}{{UNIT}}; line-height: {{SIZE}}{{UNIT}};',
                            ],
                        ),
                    ),
                ),
                array(
                    'name' => 'section_style_box',
                    'label' => esc_html__('Box', 'konstruc'),
                    'tab' => \Elementor\Controls_Manager::TAB_STYLE,
                    'controls' => array(
                        array(
                            'name' => 'bg_position',
                            'label' => esc_html__( 'Background Position', 'konstruc' ),
                            'type' => \Elementor\Controls_Manager::SELECT,
                            'default' => '',
                            'responsive' => true,
                            'options' => [
                                '' => esc_html__( 'Default', 'konstruc' ),
                                'center center' => esc_html__( 'Center Center', 'konstruc' ),
                                'center left' => esc_html__( 'Center Left', 'konstruc' ),
                                'center right' => esc_html__( 'Center Right', 'konstruc' ),
                                'top center' => esc_html__( 'Top Center', 'konstruc' ),
                                'top left' => esc_html__( 'Top Left', 'konstruc' ),
                                'top right' => esc_html__( 'Top Right', 'konstruc' ),
                                'bottom center' => esc_html__( 'Bottom Center', 'konstruc' ),
                                'bottom left' => esc_html__( 'Bottom Left', 'konstruc' ),
                                'bottom right' => esc_html__( 'Bottom Right', 'konstruc' ),
                                'initial' => esc_html__( 'Custom', 'konstruc' ),
                            ],
                            'selectors' => [
                                '{{WRAPPER}} .pxl-video--image' => 'background-position: {{VALUE}};',
                            ],
                            'condition' => [
                                'image_type' => 'bg',
                            ],
                        ),
                        array(
                            'name' => 'bg_position_xpos',
                            'label' => esc_html__( 'X Position', 'konstruc' ),
                            'type' => \Elementor\Controls_Manager::SLIDER,
                            'responsive' => true,
                            'size_units' => [ 'px', 'em', '%', 'vw' ],
                            'default' => [
                                'unit' => 'px',
                                'size' => 0,
                            ],
                            'tablet_default' => [
                                'unit' => 'px',
                                'size' => 0,
                            ],
                            'mobile_default' => [
                                'unit' => 'px',
                                'size' => 0,
                            ],
                            'range' => [
                                'px' => [
                                    'min' => -800,
                                    'max' => 800,
                                ],
                                'em' => [
                                    'min' => -100,
                                    'max' => 100,
                                ],
                                '%' => [
                                    'min' => -100,
                                    'max' => 100,
                                ],
                                'vw' => [
                                    'min' => -100,
                                    'max' => 100,
                                ],
                            ],
                            'selectors' => [
                                '{{WRAPPER}} .pxl-video--image' => 'background-position: {{SIZE}}{{UNIT}} {{bg_position_ypos.SIZE}}{{bg_position_ypos.UNIT}}',
                            ],
                            'condition' => [
                                'image_type' => 'bg',
                                'bg_position' => [ 'initial' ],
                            ],
                            'required' => true,
                        ),
                        array(
                            'name' => 'bg_position_ypos',
                            'label' => esc_html__( 'Y Position', 'konstruc' ),
                            'type' => \Elementor\Controls_Manager::SLIDER,
                            'responsive' => true,
                            'size_units' => [ 'px', 'em', '%', 'vw' ],
                            'default' => [
                                'unit' => 'px',
                                'size' => 0,
                            ],
                            'tablet_default' => [
                                'unit' => 'px',
                                'size' => 0,
                            ],
                            'mobile_default' => [
                                'unit' => 'px',
                                'size' => 0,
                            ],
                            'range' => [
                                'px' => [
                                    'min' => -800,
                                    'max' => 800,
                                ],
                                'em' => [
                                    'min' => -100,
                                    'max' => 100,
                                ],
                                '%' => [
                                    'min' => -100,
                                    'max' => 100,
                                ],
                                'vw' => [
                                    'min' => -100,
                                    'max' => 100,
                                ],
                            ],
                            'selectors' => [
                                '{{WRAPPER}} .pxl-video--image' => 'background-position: {{bg_position_xpos.SIZE}}{{bg_position_xpos.UNIT}} {{SIZE}}{{UNIT}}',
                            ],
                            'condition' => [
                                'image_type' => 'bg',
                                'bg_position' => [ 'initial' ],
                            ],
                            'required' => true,
                        ),
                        array(
                            'name' => 'bg_attachment',
                            'label' => esc_html__( 'Background Attachment', 'konstruc' ),
                            'type' => \Elementor\Controls_Manager::SELECT,
                            'default' => '',
                            'options' => [
                                '' => esc_html__( 'Default', 'konstruc' ),
                                'scroll' => esc_html__( 'Scroll', 'konstruc' ),
                                'fixed' => esc_html__( 'Fixed', 'konstruc' ),
                            ],
                            'selectors' => [
                                '{{WRAPPER}} .pxl-video--image' => 'background-attachment: {{VALUE}};',
                            ],
                            'condition' => [
                                'image_type' => 'bg',
                            ],
                        ),
                        array(
                            'name' => 'bg_attachment_alert',
                            'type' => \Elementor\Controls_Manager::RAW_HTML,
                            'content_classes' => 'elementor-control-field-description',
                            'raw' => esc_html__( 'Note: Attachment Fixed works only on desktop.', 'konstruc' ),
                            'separator' => 'none',
                            'condition' => [
                                'image_type' => 'bg',
                                'bg_attachment' => 'fixed',
                            ],
                        ),
                        array(
                            'name' => 'bg_repeat',
                            'label' => esc_html__( 'Background Repeat', 'konstruc' ),
                            'type' => \Elementor\Controls_Manager::SELECT,
                            'default' => '',
                            'responsive' => true,
                            'options' => [
                                '' => esc_html__( 'Default', 'konstruc' ),
                                'no-repeat' => esc_html__( 'No-repeat', 'konstruc' ),
                                'repeat' => esc_html__( 'Repeat', 'konstruc' ),
                                'repeat-x' => esc_html__( 'Repeat-x', 'konstruc' ),
                                'repeat-y' => esc_html__( 'Repeat-y', 'konstruc' ),
                            ],
                            'selectors' => [
                                '{{WRAPPER}} .pxl-video--image' => 'background-repeat: {{VALUE}};',
                            ],
                            'condition' => [
                                'image_type' => 'bg',
                            ],
                        ),
                        array(
                            'name' => 'bg_size',
                            'label' => esc_html__( 'Background Size', 'konstruc' ),
                            'type' => \Elementor\Controls_Manager::SELECT,
                            'default' => '',
                            'responsive' => true,
                            'options' => [
                                '' => esc_html__( 'Default', 'konstruc' ),
                                'auto' => esc_html__( 'Auto', 'konstruc' ),
                                'cover' => esc_html__( 'Cover', 'konstruc' ),
                                'contain' => esc_html__( 'Contain', 'konstruc' ),
                                'initial' => esc_html__( 'Custom', 'konstruc' ),
                            ],
                            'selectors' => [
                                '{{WRAPPER}} .pxl-video--image' => 'background-size: {{VALUE}};',
                            ],
                            'condition' => [
                                'image_type' => 'bg',
                            ],
                        ),
                        array(
                            'name' => 'bg_width',
                            'label' => esc_html__( 'Background Width', 'konstruc' ),
                            'type' => \Elementor\Controls_Manager::SLIDER,
                            'responsive' => true,
                            'size_units' => [ 'px', 'em', '%', 'vw' ],
                            'range' => [
                                'px' => [
                                    'min' => 0,
                                    'max' => 1000,
                                ],
                                '%' => [
                                    'min' => 0,
                                    'max' => 100,
                                ],
                                'vw' => [
                                    'min' => 0,
                                    'max' => 100,
                                ],
                            ],
                            'default' => [
                                'size' => 100,
                                'unit' => '%',
                            ],
                            'required' => true,
                            'selectors' => [
                                '{{WRAPPER}} .pxl-video--image' => 'background-size: {{SIZE}}{{UNIT}} auto',
                            ],
                            'condition' => [
                                'image_type' => 'bg',
                                'bg_size' => [ 'initial' ],
                            ],
                        ),
                        array(
                            'name' => 'box_bgcolor',
                            'label' => esc_html__('Background Color', 'konstruc' ),
                            'type' => \Elementor\Controls_Manager::COLOR,
                            'selectors' => [
                                '{{WRAPPER}} .pxl-video-player .btn-video' => 'background-color: {{VALUE}};',
                            ],
                        ),
                        
                        array(
                            'name' => 'box_border_radius',
                            'label' => esc_html__('Border Radius', 'konstruc' ),
                            'type' => \Elementor\Controls_Manager::DIMENSIONS,
                            'size_units' => [ 'px', '%' ],
                            'control_type' => 'responsive',
                            'default' => [
                                'unit' => 'px',
                            ],
                            'range' => [
                                '%' => [
                                    'min' => 0,
                                    'max' => 100,
                                ],
                                'px' => [
                                    'min' => 0,
                                    'max' => 300,
                                ],
                            ],
                            'selectors' => [
                                '{{WRAPPER}} .pxl-video-player .pxl-video--holder' => 'border-radius: {{TOP}}{{UNIT}} {{RIGHT}}{{UNIT}} {{BOTTOM}}{{UNIT}} {{LEFT}}{{UNIT}};',
                            ],
                        ),
                        array(
                            'name' => 'overlay_color',
                            'label' => esc_html__('Overlay Color', 'konstruc' ),
                            'type' => \Elementor\Controls_Manager::COLOR,
                            'selectors' => [
                                '{{WRAPPER}} .pxl-video-player .pxl-video--holder:before' => 'background-color: {{VALUE}};',
                            ],
                        ),
                        array(
                            'name'  => 'overlay-opacity',
                            'label' => esc_html__( 'Overlay Opacity', 'konstruc' ),
                            'type'  => 'slider',
                            'control_type' => 'responsive',
                            'range' => [
                                'px' => [
                                    'min' => 0,
                                    'max' => 100,
                                ],
                            ],
                            'selectors' => [
                                '{{WRAPPER}} .pxl-video-player .pxl-video--holder:before' => 'opacity: {{SIZE}}%;',
                            ],
                            'separator' => 'after',
                        ),
                        
                        array(
                            'name' => 'object_fit',
                            'label' => esc_html__( 'Size', 'konstruc' ),
                            'type' => \Elementor\Controls_Manager::SELECT,
                            'options' => [
                                '' => esc_html__( 'Default', 'konstruc' ),
                                'none' => esc_html__( 'None', 'konstruc' ),
                                'cover' => esc_html__( 'Cover', 'konstruc' ),
                                'contain' => esc_html__( 'Contain', 'konstruc' ),
                                'fill' => esc_html__( 'Fill', 'konstruc' ),
                            ],
                            'selectors' => [
                                '{{WRAPPER}} .pxl-video--holder img' => 'object-fit: {{VALUE}};',
                            ],
                            'condition' => [
                                'image_type' => 'img',
                            ],
                        ),
                        array(
                            'name' => 'border_type',
                            'label' => esc_html__( 'Border Type', 'konstruc' ),
                            'type' => \Elementor\Controls_Manager::SELECT,
                            'options' => [
                                '' => esc_html__( 'None', 'konstruc' ),
                                'solid' => esc_html__( 'Solid', 'konstruc' ),
                                'double' => esc_html__( 'Double', 'konstruc' ),
                                'dotted' => esc_html__( 'Dotted', 'konstruc' ),
                                'dashed' => esc_html__( 'Dashed', 'konstruc' ),
                                'groove' => esc_html__( 'Groove', 'konstruc' ),
                            ],
                            'selectors' => [
                                '{{WRAPPER}} .pxl-video--holder img' => 'border-style: {{VALUE}};',
                            ],
                        ),
                        array(
                            'name' => 'border_width',
                            'label' => esc_html__( 'Border Width', 'konstruc' ),
                            'type' => \Elementor\Controls_Manager::DIMENSIONS,
                            'selectors' => [
                                '{{WRAPPER}} .pxl-video--holder img' => 'border-width: {{TOP}}{{UNIT}} {{RIGHT}}{{UNIT}} {{BOTTOM}}{{UNIT}} {{LEFT}}{{UNIT}};',
                            ],
                            'condition' => [
                                'border_type!' => '',
                            ],
                            'responsive' => true,
                        ),
                        array(
                            'name' => 'border_color',
                            'label' => esc_html__( 'Border Color', 'konstruc' ),
                            'type' => \Elementor\Controls_Manager::COLOR,
                            'default' => '',
                            'selectors' => [
                                '{{WRAPPER}} .pxl-video--holder img' => 'border-color: {{VALUE}};',
                            ],
                            'condition' => [
                                'border_type!' => '',
                            ],
                        ),
                       
                    ),
                ),
                konstruc_widget_animation_settings()
            ),
        ),
    ),
    konstruc_get_class_widget_path()
);