<?php
if (!class_exists('Konstruc_Blog')) {
    class Konstruc_Blog
    {

        public function get_archive_meta($post_id = 0) {
            $archive_category = konstruc()->get_theme_opt( 'archive_category', true );
            $post_comments_on = konstruc()->get_theme_opt('post_comments_on', true);
            $archive_author = konstruc()->get_theme_opt( 'archive_author', true );
            if($archive_author || $archive_category || $post_comments_on) : ?>
                <div class="post-metas">
                    <div class="meta-inner ">
                        <?php if($archive_author) : ?>
                            <span class="post-item post-author">
                                <span class="icon-post"><i class="flaticon-user"></i></span>
                                <span><?php echo esc_html__('By', 'konstruc'); ?> <?php the_author_posts_link(); ?></span>
                            </span>
                        <?php endif; ?>

                        <?php if($post_comments_on) : ?>
                            <span class="post-item post-comments  ">
                                <a href="<?php echo get_comments_link($post_id); ?>">
                                    <span class="icon-post"><i class="flaticon-speech-bubble"></i></span>
                                    <span><?php comments_number(esc_html__('No Comments', 'konstruc'), esc_html__(' 1 Comment', 'konstruc'), esc_html__('%  Comments', 'konstruc'), $post_id); ?></span>
                                </a>
                            </span>
                        <?php endif; ?>

                        <span class="post-item post-time--read">
                            <span class="icon-post">
                                <i class="far fa-clock"></i>
                            </span>
                            <span>
                                <?php
                                echo do_shortcode('[reading_time]');
                                ?>
                            </span>
                        </span>
                    </div>
                </div>
            <?php endif; 
        }

        public function get_archive_meta_2($post_id = 0) { ?>
            <div class="post-metas-2">
                <div class="meta-inner ">
                    <span class="post-date-category">
                        <span class="post-date-post"><?php echo get_the_date('d M'); ?> </span>
                        <span><?php the_terms( $post_id, 'category', '', ', ', '' ); ?></span>
                    </span>
                </div>
            </div>
        <?php }

        public function get_excerpt( $length = 55 ){
            $pxl_the_excerpt = get_the_excerpt();
            if(!empty($pxl_the_excerpt)) {
                echo esc_html($pxl_the_excerpt);
            } else {
                echo wp_kses_post($this->get_excerpt_more( $length ));
            }
        }

        public function get_excerpt_more( $length = 55, $post = null ) {
            $post = get_post( $post );

            if ( empty( $post ) || 0 >= $length ) {
                return ''; 
            }

            if ( post_password_required( $post ) ) {
                return esc_html__( 'Post password required.', 'konstruc' );
            }

            $content = apply_filters( 'the_content', strip_shortcodes( $post->post_content ) );
            $content = str_replace( ']]>', ']]&gt;', $content );

            $excerpt_more = apply_filters( 'konstruc_excerpt_more', '&hellip;' );
            $excerpt      = wp_trim_words( $content, $length, $excerpt_more );

            return $excerpt;
        }

        public function get_post_metas(){ ?>
            <div class="post-metas">
                <div class="meta-inner">
                    <span class="post-item post-author">
                        <span class="icon-post">
                            <i class="far fa-user"></i>
                        </span>
                        <span><?php echo esc_html__('By', 'konstruc'); ?>&nbsp;<?php the_author_posts_link(); ?></span>
                    </span>


                    <span class="post-item post-comments ">
                        <span class="icon-post">
                            <svg width="19" height="16" viewBox="0 0 19 16" fill="none" xmlns="http://www.w3.org/2000/svg">
                                <path d="M10.1289 2.74068C9.24249 2.39409 8.28938 2.2208 7.26962 2.2208C6.24986 2.2208 5.29675 2.39409 4.41029 2.74068C3.52383 3.08726 2.81733 3.55715 2.29079 4.15035C1.77091 4.74354 1.51097 5.38006 1.51097 6.0599C1.51097 6.60644 1.6876 7.13298 2.04085 7.63953C2.3941 8.14608 2.89065 8.58597 3.5305 8.95922L4.50027 9.51909L4.15035 10.3589C4.37696 10.2256 4.58358 10.0956 4.77021 9.96898L5.2101 9.65906L5.73998 9.75903C6.25986 9.85234 6.76974 9.899 7.26962 9.899C8.28938 9.899 9.24249 9.72571 10.1289 9.37912C11.0154 9.03254 11.7186 8.56265 12.2385 7.96945C12.765 7.37626 13.0283 6.73974 13.0283 6.0599C13.0283 5.38006 12.765 4.74354 12.2385 4.15035C11.7186 3.55715 11.0154 3.08726 10.1289 2.74068ZM3.73045 1.63094C4.81686 1.17105 5.99658 0.941102 7.26962 0.941102C8.54265 0.941102 9.71904 1.17105 10.7988 1.63094C11.8852 2.08417 12.7417 2.70402 13.3682 3.4905C13.9947 4.27699 14.308 5.13345 14.308 6.0599C14.308 6.98635 13.9947 7.84282 13.3682 8.6293C12.7417 9.41578 11.8852 10.039 10.7988 10.4989C9.71904 10.9521 8.54265 11.1787 7.26962 11.1787C6.69642 11.1787 6.10989 11.1254 5.51003 11.0187C4.68356 11.6053 3.75711 12.0318 2.73068 12.2984C2.49074 12.3584 2.20414 12.4117 1.87089 12.4584H1.84089C1.76758 12.4584 1.69759 12.4317 1.63094 12.3784C1.57096 12.3251 1.5343 12.2551 1.52097 12.1685C1.5143 12.1485 1.51097 12.1285 1.51097 12.1085C1.51097 12.0818 1.51097 12.0585 1.51097 12.0385C1.51764 12.0185 1.5243 11.9985 1.53097 11.9785C1.5443 11.9585 1.55429 11.9419 1.56096 11.9285C1.56762 11.9152 1.57762 11.8985 1.59095 11.8785C1.61095 11.8519 1.62428 11.8352 1.63094 11.8285C1.64427 11.8152 1.66093 11.7986 1.68093 11.7786C1.70093 11.7519 1.71426 11.7352 1.72092 11.7286C1.75425 11.6886 1.83089 11.6053 1.95087 11.4786C2.07084 11.352 2.15748 11.2553 2.21081 11.1887C2.26413 11.1154 2.33744 11.0187 2.43075 10.8988C2.53073 10.7721 2.61404 10.6422 2.6807 10.5089C2.75401 10.3756 2.824 10.2289 2.89065 10.069C2.06417 9.58907 1.41433 8.99921 0.941104 8.29937C0.467881 7.59954 0.23127 6.85305 0.23127 6.0599C0.23127 5.13345 0.54453 4.27699 1.17105 3.4905C1.79757 2.70402 2.6507 2.08417 3.73045 1.63094ZM15.4877 12.6284C15.5543 12.7883 15.621 12.935 15.6876 13.0683C15.761 13.2016 15.8443 13.3315 15.9376 13.4582C16.0376 13.5781 16.1142 13.6714 16.1675 13.7381C16.2209 13.8114 16.3075 13.9114 16.4275 14.038C16.5474 14.1647 16.6241 14.248 16.6574 14.288C16.6641 14.2946 16.6774 14.308 16.6974 14.328C16.7174 14.3546 16.7307 14.3713 16.7374 14.3779C16.7507 14.3913 16.7641 14.4079 16.7774 14.4279C16.7974 14.4546 16.8107 14.4746 16.8174 14.4879C16.824 14.5013 16.8307 14.5179 16.8374 14.5379C16.8507 14.5579 16.8574 14.5779 16.8574 14.5979C16.864 14.6179 16.8674 14.6379 16.8674 14.6579C16.8674 14.6845 16.864 14.7079 16.8574 14.7279C16.8374 14.8212 16.794 14.8945 16.7274 14.9478C16.6607 15.0011 16.5874 15.0245 16.5075 15.0178C16.1742 14.9711 15.8876 14.9178 15.6477 14.8578C14.6212 14.5912 13.6948 14.1647 12.8683 13.5781C12.2684 13.6848 11.6819 13.7381 11.1087 13.7381C9.30247 13.7381 7.72951 13.2982 6.38983 12.4184C6.7764 12.4451 7.06967 12.4584 7.26962 12.4584C8.3427 12.4584 9.37246 12.3084 10.3589 12.0085C11.3453 11.7086 12.2251 11.2787 12.9983 10.7188C13.8314 10.1056 14.4713 9.39912 14.9178 8.5993C15.3644 7.79949 15.5877 6.95302 15.5877 6.0599C15.5877 5.54669 15.511 5.04014 15.3577 4.54026C16.2175 5.01348 16.8974 5.60667 17.3972 6.31984C17.8971 7.03301 18.1471 7.79949 18.1471 8.6193C18.1471 9.41911 17.9105 10.1689 17.4372 10.8688C16.964 11.5619 16.3142 12.1485 15.4877 12.6284Z" fill="#FF792D"/>
                            </svg>
                        </span>
                        <a href="<?php comments_link(); ?>">
                            <span><?php comments_number(esc_html__('No Comments', 'konstruc'), esc_html__(' 1 Comment', 'konstruc'), esc_html__('%  Comments', 'konstruc')); ?></span>
                        </a>
                    </span>

                    <span class="post-item post-time--read">
                        <span class="icon-post">
                            <i class="far fa-clock"></i>
                        </span>
                        <span>
                            <?php
                            echo do_shortcode('[reading_time]');
                            ?>
                        </span>
                    </span>
                </div>
            </div>
        <?php }

        public function konstruc_set_post_views( $postID ) {
            $countKey = 'post_views_count';
            $count    = get_post_meta( $postID, $countKey, true );
            if ( $count == '' ) {
                $count = 0;
                delete_post_meta( $postID, $countKey );
                add_post_meta( $postID, $countKey, '0' );
            } else {
                $count ++;
                update_post_meta( $postID, $countKey, $count );
            }
        }

        public function get_post_tags(){
            $post_tag = konstruc()->get_theme_opt( 'post_tag', true );
            if($post_tag != '1') return;
            $tags_list = get_the_tag_list();
            if ( $tags_list ){
                echo '<div class="post-tags ">';
                printf('%2$s', '', $tags_list);
                echo '</div>';
            }
        }

        public function get_post_share($post_id = 0) {
            $post_social_share = konstruc()->get_theme_opt( 'post_social_share', false );
            $share_icons = konstruc()->get_theme_opt( 'post_social_share_icon', [] );
            $social_facebook = konstruc()->get_theme_opt( 'social_facebook', [] );
            $social_twitter = konstruc()->get_theme_opt( 'social_twitter', [] );
            $social_pinterest = konstruc()->get_theme_opt( 'social_pinterest', [] );
            $social_linkedin = konstruc()->get_theme_opt( 'social_linkedin', [] );
            if($post_social_share != '1') return;
            $post = get_post($post_id);
            ?>
            <div class="post-shares">
                <span class="label"><?php echo esc_html__('Share:', 'konstruc'); ?> </span>
                <div class="social-share">
                    <div class="social">
                        <?php if($social_facebook): ?>
                            <a class="pxl-icon " title="<?php echo esc_attr__('Facebook', 'konstruc'); ?>" target="_blank" href="https://www.facebook.com/sharer/sharer.php?u=<?php echo urlencode(get_the_permalink($post_id)); ?>">
                                <i class="fab fa-facebook-f"></i>
                            </a>
                        <?php endif; ?>
                        <?php if($social_twitter): ?>
                            <a class="pxl-icon " title="<?php echo esc_attr__('Twitter', 'konstruc'); ?>" target="_blank" href="https://twitter.com/intent/tweet?original_referer=<?php echo urldecode(home_url('/')); ?>&url=<?php echo urlencode(get_the_permalink($post_id)); ?>&text=<?php the_title();?>%20">
                                <i class="fab fa-twitter"></i>
                            </a>
                        <?php endif; ?>
                        <?php if($social_pinterest): ?>
                            <a class="pxl-icon " title="<?php echo esc_attr__('Linkedin', 'konstruc'); ?>" target="_blank" href="https://www.linkedin.com/cws/share?url=<?php echo urlencode(get_the_permalink($post_id));?>">
                                <i class="fab fa-pinterest-p"></i>
                            </a>
                        <?php endif; ?>
                        <?php if($social_linkedin): ?>
                            <a class="pxl-icon " title="<?php echo esc_attr__('Pinterest', 'konstruc'); ?>" target="_blank" href="https://pinterest.com/pin/create/button/?url=<?php echo urlencode(get_the_post_thumbnail_url($post_id, 'full')); ?>&media=&description=<?php echo urlencode(the_title_attribute(array('echo' => false, 'post' => $post))); ?>">
                                <i class="fab fa-linkedin-in"></i>
                            </a>
                        <?php endif; ?>
                    </div>
                </div>
            </div>
            <?php
        }

        public function get_post_nav() {
            $post_navigation = konstruc()->get_theme_opt( 'post_navigation', false );
            if($post_navigation != '1') return;
            global $post;

            $previous = ( is_attachment() ) ? get_post( $post->post_parent ) : get_adjacent_post( false, '', true );
            $next     = get_adjacent_post( false, '', false );

            if ( ! $next && ! $previous )
                return;
            ?>
            <?php
            $next_post = get_next_post();
            $previous_post = get_previous_post();
            if(empty($previous_post) && empty($next_post)) return;

            ?>
            <div class="single-next-prev-nav row gx-0 justify-content-between align-items-center">
                <?php if(!empty($previous_post)): 
                    $prev_img_id = get_post_thumbnail_id($previous_post->ID);
                    $prev_img_url = wp_get_attachment_image_src($prev_img_id, 'thumbnail');

                    $img = pxl_get_image_by_size( array(
                        'attach_id'  => $prev_img_id,
                        'thumb_size' => '60x52',
                        'class' => 'no-lazyload',
                    ));
                    $thumbnail = $img['thumbnail'];
                    ?>
                    <div class="nav-next-prev prev col relative text-start">
                        <div class="nav-inner">
                            <?php previous_post_link('%link',''); ?>
                            <div class="nav-label-wrap  align-items-center">
                                <span class="nav-icon pxli-angle-left"></span>
                                <span class="nav-label"><?php echo esc_html__('Previous Post', 'konstruc'); ?></span>
                            </div>
                            <div class="nav-title-wrap  align-items-center d-none d-sm-flex">
                                <div class="nav-title"><?php echo get_the_title($previous_post->ID); ?></div>
                            </div>
                        </div>
                    </div>
                <?php endif; ?>
                <div class="grid-archive">
                    <a href="<?php echo get_post_type_archive_link( 'post' ); ?>">
                        <div class="nav-archive-button">
                            <div class="archive-btn-square square-1"></div>
                            <div class="archive-btn-square square-2"></div>
                            <div class="archive-btn-square square-3"></div>
                            <div class="archive-btn-square square-4"></div>
                        </div>
                    </a>
                </div>
                <?php if(!empty($next_post)) : 
                    $next_img_id = get_post_thumbnail_id($next_post->ID);
                    $next_img_url = wp_get_attachment_image_src($next_img_id, 'thumbnail');

                    $img = pxl_get_image_by_size( array(
                        'attach_id'  => $next_img_id,
                        'thumb_size' => '60x52',
                        'class' => 'no-lazyload',
                    ));
                    $thumbnail = $img['thumbnail'];
                    ?>
                    <div class="nav-next-prev next col relative text-end">
                        <div class="nav-inner">
                            <?php next_post_link('%link',''); ?>
                            <div class="nav-label-wrap  align-items-center justify-content-end">
                                <span class="nav-label"><?php echo esc_html__('Newer Post', 'konstruc'); ?></span>
                                <span class="nav-icon pxli-angle-right"></span>
                            </div>
                            <div class="nav-title-wrap  align-items-center d-none d-sm-flex">
                                <div class="nav-title"><?php echo get_the_title($next_post->ID); ?></div>
                            </div>
                        </div>
                    </div>
                <?php endif; ?>
            </div> 
            <?php  
        }
        public function get_project_nav() {
            global $post;
            $previous = ( is_attachment() ) ? get_post( $post->post_parent ) : get_adjacent_post( false, '', true );
            $next     = get_adjacent_post( false, '', false );
            $link_grid = konstruc()->get_theme_opt( 'link_grid', '' );
            if ( ! $next && ! $previous )
                return;
            ?>
            <?php
            $next_post = get_next_post();
            $previous_post = get_previous_post();

            if( !empty($next_post) || !empty($previous_post) ) { 
                ?>
                <div class="pxl-project--navigation">
                    <div class="pxl--items">
                        <div class="pxl--item pxl--item-prev">
                            <?php if ( is_a( $previous_post , 'WP_Post' ) && get_the_title( $previous_post->ID ) != '') { 
                                ?>
                                <a  href="<?php echo esc_url(get_permalink( $previous_post->ID )); ?>"><i class="far fa-arrow-left"></i>Prev Project</a>
                            <?php } ?>
                        </div>
                        <div class="pxl--item pxl--item-grid">
                            <?php if (!empty($link_grid)) { ?>
                                <a  href="<?php echo esc_url($link_grid); ?>">
                                    <span class="bl bl1"></span>
                                    <span class="bl bl2"></span>
                                    <span class="bl bl3"></span>
                                    <span class="bl bl4"></span>
                                </a>
                            <?php } ?>
                        </div>
                        <div class="pxl--item pxl--item-next">
                            <?php if ( is_a( $next_post , 'WP_Post' ) && get_the_title( $next_post->ID ) != '') {
                                ?>
                                <a href="<?php echo esc_url(get_permalink( $next_post->ID )); ?>">Next Project <i class="far fa-arrow-right"></i> </a>
                            <?php } ?>
                        </div>
                    </div><!-- .nav-links -->
                </div>
            <?php }
        }
        public function get_related_post(){
            $post_related_on = konstruc()->get_theme_opt( 'post_related_on', false );

            if($post_related_on) {
                global $post;
                $current_id = $post->ID;
                $posttags = get_the_category($post->ID);
                if (empty($posttags)) return;

                $tags = array();

                foreach ($posttags as $tag) {

                    $tags[] = $tag->term_id;
                }
                $post_number = '6';
                $query_similar = new WP_Query(array('posts_per_page' => $post_number, 'post_type' => 'post', 'post_status' => 'publish', 'category__in' => $tags));
                if (count($query_similar->posts) > 1) {
                    wp_enqueue_script( 'swiper' );
                    wp_enqueue_script( 'konstruc-swiper' );
                    $opts = [
                        'slide_direction'               => 'horizontal',
                        'slide_percolumn'               => '1', 
                        'slide_mode'                    => 'slide', 
                        'slides_to_show'                => 3, 
                        'slides_to_show_lg'             => 3, 
                        'slides_to_show_md'             => 2, 
                        'slides_to_show_sm'             => 2, 
                        'slides_to_show_xs'             => 1, 
                        'slides_to_scroll'              => 1, 
                        'slides_gutter'                 => 30, 
                        'arrow'                         => false,
                        'dots'                          => true,
                        'dots_style'                    => 'bullets'
                    ];
                    $data_settings = wp_json_encode($opts);
                    $dir           = is_rtl() ? 'rtl' : 'ltr';
                    ?>
                    <div class="pxl-related-post">
                        <h3 class="widget-title"><?php echo esc_html__('Related Posts', 'konstruc'); ?></h3>
                        <div class="class" data-settings="<?php echo esc_attr($data_settings) ?>" data-rtl="<?php echo esc_attr($dir) ?>">
                            <div class="pxl-related-post-inner pxl-swiper-wrapper swiper-wrapper">
                                <?php foreach ($query_similar->posts as $post):
                                    $thumbnail_url = '';
                                    if (has_post_thumbnail(get_the_ID()) && wp_get_attachment_image_src(get_post_thumbnail_id($post->ID), false)) :
                                        $thumbnail_url = wp_get_attachment_image_src(get_post_thumbnail_id($post->ID), 'konstruc-blog-small', false);
                                endif;
                                if ($post->ID !== $current_id) : ?>
                                    <div class="pxl-swiper-slide swiper-slide grid-item">
                                        <div class="grid-item-inner">
                                            <?php if (has_post_thumbnail()) { ?>
                                                <div class="item-featured">
                                                    <a href="<?php the_permalink(); ?>"><img src="<?php echo esc_url($thumbnail_url[0]); ?>" /></a>
                                                </div>
                                            <?php } ?>
                                            <h3 class="item-title">
                                                <a href="<?php the_permalink(); ?>"><?php the_title(); ?></a>
                                            </h3>
                                        </div>
                                    </div>
                                <?php endif;
                            endforeach; ?>
                        </div>
                    </div>
                </div>
            <?php }
        }

        wp_reset_postdata();
    }
}

}