<?php if(!function_exists('konstruc_configs')){
    function konstruc_configs($value){
        $configs = [
            'theme_colors' => [
                'primary'   => [
                    'title' => esc_html__('Primary', 'konstruc'), 
                    'value' => konstruc()->get_opt('primary_color', '#FF792D')
                ],
                'secondary'   => [
                    'title' => esc_html__('Secondary', 'konstruc'), 
                    'value' => konstruc()->get_opt('secondary_color', '#0a1119')
                ],
                'third'   => [
                    'title' => esc_html__('Third', 'konstruc'), 
                    'value' => konstruc()->get_opt('third_color', '#4b535d')
                ],
                'body_bg'   => [
                    'title' => esc_html__('Body Background Color', 'konstruc'), 
                    'value' => konstruc()->get_opt('body_bg_color', '#fff')
                ]
            ],
            'link' => [
                'color' => konstruc()->get_opt('link_color', ['regular' => '#1E2023'])['regular'],
                'color-hover'   => konstruc()->get_opt('link_color', ['hover' => '#FFF'])['hover'],
                'color-active'  => konstruc()->get_opt('link_color', ['active' => '#FFF'])['active'],
            ],
            // 'gradient' => [
            //     'color-from' => konstruc()->get_opt('gradient_color', ['from' => '#FF6400'])['from'],
            //     'color-to' => konstruc()->get_opt('gradient_color', ['to' => '#FF0100'])['to'],
            // ],
               
        ];
        return $configs[$value];
    }
}
if(!function_exists('konstruc_inline_styles')) {
    function konstruc_inline_styles() {  
        
        $theme_colors      = konstruc_configs('theme_colors');
        $link_color        = konstruc_configs('link');
        // $gradient_color    = konstruc_configs('gradient');
        ob_start();
        echo ':root{';
            
            foreach ($theme_colors as $color => $value) {
                printf('--%1$s-color: %2$s;', str_replace('#', '',$color),  $value['value']);
            }
            foreach ($theme_colors as $color => $value) {
                printf('--%1$s-color-rgb: %2$s;', str_replace('#', '',$color),  konstruc_hex_rgb($value['value']));
            }
            foreach ($link_color as $color => $value) {
                printf('--link-%1$s: %2$s;', $color, $value);
            }
            // foreach ($gradient_color as $color => $value) {
            //     printf('--gradient-%1$s: %2$s;', $color, $value);
            // }
        echo '}';

        return ob_get_clean();
         
    }
}
 