<?php
 
add_action( 'pxl_post_metabox_register', 'konstruc_page_options_register' );
function konstruc_page_options_register( $metabox ) {
 
	$panels = [
		'post' => [
			'opt_name'            => 'post_option',
			'display_name'        => esc_html__( 'Post Settings', 'konstruc' ),
			'show_options_object' => false,
			'context'  => 'advanced',
			'priority' => 'default',
			'sections'  => [
				'post_settings' => [
					'title'  => esc_html__( 'Post Settings', 'konstruc' ),
					'icon'   => 'el el-refresh',
					'fields' => array_merge(
						konstruc_sidebar_pos_opts(['prefix' => 'post_', 'default' => true, 'default_value' => '-1']),
						konstruc_page_title_opts([
							'default'         => true,
							'default_value'   => '-1'
						]),
                        array(
                            array(
								'id'	=> 'type_post_feature',
								'type'	=> 'button_set',
								'title'	=> esc_html__('Post Feature','konstruc'),
								'options'	=>  array(
									'default'	=> esc_html__('Default','konstruc'),
									'video_link'=> esc_html__('Video','konstruc'),
									'image_swiper'	=> esc_html__('Image Swiper','konstruc'),
								),
								'default'	=> 'default',	
							),
							array(
								'id'=> 'post_video_link',
								'type' => 'text',
								'title' => esc_html__('Video Link', 'konstruc'),
								'validate' => 'url',
								'default' => '',
								'indent' => true,
								'required' => array( 0 => 'type_post_feature', 1 => 'equals', 2 => 'video_link' ),
							),
							array(
								'id'       => 'post_images',
								'type'     => 'gallery',
								'title'    => esc_html__('Images', 'konstruc'),
								'default'  => array(),
								'url'      => '',
								'indent' => true,
								'required' => array( 0 => 'type_post_feature', 1 => 'equals', 2 => 'image_swiper' ),
							),
							array(
								'id'             => 'content_spacing',
								'type'           => 'spacing',
								'output'         => array( '#pxl-wapper #pxl-main' ),
								'right'          => false,
								'left'           => false,
								'mode'           => 'padding',
								'units'          => array( 'px' ),
								'units_extended' => 'false',
								'title'          => esc_html__( 'Spacing Top/Bottom', 'konstruc' ),
								'default'        => array(
									'padding-top'    => '',
									'padding-bottom' => '',
									'units'          => 'px',
								)
							),
							array(
								'id'=> 'description_post',
								'type' => 'textarea',
								'title' => esc_html__('Description Post', 'konstruc'),
							),
                        )
					)
				]
			]
		],
		'page' => [
			'opt_name'            => 'pxl_page_options',
			'display_name'        => esc_html__( 'Page Options', 'konstruc' ),
			'show_options_object' => false,
			'context'  => 'advanced',
			'priority' => 'default',
			'sections'  => [
				'header' => [
					'title'  => esc_html__( 'Header', 'konstruc' ),
					'icon'   => 'el-icon-website',
					'fields' => array_merge(
				        konstruc_header_opts([
							'default'         => true,
							'default_value'   => '-1'
						]),
						konstruc_header_mobile_opts([
							'default'         => true,
							'default_value'   => '-1'
						]),
						array(
							array(
				                'id'       => 'header_display',
				                'type'     => 'button_set',
				                'title'    => esc_html__('Header Display', 'konstruc'),
				                'options'  => array(
				                    'show' => esc_html__('Show', 'konstruc'),
				                    'hide'  => esc_html__('Hide', 'konstruc'),
				                ),
				                'default'  => 'show',
				            ),
				            array(
				           		'id'       => 'logo_m',
					            'type'     => 'media',
					            'title'    => esc_html__('Mobile Logo', 'konstruc'),
					            'default'  => '',
					            'url'      => false,
					        ),
				            array(
				           		'id'       => 'logo_pg',
					            'type'     => 'media',
					            'title'    => esc_html__('Logo Search', 'konstruc'),
					            'default'  => '',
					            'url'      => false,
					        ),
				            array(
				           		'id'       => 'loader_logo_p',
					            'type'     => 'media',
					            'title'    => esc_html__('Logo Loader', 'konstruc'),
					            'default'  => '',
					            'url'      => false,
					        ),
					        array(
				                'id'       => 'p_menu',
				                'type'     => 'select',
				                'title'    => esc_html__( 'Menu', 'konstruc' ),
				                'options'  => konstruc_get_nav_menu_slug(),
				                'default' => '',
				            ),
					    ),
					    array(
				            array(
				                'id'       => 'sticky_scroll',
				                'type'     => 'button_set',
				                'title'    => esc_html__('Sticky Scroll', 'konstruc'),
				                'options'  => array(
				                    '-1' => esc_html__('Inherit', 'konstruc'),
				                    'pxl-sticky-stt' => esc_html__('Scroll To Top', 'konstruc'),
				                    'pxl-sticky-stb'  => esc_html__('Scroll To Bottom', 'konstruc'),
				                ),
				                'default'  => '-1',
				            ),
				            array(
				                'id'       => 'header_margin',
				                'type'     => 'spacing',
				                'mode'     => 'margin',
				                'title'    => esc_html__('Margin', 'konstruc'),
				                'width'    => false,
				                'unit'     => 'px',
				                'output'    => array('#pxl-header-elementor .pxl-header-elementor-main'),
				            ),
				        )
				    )
					 
				],
				'page_title' => [
					'title'  => esc_html__( 'Page Title', 'konstruc' ),
					'icon'   => 'el el-indent-left',
					'fields' => array_merge(
				        konstruc_page_title_opts([
							'default'         => true,
							'default_value'   => '-1'
						])
				    )
				],
				'content' => [
					'title'  => esc_html__( 'Content', 'konstruc' ),
					'icon'   => 'el-icon-pencil',
					'fields' => array_merge(
						konstruc_sidebar_pos_opts(['prefix' => 'page_', 'default' => false, 'default_value' => '0']),
						array(
					        array(
								'id'             => 'content_spacing',
								'type'           => 'spacing',
								'output'         => array( '#pxl-wapper #pxl-main' ),
								'right'          => false,
								'left'           => false,
								'mode'           => 'padding',
								'units'          => array( 'px' ),
								'units_extended' => 'false',
								'title'          => esc_html__( 'Spacing Top/Bottom', 'konstruc' ),
								'default'        => array(
									'padding-top'    => '',
									'padding-bottom' => '',
									'units'          => 'px',
								)
							), 
					    )
					)
				],
				'footer' => [
					'title'  => esc_html__( 'Footer', 'konstruc' ),
					'icon'   => 'el el-website',
					'fields' => array_merge(
				        konstruc_footer_opts([
							'default'         => true,
							'default_value'   => '-1'
						]),
						array(
							array(
				                'id'       => 'footer_display',
				                'type'     => 'button_set',
				                'title'    => esc_html__('Footer Display', 'konstruc'),
				                'options'  => array(
				                    'show' => esc_html__('Show', 'konstruc'),
				                    'hide'  => esc_html__('Hide', 'konstruc'),
				                ),
				                'default'  => 'show',
				            ),
							array(
				                'id'       => 'p_footer_fixed',
				                'type'     => 'button_set',
				                'title'    => esc_html__('Footer Fixed', 'konstruc'),
				                'options'  => array(
				                    'inherit' => esc_html__('Inherit', 'konstruc'),
				                    'on' => esc_html__('On', 'konstruc'),
				                    'off' => esc_html__('Off', 'konstruc'),
				                ),
				                'default'  => 'inherit',
				            ),
				            array(
				                'id'       => 'back_top_top_style',
				                'type'     => 'button_set',
				                'title'    => esc_html__('Back to Top Style', 'konstruc'),
				                'options'  => array(
				                    'style-default' => esc_html__('Default', 'konstruc'),
				                    'style-round' => esc_html__('Round', 'konstruc'),
				                ),
				                'default'  => 'style-default',
				            ),
						)
				    )
				],
				'colors' => [
					'title'  => esc_html__( 'Colors', 'konstruc' ),
					'icon'   => 'el el-website',
					'fields' => array_merge(
				        array(
							array(
								'id'       => 'content_bgp_color',
								'type'     => 'color_rgba',
								'title'    => esc_html__('Body Background Color', 'konstruc'),
								'subtitle' => esc_html__('Body Background color.', 'konstruc'),
								'output'   => array('background-color' => 'body')
							),
				        	array(
					            'id'          => 'primary_color',
					            'type'        => 'color',
					            'title'       => esc_html__('Primary Color', 'konstruc'),
					            'transparent' => false,
					            'default'     => ''
					        ),
					    )
				    )
				],
				'extra' => [
					'title'  => esc_html__( 'Extra', 'konstruc' ),
					'icon'   => 'el el-website',
					'fields' => array_merge(
				        array(
				        	array(
					            'id' => 'body_custom_class',
					            'type' => 'text',
					            'title' => esc_html__('Body Custom Class', 'konstruc'),
					        ),
					    )
				    )
				]
			]
		],
		'portfolio' => [
			'opt_name'            => 'pxl_portfolio_options',
			'display_name'        => esc_html__( 'Product Options', 'konstruc' ),
			'show_options_object' => false,
			'context'  => 'advanced',
			'priority' => 'default',
			'sections'  => [
				'header' => [
					'title'  => esc_html__( 'General', 'konstruc' ),
					'icon'   => 'el-icon-website',
					'fields' => array_merge(
						array(
                            array(
                                'id'          => 'client',
                                'type'        => 'text',
                                'title'       => esc_html__( 'Client', 'konstruc' ),
                            ),
                            array(
                                'id'          => 'date_finish',
                                'type'        => 'text',
                                'title'       => esc_html__( 'Start Day', 'konstruc' ),
                            ),
						)
				    )
				],
				'header1' => [
					'title'  => esc_html__( 'Header', 'konstruc' ),
					'icon'   => 'el-icon-website',
					'fields' => array_merge(
				        konstruc_header_opts([
							'default'         => true,
							'default_value'   => '-1'
						]),
						konstruc_header_mobile_opts([
							'default'         => true,
							'default_value'   => '-1'
						]),
						array(
							array(
				                'id'       => 'header_display',
				                'type'     => 'button_set',
				                'title'    => esc_html__('Header Display', 'konstruc'),
				                'options'  => array(
				                    'show' => esc_html__('Show', 'konstruc'),
				                    'hide'  => esc_html__('Hide', 'konstruc'),
				                ),
				                'default'  => 'show',
				            ),
				            array(
				           		'id'       => 'logo_m',
					            'type'     => 'media',
					            'title'    => esc_html__('Mobile Logo', 'konstruc'),
					            'default'  => '',
					            'url'      => false,
					        ),
					        array(
				                'id'       => 'p_menu',
				                'type'     => 'select',
				                'title'    => esc_html__( 'Menu', 'konstruc' ),
				                'options'  => konstruc_get_nav_menu_slug(),
				                'default' => '',
				            ),
					    ),
					    array(
				            array(
				                'id'       => 'sticky_scroll',
				                'type'     => 'button_set',
				                'title'    => esc_html__('Sticky Scroll', 'konstruc'),
				                'options'  => array(
				                    '-1' => esc_html__('Inherit', 'konstruc'),
				                    'pxl-sticky-stt' => esc_html__('Scroll To Top', 'konstruc'),
				                    'pxl-sticky-stb'  => esc_html__('Scroll To Bottom', 'konstruc'),
				                ),
				                'default'  => '-1',
				            ),
				            array(
				                'id'       => 'header_margin',
				                'type'     => 'spacing',
				                'mode'     => 'margin',
				                'title'    => esc_html__('Margin', 'konstruc'),
				                'width'    => false,
				                'unit'     => 'px',
				                'output'    => array('#pxl-header-elementor .pxl-header-elementor-main'),
				            ),
				        )
				    )
					 
				],
				'page_title' => [
					'title'  => esc_html__( 'Page Title', 'konstruc' ),
					'icon'   => 'el el-indent-left',
					'fields' => array_merge(
				        konstruc_page_title_opts([
							'default'         => true,
							'default_value'   => '-1'
						])
				    )
				],
				'content' => [
					'title'  => esc_html__( 'Content', 'konstruc' ),
					'icon'   => 'el-icon-pencil',
					'fields' => array_merge(
						konstruc_sidebar_pos_opts(['prefix' => 'page_', 'default' => false, 'default_value' => '0']),
						array(
					        array(
								'id'             => 'content_spacing',
								'type'           => 'spacing',
								'output'         => array( '#pxl-wapper #pxl-main' ),
								'right'          => false,
								'left'           => false,
								'mode'           => 'padding',
								'units'          => array( 'px' ),
								'units_extended' => 'false',
								'title'          => esc_html__( 'Spacing Top/Bottom', 'konstruc' ),
								'default'        => array(
									'padding-top'    => '',
									'padding-bottom' => '',
									'units'          => 'px',
								)
							), 
					    )
					)
				],
				'footer' => [
					'title'  => esc_html__( 'Footer', 'konstruc' ),
					'icon'   => 'el el-website',
					'fields' => array_merge(
				        konstruc_footer_opts([
							'default'         => true,
							'default_value'   => '-1'
						]),
						array(
							array(
				                'id'       => 'footer_display',
				                'type'     => 'button_set',
				                'title'    => esc_html__('Footer Display', 'konstruc'),
				                'options'  => array(
				                    'show' => esc_html__('Show', 'konstruc'),
				                    'hide'  => esc_html__('Hide', 'konstruc'),
				                ),
				                'default'  => 'show',
				            ),
							array(
				                'id'       => 'p_footer_fixed',
				                'type'     => 'button_set',
				                'title'    => esc_html__('Footer Fixed', 'konstruc'),
				                'options'  => array(
				                    'inherit' => esc_html__('Inherit', 'konstruc'),
				                    'on' => esc_html__('On', 'konstruc'),
				                    'off' => esc_html__('Off', 'konstruc'),
				                ),
				                'default'  => 'inherit',
				            ),
				            array(
				                'id'       => 'back_top_top_style',
				                'type'     => 'button_set',
				                'title'    => esc_html__('Back to Top Style', 'konstruc'),
				                'options'  => array(
				                    'style-default' => esc_html__('Default', 'konstruc'),
				                    'style-round' => esc_html__('Round', 'konstruc'),
				                ),
				                'default'  => 'style-default',
				            ),
						)
				    )
				],
			]
		],
		'product' => [
			'opt_name'            => 'pxl_product_options',
			'display_name'        => esc_html__( 'Portfolio Options', 'konstruc' ),
			'show_options_object' => false,
			'context'  => 'advanced',
			'priority' => 'default',
			'sections'  => [
				'header1' => [
					'title'  => esc_html__( 'Header', 'konstruc' ),
					'icon'   => 'el-icon-website',
					'fields' => array_merge(
				        konstruc_header_opts([
							'default'         => true,
							'default_value'   => '-1'
						]),
						konstruc_header_mobile_opts([
							'default'         => true,
							'default_value'   => '-1'
						]),
						array(
							array(
				                'id'       => 'header_display',
				                'type'     => 'button_set',
				                'title'    => esc_html__('Header Display', 'konstruc'),
				                'options'  => array(
				                    'show' => esc_html__('Show', 'konstruc'),
				                    'hide'  => esc_html__('Hide', 'konstruc'),
				                ),
				                'default'  => 'show',
				            ),
				            array(
				           		'id'       => 'logo_m',
					            'type'     => 'media',
					            'title'    => esc_html__('Mobile Logo', 'konstruc'),
					            'default'  => '',
					            'url'      => false,
					        ),
					        array(
				                'id'       => 'p_menu',
				                'type'     => 'select',
				                'title'    => esc_html__( 'Menu', 'konstruc' ),
				                'options'  => konstruc_get_nav_menu_slug(),
				                'default' => '',
				            ),
					    ),
					    array(
				            array(
				                'id'       => 'sticky_scroll',
				                'type'     => 'button_set',
				                'title'    => esc_html__('Sticky Scroll', 'konstruc'),
				                'options'  => array(
				                    '-1' => esc_html__('Inherit', 'konstruc'),
				                    'pxl-sticky-stt' => esc_html__('Scroll To Top', 'konstruc'),
				                    'pxl-sticky-stb'  => esc_html__('Scroll To Bottom', 'konstruc'),
				                ),
				                'default'  => '-1',
				            ),
				            array(
				                'id'       => 'header_margin',
				                'type'     => 'spacing',
				                'mode'     => 'margin',
				                'title'    => esc_html__('Margin', 'konstruc'),
				                'width'    => false,
				                'unit'     => 'px',
				                'output'    => array('#pxl-header-elementor .pxl-header-elementor-main'),
				            ),
				        )
				    )
					 
				],
				'page_title' => [
					'title'  => esc_html__( 'Page Title', 'konstruc' ),
					'icon'   => 'el el-indent-left',
					'fields' => array_merge(
				        konstruc_page_title_opts([
							'default'         => true,
							'default_value'   => '-1'
						])
				    )
				],
				'content' => [
					'title'  => esc_html__( 'Content', 'konstruc' ),
					'icon'   => 'el-icon-pencil',
					'fields' => array_merge(
						konstruc_sidebar_pos_opts(['prefix' => 'page_', 'default' => false, 'default_value' => '0']),
						array(
					        array(
								'id'             => 'content_spacing',
								'type'           => 'spacing',
								'output'         => array( '#pxl-wapper #pxl-main' ),
								'right'          => false,
								'left'           => false,
								'mode'           => 'padding',
								'units'          => array( 'px' ),
								'units_extended' => 'false',
								'title'          => esc_html__( 'Spacing Top/Bottom', 'konstruc' ),
								'default'        => array(
									'padding-top'    => '',
									'padding-bottom' => '',
									'units'          => 'px',
								)
							), 
					    )
					)
				],
				'footer' => [
					'title'  => esc_html__( 'Footer', 'konstruc' ),
					'icon'   => 'el el-website',
					'fields' => array_merge(
				        konstruc_footer_opts([
							'default'         => true,
							'default_value'   => '-1'
						]),
				    )
				],
			]
		],
		'service' => [
			'opt_name'            => 'pxl_service_options',
			'display_name'        => esc_html__( 'Service Options', 'konstruc' ),
			'show_options_object' => false,
			'context'  => 'advanced',
			'priority' => 'default',
			'sections'  => [
				'header' => [
					'title'  => esc_html__( 'General', 'konstruc' ),
					'icon'   => 'el-icon-website',
					'fields' => array_merge(
						array(
							array(
					            'id'=> 'service_external_link',
					            'type' => 'text',
					            'title' => esc_html__('External Link', 'konstruc'),
					            'validate' => 'url',
					            'default' => '',
					        ),
							array(
								'id'=>'multi_text_country',
								'type' => 'multi_text',
								'title' => ('Multi Text Option'),
								'title'    => esc_html('Mutil Text', 'konstruc'),
							),
							array(
								'id'       => 'icon_multi_text',
								'type'     => 'pxl_iconpicker',
								'title'    => esc_html__('Icon Multi Text', 'konstruc'),
								'force_output' => true
							),
					        array(
					            'id'       => 'service_icon_type',
					            'type'     => 'button_set',
					            'title'    => esc_html__('Icon Type', 'konstruc'),
					            'options'  => array(
					                'icon'  => esc_html__('Icon', 'konstruc'),
					                'image'  => esc_html__('Image', 'konstruc'),
					            ),
					            'default'  => 'icon'
					        ),
					        array(
					            'id'       => 'service_icon_font',
					            'type'     => 'pxl_iconpicker',
					            'title'    => esc_html__('Icon', 'konstruc'),
					            'required' => array( 0 => 'service_icon_type', 1 => 'equals', 2 => 'icon' ),
            					'force_output' => true
					        ),
					        array(
					            'id'       => 'service_icon_img',
					            'type'     => 'media',
					            'title'    => esc_html__('Icon Image', 'konstruc'),
					            'default' => '',
					            'required' => array( 0 => 'service_icon_type', 1 => 'equals', 2 => 'image' ),
				            	'force_output' => true
					        ),
						)
				    )
				],
				'header1' => [
					'title'  => esc_html__( 'Header', 'konstruc' ),
					'icon'   => 'el-icon-website',
					'fields' => array_merge(
				        konstruc_header_opts([
							'default'         => true,
							'default_value'   => '-1'
						]),
						konstruc_header_mobile_opts([
							'default'         => true,
							'default_value'   => '-1'
						]),
						array(
							array(
				                'id'       => 'header_display',
				                'type'     => 'button_set',
				                'title'    => esc_html__('Header Display', 'konstruc'),
				                'options'  => array(
				                    'show' => esc_html__('Show', 'konstruc'),
				                    'hide'  => esc_html__('Hide', 'konstruc'),
				                ),
				                'default'  => 'show',
				            ),
				            array(
				           		'id'       => 'logo_m',
					            'type'     => 'media',
					            'title'    => esc_html__('Mobile Logo', 'konstruc'),
					            'default'  => '',
					            'url'      => false,
					        ),
					        array(
				                'id'       => 'p_menu',
				                'type'     => 'select',
				                'title'    => esc_html__( 'Menu', 'konstruc' ),
				                'options'  => konstruc_get_nav_menu_slug(),
				                'default' => '',
				            ),
					    ),
					    array(
				            array(
				                'id'       => 'sticky_scroll',
				                'type'     => 'button_set',
				                'title'    => esc_html__('Sticky Scroll', 'konstruc'),
				                'options'  => array(
				                    '-1' => esc_html__('Inherit', 'konstruc'),
				                    'pxl-sticky-stt' => esc_html__('Scroll To Top', 'konstruc'),
				                    'pxl-sticky-stb'  => esc_html__('Scroll To Bottom', 'konstruc'),
				                ),
				                'default'  => '-1',
				            ),
				            array(
				                'id'       => 'header_margin',
				                'type'     => 'spacing',
				                'mode'     => 'margin',
				                'title'    => esc_html__('Margin', 'konstruc'),
				                'width'    => false,
				                'unit'     => 'px',
				                'output'    => array('#pxl-header-elementor .pxl-header-elementor-main'),
				            ),
				        )
				    )
					 
				],
				'page_title' => [
					'title'  => esc_html__( 'Page Title', 'konstruc' ),
					'icon'   => 'el el-indent-left',
					'fields' => array_merge(
				        konstruc_page_title_opts([
							'default'         => true,
							'default_value'   => '-1'
						])
				    )
				],
				'content' => [
					'title'  => esc_html__( 'Content', 'konstruc' ),
					'icon'   => 'el-icon-pencil',
					'fields' => array_merge(
						konstruc_sidebar_pos_opts(['prefix' => 'page_', 'default' => false, 'default_value' => '0']),
						array(
					        array(
								'id'             => 'content_spacing',
								'type'           => 'spacing',
								'output'         => array( '#pxl-wapper #pxl-main' ),
								'right'          => false,
								'left'           => false,
								'mode'           => 'padding',
								'units'          => array( 'px' ),
								'units_extended' => 'false',
								'title'          => esc_html__( 'Spacing Top/Bottom', 'konstruc' ),
								'default'        => array(
									'padding-top'    => '',
									'padding-bottom' => '',
									'units'          => 'px',
								)
							), 
					    )
					)
				],
				'footer' => [
					'title'  => esc_html__( 'Footer', 'konstruc' ),
					'icon'   => 'el el-website',
					'fields' => array_merge(
				        konstruc_footer_opts([
							'default'         => true,
							'default_value'   => '-1'
						]),
						array(
							array(
				                'id'       => 'footer_display',
				                'type'     => 'button_set',
				                'title'    => esc_html__('Footer Display', 'konstruc'),
				                'options'  => array(
				                    'show' => esc_html__('Show', 'konstruc'),
				                    'hide'  => esc_html__('Hide', 'konstruc'),
				                ),
				                'default'  => 'show',
				            ),
							array(
				                'id'       => 'p_footer_fixed',
				                'type'     => 'button_set',
				                'title'    => esc_html__('Footer Fixed', 'konstruc'),
				                'options'  => array(
				                    'inherit' => esc_html__('Inherit', 'konstruc'),
				                    'on' => esc_html__('On', 'konstruc'),
				                    'off' => esc_html__('Off', 'konstruc'),
				                ),
				                'default'  => 'inherit',
				            ),
				            array(
				                'id'       => 'back_top_top_style',
				                'type'     => 'button_set',
				                'title'    => esc_html__('Back to Top Style', 'konstruc'),
				                'options'  => array(
				                    'style-default' => esc_html__('Default', 'konstruc'),
				                    'style-round' => esc_html__('Round', 'konstruc'),
				                ),
				                'default'  => 'style-default',
				            ),
						)
				    )
				],
			]
		],

		'pxl-template' => [ //post_type
			'opt_name'            => 'pxl_hidden_template_options',
			'display_name'        => esc_html__( 'Template Options', 'konstruc' ),
			'show_options_object' => false,
			'context'  => 'advanced',
			'priority' => 'default',
			'sections'  => [
				'header' => [
					'title'  => esc_html__( 'General', 'konstruc' ),
					'icon'   => 'el-icon-website',
					'fields' => array(
						array(
							'id'    => 'template_type',
							'type'  => 'select',
							'title' => esc_html__('Type', 'konstruc'),
				            'options' => [
				            	'df'       	   => esc_html__('Select Type', 'konstruc'), 
								'header'       => esc_html__('Header Desktop', 'konstruc'),
								'header-mobile'       => esc_html__('Header Mobile', 'konstruc'),
								'footer'       => esc_html__('Footer', 'konstruc'), 
								'mega-menu'    => esc_html__('Mega Menu', 'konstruc'), 
								'page-title'   => esc_html__('Page Title', 'konstruc'), 
								'tab' => esc_html__('Tab', 'konstruc'),
								'hidden-panel' => esc_html__('Hidden Panel', 'konstruc'),
								'popup' => esc_html__('Popup', 'konstruc'),
								'widget' => esc_html__('Widget Sidebar', 'konstruc'),
								'page' => esc_html__('Page', 'konstruc'),
								'slider' => esc_html__('Slider', 'konstruc'),
				            ],
				            'default' => 'df',
				        ),
				        array(
							'id'    => 'header_type',
							'type'  => 'select',
							'title' => esc_html__('Header Type', 'konstruc'),
				            'options' => [
				            	'px-header--default'       	   => esc_html__('Default', 'konstruc'), 
								'px-header--transparent'       => esc_html__('Transparent', 'konstruc'),
								'px-header--left_sidebar'       => esc_html__('Left Sidebar', 'konstruc'),
				            ],
				            'default' => 'px-header--default',
				            'indent' => true,
                			'required' => array( 0 => 'template_type', 1 => 'equals', 2 => 'header' ),
				        ),

				        array(
							'id'    => 'header_mobile_type',
							'type'  => 'select',
							'title' => esc_html__('Header Type', 'konstruc'),
				            'options' => [
				            	'px-header--default'       	   => esc_html__('Default', 'konstruc'), 
								'px-header--transparent'       => esc_html__('Transparent', 'konstruc'),
				            ],
				            'default' => 'px-header--default',
				            'indent' => true,
                			'required' => array( 0 => 'template_type', 1 => 'equals', 2 => 'header-mobile' ),
				        ),

				        array(
							'id'    => 'hidden_panel_position',
							'type'  => 'select',
							'title' => esc_html__('Hidden Panel Position', 'konstruc'),
				            'options' => [
				            	'top'       	   => esc_html__('Top', 'konstruc'),
				            	'right'       	   => esc_html__('Right', 'konstruc'),
				            ],
				            'default' => 'right',
				            'required' => array( 0 => 'template_type', 1 => 'equals', 2 => 'hidden-panel' ),
				        ),
				        array(
				            'id'          => 'hidden_panel_height',
				            'type'        => 'text',
				            'title'       => esc_html__('Hidden Panel Height', 'konstruc'),
				            'subtitle'       => esc_html__('Enter number.', 'konstruc'),
				            'transparent' => false,
				            'default'     => '',
				            'force_output' => true,
				            'required' => array( 0 => 'hidden_panel_position', 1 => 'equals', 2 => 'top' ),
				        ),
				        array(
				            'id'          => 'hidden_panel_boxcolor',
				            'type'        => 'color',
				            'title'       => esc_html__('Box Color', 'konstruc'),
				            'transparent' => false,
				            'default'     => '',
				            'required' => array( 0 => 'template_type', 1 => 'equals', 2 => 'hidden-panel' ),
				        ),

				        array(
				            'id'          => 'header_sidebar_width',
				            'type'        => 'slider',
				            'title'       => esc_html__('Header Sidebar Width', 'konstruc'),
				            "default"   => 300,
						    "min"       => 50,
						    "step"      => 1,
						    "max"       => 900,
				            'force_output' => true,
				            'required' => array( 0 => 'header_type', 1 => 'equals', 2 => 'px-header--left_sidebar' ),
				        ),

				        array(
				            'id'          => 'header_sidebar_border',
				            'type'        => 'border',
				            'title'       => esc_html__('Header Sidebar Border', 'konstruc'),
				            'force_output' => true,
				            'required' => array( 0 => 'header_type', 1 => 'equals', 2 => 'px-header--left_sidebar' ),
				            'default' => '',
				        ),
					),
				    
				],
			]
		],
	];
 
	$metabox->add_meta_data( $panels );
}
 