<?php
/**
 * @package Konstruc
 */
$archive_readmore_text = konstruc()->get_theme_opt('archive_readmore_text', esc_html__('READ DETAILS', 'konstruc'));
$featured_img_size = konstruc()->get_theme_opt('featured_img_size', '869x462');
$post_video_link = get_post_meta(get_the_ID(), 'post_video_link', true);
$description_post = get_post_meta(get_the_ID(), 'description_post', true);
$post_images = get_post_meta(get_the_ID(), 'post_images');
$type_post_feature = get_post_meta(get_the_ID(),'type_post_feature','default');
?>
<article id="post-<?php the_ID(); ?>" <?php post_class('pxl---post pxl-item--archive pxl-item--standard'); ?>>


    <?php if ($type_post_feature === 'default'): ?>
        <?php if (has_post_thumbnail()): ?>
            <?php
            $img = pxl_get_image_by_size(array(
                'attach_id'  => get_post_thumbnail_id($post->ID),
                'thumb_size' => $featured_img_size,
            ));
            $thumbnail = $img['thumbnail'];
            ?>
            <div class="pxl-item--image">
                <a href="<?php echo esc_url(get_permalink()); ?>"><?php echo pxl_print_html($thumbnail); ?></a>
            </div>
        <?php endif; ?>

    <?php elseif ($type_post_feature === 'video_link'): ?>
        <?php if (has_post_thumbnail()): ?>
            <?php
            $img = pxl_get_image_by_size(array(
                'attach_id'  => get_post_thumbnail_id($post->ID),
                'thumb_size' => $featured_img_size,
            ));
            $thumbnail = $img['thumbnail'];
            ?>
            <div class="pxl-item--image">
                <a href="<?php echo esc_url(get_permalink()); ?>">
                    <?php echo pxl_print_html($thumbnail); ?>
                </a>
                <?php if (!empty($post_video_link)): ?>
                    <a href="<?php echo esc_url($post_video_link); ?>" class="post-button-video btn-video-style2 pxl-action-popup">
                        <i class="caseicon-play1"></i>
                    </a>
                <?php endif; ?>
            </div>
        <?php endif; ?>

    <?php elseif ($type_post_feature === 'image_swiper'): ?>
        <div class="pxl-swiper-slider pxl-image-carousel">
            <div class="pxl-image--swiper">
                <?php $post_images = explode(',', $post_images[0]); ?>  
                <?php foreach ($post_images as $image_id): ?>
                    <?php
                    $img_post = pxl_get_image_by_size(array(
                        'attach_id'  => $image_id,
                        'thumb_size' => 'full', 
                    ));
                    $thumbnail = $img_post['thumbnail'];
                    ?>
                    <div class="pxl-swiper-slide swiper-slide grid-item">
                        <div class="pxl-item--image">
                            <a href="<?php echo esc_url(get_permalink()); ?>">
                                <?php echo pxl_print_html($thumbnail); ?>
                            </a>
                        </div>
                    </div>
                <?php endforeach; ?>

            </div>
            <div class="pxl-swiper-arrow-wrap style-3">
                <div class="pxl-swiper-arrow pxl-swiper-arrow-prev slick-prev">
                    <svg xmlns="http://www.w3.org/2000/svg" width="60" height="60" viewBox="0 0 60 60" fill="none">
                        <path d="M19.3636 30.6364C19.0121 30.2849 19.0121 29.7151 19.3636 29.3636L25.0912 23.636C25.4426 23.2846 26.0125 23.2846 26.364 23.636C26.7154 23.9875 26.7154 24.5574 26.364 24.9088L21.2728 30L26.364 35.0912C26.7154 35.4426 26.7154 36.0125 26.364 36.364C26.0125 36.7154 25.4426 36.7154 25.0912 36.364L19.3636 30.6364ZM40 30.9L20 30.9L20 29.1L40 29.1L40 30.9Z" fill="#2D2330"/>
                    </svg>
                </div>
                <div class="pxl-swiper-arrow pxl-swiper-arrow-next slick-next">
                    <svg xmlns="http://www.w3.org/2000/svg" width="60" height="60" viewBox="0 0 60 60" fill="none">
                        <path d="M40.6364 30.6364C40.9879 30.2849 40.9879 29.7151 40.6364 29.3636L34.9088 23.636C34.5574 23.2846 33.9875 23.2846 33.636 23.636C33.2846 23.9875 33.2846 24.5574 33.636 24.9088L38.7272 30L33.636 35.0912C33.2846 35.4426 33.2846 36.0125 33.636 36.364C33.9875 36.7154 34.5574 36.7154 34.9088 36.364L40.6364 30.6364ZM20 30.9L40 30.9L40 29.1L20 29.1L20 30.9Z" fill="#2D2330"/>
                    </svg>
                </div>
            </div>
        </div>
        
        
    <?php endif; ?>


    <div class="pxl-item--holder">
        <?php konstruc()->blog->get_archive_meta(); ?>
        <h4 class="pxl-item--title">
            <a href="<?php echo esc_url( get_permalink()); ?>" title="<?php the_title_attribute(); ?>">
                <?php if(is_sticky()) { ?>
                    <i class="caseicon-check-mark pxl-mr-4"></i>
                <?php } ?>
                <?php the_title(); ?>
            </a>
        </h4>
        <div class="pxl-item--excerpt">
            <?php
            echo konstruc_html($description_post);
            wp_link_pages( array(
                'before'      => '<div class="page-links">',
                'after'       => '</div>',
                'link_before' => '<span>',
                'link_after'  => '</span>',
            ) );
            ?>
        </div>
        <div class="pxl-item--readmore">
            <a class="btn btn-arrow" href="<?php echo esc_url( get_permalink()); ?>">
                <span class="pxl--btn-text"><?php echo konstruc_html($archive_readmore_text); ?></span>
                <span class="pxl--btn-icon">
                    <svg xmlns="http://www.w3.org/2000/svg" width="45" height="45" viewBox="0 0 45 45" fill="none">
                        <path d="M25.3362 20.8403L18.1765 28L17 26.8235L24.1598 19.6638H17.8492V18H27V27.1508H25.3362V20.8403Z" fill="#FF792D"/>
                    </svg>
                </span>
            </a>
        </div>
    </div>
</article>