<?php

/**
 * Theme options / General / Posts
 *
 * @package vamtam/landscaping
 */

return array(

	array(
		'label'       => esc_html__( 'Pagination Type', 'vamtam-landscaping' ),
		'description' => esc_html__( 'Also used for portfolio', 'vamtam-landscaping' ),
		'id'          => 'pagination-type',
		'type'        => 'select',
		'choices'     => array(
			'paged'              => esc_html__( 'Paged', 'vamtam-landscaping' ),
			'load-more'          => esc_html__( 'Load more button', 'vamtam-landscaping' ),
			'infinite-scrolling' => esc_html__( 'Infinite scrolling', 'vamtam-landscaping' ),
		),
	),

	array(
		'label'       => esc_html__( 'Show "Related Posts" in Single Post View', 'vamtam-landscaping' ),
		'description' => esc_html__( 'Enabling this option will show more posts from the same category when viewing a single post.', 'vamtam-landscaping' ),
		'id'          => 'show-related-posts',
		'type'        => 'switch',
		'transport'   => 'postMessage',
	),

	array(
		'label'     => esc_html__( '"Related Posts" title', 'vamtam-landscaping' ),
		'id'        => 'related-posts-title',
		'type'      => 'text',
		'transport' => 'postMessage',
	),

	array(
		'label'     => esc_html__( 'Meta Information', 'vamtam-landscaping' ),
		'id'        => 'post-meta',
		'type'      => 'multicheck',
		'transport' => 'postMessage',
		'choices'   => array(
			'author'   => esc_html__( 'Post Author', 'vamtam-landscaping' ),
			'tax'      => esc_html__( 'Categories and Tags', 'vamtam-landscaping' ),
			'date'     => esc_html__( 'Timestamp', 'vamtam-landscaping' ),
			'comments' => esc_html__( 'Comment Count', 'vamtam-landscaping' ),
		),
	),

	array(
		'label'       => esc_html__( 'Show Featured Image on Single Posts', 'vamtam-landscaping' ),
		'id'          => 'show-single-post-image',
		'description' => esc_html__( 'Please note, that this option works only for Blog Post Format Image.', 'vamtam-landscaping' ),
		'type'        => 'switch',
		'transport'   => 'postMessage',
	),

	array(
		'label'       => esc_html__( 'Post Archive Layout', 'vamtam-landscaping' ),
		'description' => '',
		'id'          => 'archive-layout',
		'type'        => 'radio',
		'choices'     => array(
			'normal' => esc_html__( 'Large', 'vamtam-landscaping' ),
			'mosaic' => esc_html__( 'Small', 'vamtam-landscaping' ),
		),
	),

);
