<?php
/**
 * The template for displaying comments
 *
 * This is the template that displays the area of the page that contains both the current comments
 * and the comment form.
 *
 * @link https://developer.wordpress.org/themes/basics/template-hierarchy/
 *
 * @package larson
 */

/*
 * If the current post is protected by a password and
 * the visitor has not yet entered the password we will
 * return early without loading the comments.
 */
if ( post_password_required() ) {
	return;
}
?>

<div class="article__main container">
  <!-- Comments-->
  <?php
	// You can start editing here -- including this comment!
	if ( have_comments() ) :
  ?>
  <section id="comments" class="comment post-sb__comment">
    <div class="comment__title"><?php comments_number( esc_html__( 'No comments found', 'larson' ), esc_html__( '1 Comment', 'larson' ), esc_html__( '% Comments', 'larson' ) ); ?></div>

    <ul class="comments comment__wrapper">
		<?php
			wp_list_comments( array(
				'style'	  => 'ul',
				'avatar_size' => '80',
				'callback' => 'larson_comment'
			) );
		?>
	</ul><!-- .comment-list -->

	<?php
	the_comments_navigation( array(
		'screen_reader_text' => ' ',
		'prev_text' => esc_html__( 'Older comments', 'larson' ),
		'next_text' => esc_html__( 'Newer comments', 'larson' )
	) );

	// If comments are closed and there are comments, let's leave a little note, shall we?
	if ( ! comments_open() ) : ?>
		<p class="no-comments"><?php esc_html_e( 'Comments are closed.', 'larson' ); ?></p>
	<?php endif; ?>
  </section>
  <?php endif; // Check for have_comments(). ?>

  <div class="post-sb__comment-form comment-form">
		<?php
			$req = get_option( 'require_name_email' );
			$aria_req = ( $req ? " aria-required='true'" : '' );
		
			$comment_args = array(
				'title_reply' => esc_html__( 'Leave a comment', 'larson' ),
				'title_reply_to' => esc_html__( 'Leave a comment to %s', 'larson' ),
				'cancel_reply_link' => esc_html__( 'Cancel Reply', 'larson' ),
				'title_reply_before' => '<div class="comment-form__title">',
				'title_reply_after' => '</div>',
				'label_submit' => esc_html__( 'Submit', 'larson' ),
				'comment_field' => '<label class="field comment-form__field"><textarea class="textarea" rows="3" placeholder="' . esc_attr__( 'Comment', 'larson' ).'" id="comment" name="comment" aria-required="true" ></textarea></label>',
				'must_log_in' => '<p class="must-log-in">' . esc_html__( 'You must be ', 'larson' ) . '<a href="' . esc_url( wp_login_url( apply_filters( 'the_permalink', get_permalink( ) ) ) ) . '">' . esc_html__( 'logged in', 'larson' ) . '</a>' . esc_html__( ' to post a comment.', 'larson' ) . '</p>',
				'logged_in_as' => '<p class="logged-in-as">' . esc_html__( 'Logged in as ', 'larson' ) . '<a href="' . esc_url( admin_url( 'profile.php' ) ) . '">' . esc_html( $user_identity ) . '</a>' . esc_html__( '. ', 'larson' ) . '<a href="' . esc_url( wp_logout_url( apply_filters( 'the_permalink', get_permalink( ) ) ) ) . '" title="' . esc_attr__( 'Log out of this account', 'larson' ) . '">' . esc_html__( 'Log out?', 'larson' ) . '</a></p>',
				'comment_notes_before' => '',
				'comment_notes_after' => '',
				'fields' => apply_filters( 'comment_form_default_fields', array(
					'author' => '<div class="comment-form__inputs-group"><div class="comment-form__field-wrapper"><label class="field comment-form__field"><input id="author" name="author" type="text" placeholder="' . esc_attr__( 'Name', 'larson' ) . '" class="input" value="" ' . $aria_req . ' /></label></div>',
					'email' => '<div class="comment-form__field-wrapper"><label class="field comment-form__field"><input id="email" name="email" type="text" placeholder="' . esc_attr__( 'Email', 'larson' ) . '" class="input" value="" ' . $aria_req . ' /></label></div></div>',
				)),
				'class_submit' => 'btn comment-form__btn',
				'submit_field' => '%1$s %2$s',
				'submit_button' => '<button type="submit" name="%1$s" id="%2$s" class="%3$s">%4$s</button>'
			);

			comment_form( $comment_args );
		?>
  </div>
</div>