<?php
/**
 * The header for our theme
 *
 * This is the template that displays all of the <head> section and everything up until <div id="content">
 *
 * @link https://developer.wordpress.org/themes/basics/template-files/#template-partials
 *
 * @package larson
 */

?>
<!doctype html>
<html <?php language_attributes(); ?>>
<head>
	<!-- Meta Data -->
	<meta charset="<?php bloginfo( 'charset' ); ?>">
	<meta http-equiv="X-UA-Compatible" content="IE=edge">
	<meta name="viewport" content="width=device-width, initial-scale=1">

	<link rel="profile" href="https://gmpg.org/xfn/11">

	<?php wp_head(); ?>
</head>

<?php

$disable_preloader = '';
if ( get_field( 'disable_preloader', 'option' ) ) {
  $disable_preloader = 'disable_preloader';
}

?>

<body <?php body_class( $disable_preloader ); ?>>
	<?php wp_body_open(); ?>

  <?php
    $header_layout = get_field( 'header_layout', 'option' );
    $page_template = get_page_template_slug();
    $disable_preloader = get_field( 'disable_preloader', 'option' );
    $parallax_type = get_field( 'parallax_type' );
    $coming_soon = false;
    if ( $page_template == 'template-elementor-coming-soon.php' ) {
      $coming_soon = true;
    }
    if ( ! $coming_soon ) :
  ?>

  <?php get_template_part( 'template-elements/header', 'icons' ); ?>

	<div class="preloader">
		<div class="preloader__spinner">
			<span class="preloader__double-bounce"></span>
			<span class="preloader__double-bounce preloader__double-bounce--delay"></span>
		</div>
	</div>

  <div class="container-page<?php if ( $parallax_type == 'templates' ) : ?> container-page-parallax<?php endif; ?>">
    <?php
      if ( ! $header_layout ) :
        get_template_part( 'template-elements/header', 'default' );
      else :
        get_template_part( 'template-elements/header', 'builder' );
    endif; ?>

    <?php get_template_part( 'template-elements/header', 'mobile-canvas' ); ?>

    <main>
  <?php endif; ?>
