<?php
/**
 * Skin
**/

if ( ! function_exists( 'larson_skin' ) ) {
function larson_skin() {
	$theme_ui = get_field( 'theme_ui', 'option' );
	$base_bg_color = get_field( 'base_bg_color', 'options' );
	$text_color = get_field( 'text_color', 'options' );
	$theme_color = get_field( 'theme_color', 'options' );
	$base_font_size = get_field( 'base_font_size', 'options' );
	$heading_font_size = get_field( 'heading_font_size', 'options' );
	$post_heading_font_size = get_field( 'post_heading_font_size', 'options' );

	$text_font_family = get_field( 'text_font_family', 'options' );
	$primary_font_family = get_field( 'primary_font_family', 'options' );

	$preloader_color = get_field( 'preloader_color', 'options' );

	if ( $theme_ui ) {
		$base_bg_color = get_field( 'base_bg_color_light', 'options' );
		$text_color = get_field( 'text_color_light', 'options' );
	}
?>

<style>
	<?php if ( $base_bg_color ) : ?>
	/* Base BG Color */
	html,
	body,
	main,
	.label-subs>button[type="submit"],
	.custom-input,
	.arrow-square,
	#pp-nav ul li a span,
	.preloader,
	.webpage,
	.mobile-canvas,
	.header,
	.header--fixed,
	.card--news:hover .card__content,
	.card--news:focus .card__content,
	.card--news .card__content,
	.preview-card__content,
	.post-related,
	.post-related__item .card__content,
	.comment .comment-item__reply a,
	.comment-form input[type="text"],
	.comment-form input[type="number"],
	.comment-form input[type="tel"],
	.comment-form input[type="email"],
	.comment-form input[type="phone"],
	.comment-form input[type="address"],
	.comment-form input[type="password"],
	.comment-form textarea,
	.contact-block,
	.video-section,
	.content-sidebar .search-form input[type="search"],
	.wp-block-search input[type="search"],
	.widget_product_search input[type="search"],
	.wp-block-search input[type="search"],
	.main-slider .swiper-custom-pagination ul li {
		background-color: <?php echo esc_attr( $base_bg_color ); ?>;
	}
	@media (min-width: 768px) {
		.service-card__detail {
			background-color: <?php echo esc_attr( $base_bg_color ); ?>;
		}
	}
	@media (min-width: 992px) {
		.navigation__dropdown {
			background-color: <?php echo esc_attr( $base_bg_color ); ?>;
		}
		.card--news:hover .card__content,
		.card--news:focus .card__content {
			background-color: <?php echo esc_attr( $base_bg_color ); ?>;
		}
	}
	.header--bg,
	.footer--bg,
	.main-slider .tp-tabs {
		background-color: <?php echo esc_attr( $base_bg_color ); ?> !important;
	}
	.header--white {
		background-color: transparent;
	}
	<?php endif; ?>

	<?php if ( $text_color ) : ?>
	/* Paragraphs Color */
	body,
	.field input[type="text"],
	.field input[type="number"],
	.field input[type="tel"],
	.field input[type="email"],
	.field input[type="phone"],
	.field input[type="address"],
	.field input[type="password"],
	.field textarea,
	.field input::placeholder,
	.field textarea::placeholder,
	.mobile-canvas__copy,
	.mobile-canvas__link,
	.slide-tab__number,
	.slide-tab__title,
	.services-section__link,
	.services__item-text,
	.contact-block__address,
	.contact-block__item,
	.contact-block__item-val a,
	.about-block__text,
	.main-slider .swiper-custom-pagination ul li .num,
	.main-slider .swiper-custom-pagination ul li .label,
	.services__item-text {
		color: <?php echo esc_attr( $text_color ); ?>;
	}
	.post-related__title a svg,
	.services-provided__icon .e-font-icon-svg {
		fill: <?php echo esc_attr( $text_color ); ?>;
	}
	<?php endif; ?>

	<?php if ( $theme_color ) : ?>
	/* Theme Color */
	html ::-webkit-scrollbar-thumb {
		background: <?php echo esc_attr( $theme_color ); ?>;
	}
	a:hover,
	a:focus,
	.color-yellow,
	.btn--outline,
	.heading-small,
	.navigation__dropdown li a:hover,
	.navigation__dropdown li a:focus,
	.navigation__item--current .navigation__link,
	.navigation__link:hover,
	.navigation__link:focus,
	.filter__item:hover,
	.filter__item:focus,
	.filter__item--active,
	.webpage--parallax-dark .footer .lang-switcher__link--current,
	.lang-switcher__link--current,
	.lang-switcher__link:hover,
	.lang-switcher__link:focus,
	.header--white .navigation__link:hover,
	.header--white .navigation__link:focus,
	.header--fixed .navigation__link:hover,
	.header--fixed .navigation__link:focus,
	.footer--white .lang-switcher__link--current,
	.footer--white .lang-switcher__link:focus,
	.footer__column-menu li a:hover,
	.footer__column-item--current .footer__column-link,
	.footer__column-link:hover,
	.footer__column-link:focus,
	.page-404__text a,
	.card--send:focus .card__send-text,
	.card--news-masonry:hover .card__link,
	.card--news-masonry:focus .card__link,
	.review-card__post span,
	.statistics__item-value,
	.services-provided__link:focus,
	.post-sb-page__main-pic--inner .post-sb-page__heading span,
	.post-sb__social .social__link:hover,
	.service-card__link,
	.contact-block__item-val a:focus,
	.video-section .lang-switcher__link--current,
	.main-slider .container .title b,
	.article__tag,
	.article__header .post-sb-page__tag a,
	.welcome__title span span,
	.contact-parallax__form-title span span,
	.archive-item .btn-link:hover,
	.is-style-outline .wp-block-button__link,
	.post-password-form input[type="submit"],
	.wp-block-calendar a,
	.services-provided__link:hover,
	.services-provided__link:focus,
	.services__title span span,
	.services__digit,
	.services__link,
	.card--news .card__link {
		color: <?php echo esc_attr( $theme_color ); ?>;
	}
	.navigation__dropdown .current-menu-itemnavigation__item a,
	.header--white .navigation__item--current .header--white .navigation__link,
	.header--fixed .navigation__item--current .navigation__link,
	.main-slider .tp-tab.selected .slide-tab__number {
		color: <?php echo esc_attr( $theme_color ); ?> !important;
	}
	.swiper-pagination-bullet-active,
	.btn,
	.btn--outline:hover,
	.btn--outline:focus,
	.logo::after,
	.play-btn,
	.preloader__double-bounce,
	.welcome__line,
	.contact-parallax__form .line,
	.latest-projects__carousel .swiper-pagination-bullet.swiper-pagination-bullet-active,
	.reviews-carousel .swiper-pagination-bullet.swiper-pagination-bullet-active,
	.pager a:hover,
	.page-links .post-page-numbers:hover,
	.archive-item .btn-link:hover:before,
	.wp-block-button__link,
	.bline .bline-1:before,
	.bline .bline-2:before,
	.bline .bline-3:before,
	.card:hover .card__content,
	.card:focus .card__content,
	.card--active .card__content,
	.pager .current,
	.page-links .current,
	.btn:hover, .btn:focus,
	.play-btn:hover, .play-btn:focus,
	#pp-nav ul li a.active span,
	#pp-nav ul li:hover a span,
	.webpage--parallax-dark #pp-nav ul li a.active span {
		background-color: <?php echo esc_attr( $theme_color ); ?>;
	}
	.btn,
	.btn--outline,
	.logo::before,
	.card--team:focus .card__content,
	.card--send:focus,
	.card--transparent:focus,
	.card--active,
	.card--news-masonry:hover .card__content,
	.card--news-masonry:focus .card__content,
	.review-card,
	.about-section__cite::before,
	.parallax__project::before,
	.pager a:hover,
	.page-links .post-page-numbers:hover,
	.wp-block-button__link,
	.is-style-outline .wp-block-button__link,
	.post-password-form input[type="submit"] {
		border-color: <?php echo esc_attr( $theme_color ); ?>;
	}
	.menu-toggle:hover::before,
	.menu-toggle:hover::after,
	.menu-toggle:focus::before,
	.menu-toggle:focus::after,
	.header--white .menu-toggle:hover::before,
	.header--white .menu-toggle:hover::after,
	.header--white .menu-toggle:focus::before,
	.header--white .menu-toggle:focus::after,
	.process__heading::before,
	.services-provided__heading::before,
	.architects__heading::before,
	.about-block__heading::before {
		border-top-color: <?php echo esc_attr( $theme_color ); ?>;
	}
	.mobile-canvas__close:hover svg,
	.mobile-canvas__close:focus svg,
	.card--news-masonry:hover .card__link svg,
	.card--news-masonry:focus .card__link svg,
	.projects-carousel__next:hover,
	.projects-carousel__next:focus,
	.projects-carousel__prev:hover,
	.projects-carousel__prev:focus,
	.projects-slider__next:hover,
	.projects-slider__next:focus,
	.projects-slider__prev:hover,
	.projects-slider__prev:focus,
	.services-provided__link:focus svg,
	.service-card__link svg,
	.services__link svg,
	.review-card .sep svg path,
	.hero__heading .sep svg path,
	.about-section__blockquote .sep svg path,
	.about-block__quote .sep svg path,
	.project-designer__content .sep svg path,
	.card--news .card__link svg,
	.social--white .social__link:hover .e-font-icon-svg {
		fill: <?php echo esc_attr( $theme_color ); ?>;
	}
	@media (min-width: 992px) {
		.social__link:hover,
		.social__link:focus,
		.mobile-canvas__phone:hover,
		.mobile-canvas__phone:focus,
		.header--white .social__link:hover,
		.header--white .header__phone:hover,
		.header--white .social__link:hover,
		.header--white .social__link:focus,
		.header--white .header__phone:hover,
		.header--white .header__phone:focus,
		.header--fixed .social__link:hover,
		.header--fixed .header__phone:hover,
		.header--fixed .social__link:hover,
		.header--fixed .social__link:focus,
		.header--fixed .header__phone:hover,
		.header--fixed .header__phone:focus,
		.header__phone:hover,
		.header__phone:focus,
		.footer--white .lang-switcher__link:hover,
		.footer--white .lang-switcher__link:focus,
		.link-arrow:hover,
		.link-arrow:focus,
		.card--send:hover .card__send-text,
		.card--send:focus .card__send-text,
		.preview-card__btn:hover,
		.preview-card__btn:focus,
		.post-related__title a:hover,
		.post-related__title a:focus,
		.contact-block__phone a:hover,
		.contact-block__phone a:focus,
		.contact-block__item-val a:hover,
		.contact-block__item-val a:focus,
		.parallax__link:hover,
		.parallax__link:focus,
		.contact-parallax__phone:hover,
		.contact-parallax__phone:focus,
		.contact-parallax__email:hover,
		.contact-parallax__email:focus,
		.services-provided__link:hover,
		.services-provided__link:focus,
		.social--contact .social__link:hover .fa, 
		.social--contact .social__link:hover .fas, 
		.social--contact .social__link:hover .fab, 
		.social--contact .social__link:hover .far,
		.webpage--parallax-dark .header--white .navigation__list>li>.navigation__link:hover,
		.webpage--parallax-dark .header .social__link:hover,
		.webpage--parallax-dark .footer .lang-switcher__link:hover {
			color: <?php echo esc_attr( $theme_color ); ?>;
		}
		.link-arrow:hover svg,
		.link-arrow:focus svg,
		.preview-card__btn:hover svg,
		.preview-card__btn:focus svg,
		.services-provided__link:hover svg,
		.services-provided__link:focus svg,
		.post-related__title a:hover svg,
		.post-related__title a:focus svg,
		.parallax__link:hover svg,
		.parallax__link:focus svg,
		.slider-parallax__nav-btn:hover svg,
		.slider-parallax__nav-btn:focus svg {
			fill: <?php echo esc_attr( $theme_color ); ?>;
		}
		.social__link:hover svg path, 
		.social__link:focus svg path, 
		.header--white .social__link:hover svg path, 
		.header--white .social__link:focus svg path {
			fill: <?php echo esc_attr( $theme_color ); ?> !important;
		}
		.slide-tab:hover .slide-tab__number,
		.slide-tab:hover .slide-tab__title,
		.slide-tab:focus .slide-tab__number,
		.slide-tab:focus .slide-tab__title,
		.quote::before,
		blockquote::before,
		.main-slider .swiper-custom-pagination ul li.pag-active span {
			color: <?php echo esc_attr( $theme_color ); ?> !important;
		}
		.card--team:hover .card__content,
		.card--team:focus .card__content,
		.card--send:hover,
		.card--send:focus,
		.card--transparent:hover,
		.card--transparent:focus,
		.card--news .card__content,
		.preview-card__content,
		.hero__heading::before,
		.comment .comment-item__reply a:hover,
		.comment .comment-item__reply a:focus,
		.quote,
		blockquote,
		.service-card--reverse .service-card__detail:hover,
		.service-card--reverse .service-card__detail:focus,
		.service-card__detail:hover,
		.service-card__detail:focus {
			border-color: <?php echo esc_attr( $theme_color ); ?>;
		}
		.service-card--reverse .service-card__left::before {
			border-right-color: <?php echo esc_attr( $theme_color ); ?>;
		}
		.comment .comment-item__reply a:hover,
		.comment .comment-item__reply a:focus {
			background-color: <?php echo esc_attr( $theme_color ); ?>;
		}
		.service-card__left::before {
			border-top-color: <?php echo esc_attr( $theme_color ); ?>;
		}
		.service-card__left::before {
			border-left-color: <?php echo esc_attr( $theme_color ); ?>;
		}
		.tags-links a:hover,
		.col__sedebar .tagcloud a:hover,
		.wp-block-tag-cloud a:hover {
			background-color: <?php echo esc_attr( $theme_color ); ?>;
		}
	}
	<?php endif; ?>

	<?php if ( $base_font_size ) : ?>
	/* Base font size */
	html,
	body,
	a.btn,
	.btn,
	a.btn-link,
	.btn-link,
	button,
	input[type="submit"],
	input[type="text"],
	input[type="email"],
	input[type="search"],
	input[type="password"],
	input[type="tel"],
	input[type="address"],
	input[type="number"],
	textarea,
	label,
	legend,
	.menu-social-links a i,
	a.page-numbers,
	.page-numbers,
	.post-page-numbers,
	.comments-post .m-title small,
	.comment-reply-link,
	.share-post .share-btn {
		font-size: <?php echo esc_attr( $base_font_size ); ?>px;
	}
	<?php endif; ?>

	<?php if ( $heading_font_size ) : ?>
	/* Heading font size */
	@media (min-width: 1200px) {
		.heading {
			font-size: <?php echo esc_attr( $heading_font_size ); ?>px;
		}
	}
	<?php endif; ?>

	<?php if ( $post_heading_font_size ) : ?>
	/* Post heading font size */
	@media (min-width: 1200px) {
		.heading.article__heading.heading--size-large {
			font-size: <?php echo esc_attr( $post_heading_font_size ); ?>px;
		}
	}
	<?php endif; ?>

	<?php if ( $text_font_family ) : ?>
	/* Paragraphs Font */
	body,
	.field input[type="text"],
	.field input[type="number"],
	.field input[type="tel"],
	.field input[type="email"],
	.field input[type="phone"],
	.field input[type="address"],
	.field input[type="password"],
	.field textarea,
	.filter__item,
	.comment-form input[type="text"],
	.comment-form input[type="number"],
	.comment-form input[type="tel"],
	.comment-form input[type="email"],
	.comment-form input[type="phone"],
	.comment-form input[type="address"],
	.comment-form input[type="password"],
	.comment-form textarea,
	.comment-form__btn,
	.quote::before,
	blockquote::before,
	.article--news .article__filter .filter__item,
	.contact-parallax__submit {
		font-family: '<?php echo esc_attr( $text_font_family['font_name'] ); ?>', serif;
	}
	<?php endif; ?>

	<?php if ( $primary_font_family ) : ?>
	/* Primary Font */
	.heading,
	.logo__large,
	.more,
	.timer__digit p,
	.page-404__num,
	.page-404__title,
	.coming-soon__title,
	.coming-soon__timer-title,
	.slide-tab__number,
	.card__send-text,
	.card__heading,
	.review-card__name,
	.preview-card__heading,
	.about-section__blockquote,
	.reviews-carousel__title,
	.project-meta__item-title,
	.project-designer__title,
	.steps__item::before,
	.steps__item-title,
	.services-provided__column-heading,
	.services__left p,
	.services__digit,
	.services__title,
	.services__item-title,
	.post-sb-page__main-pic--inner .post-sb-page__heading,
	.post-sb__title,
	.post-sb__subtitle,
	.post-sb__text h1,
	.post-sb__text h2,
	.post-sb__text h3,
	.post-sb__text h4,
	.post-sb__text h5,
	.post-sb__text h6,
	.comment-item__text h1,
	.comment-item__text h2,
	.comment-item__text h3,
	.comment-item__text h4,
	.comment-item__text h5,
	.comment-item__text h6,
	.post-related__title span,
	.post-related__title a,
	.comment__title,
	.comment-form__title,
	.quote p,
	blockquote p,
	.post-sb__text blockquote p,
	.post-sb__text blockquote p,
	.comment-item__text blockquote p,
	.comment-item__text blockquote p,
	.service-card__left::after,
	.service-card__heading,
	.single-service-block h2,
	.contact-block__heading,
	.contact-block__phone a,
	.about-block__inner::before,
	.main-slider .swiper-custom-pagination ul li .num,
	.main-slider .swiper-custom-nav .prev,
	.main-slider .swiper-custom-nav .next,
	.main-slider .tparrows::before,
	.welcome__title,
	.parallax__title,
	.parallax__counter,
	.services__left p,
	.services__digit,
	.services__title,
	.services__item-title,
	.slider-parallax__title,
	.contact-parallax__title,
	.contact-parallax__address,
	.contact-parallax__phone,
	.contact-parallax__form-title,
	.page-navigation a,
	.content-sidebar .widget .widget-title,
	.tags-links a,
	.col__sedebar .tagcloud a,
	.wp-block-tag-cloud a,
	.sidebar__tag-item,
	.post-sb__tags a,
	.archive-item .title,
	.contact-block__heading span {
		font-family: '<?php echo esc_attr( $primary_font_family['font_name'] ); ?>', serif;
	}
	<?php endif; ?>

	<?php if ( $preloader_color ) : ?>
	/* preloader color */
	.preloader__double-bounce {
		background: <?php echo esc_attr( $preloader_color ); ?>;
	}
	<?php endif; ?>

</style>

<?php
}
}
add_action( 'wp_head', 'larson_skin', 10 );
