<?php
/**
 * Custom template tags for this theme
 *
 * Eventually, some of the functionality here could be replaced by core features.
 *
 * @package larson
 */

if ( ! function_exists( 'larson_post_details' ) ) :
	/**
	 * Displays post details: date, author, categories.
	 */
	function larson_post_details() {
		if ( is_singular() ) :
			echo '<a href="' . esc_url( get_author_posts_url( get_the_author_meta( 'ID' ) ) ) . '">' . esc_html( get_the_author() ) . '</a>' . esc_html__( ' on ', 'larson' ) . esc_html( get_the_date() );

		endif; // End is_singular().
	}
endif;

if ( ! function_exists( 'larson_post_categories' ) ) :
	/**
	 * Displays post details: date, author, categories.
	 */
	function larson_post_categories() {
		if ( is_singular() ) :
			$categories_list = get_the_category_list( esc_html__( ', ', 'larson' ) );
			
			if ( $categories_list ) :
				echo '<span class="post-sb-page__tag">' . wp_kses_post( $categories_list ) . '</span>';
			endif;
		endif; // End is_singular().
	}
endif;

if ( ! function_exists( 'larson_post_navigation' ) ) :
	/**
	 * Displays an optional next link.
	 */
	function larson_post_navigation() {
		if ( is_singular() ) :

			$prev_post = get_adjacent_post( false, '', true );
			$next_post = get_adjacent_post( false, '', false );
			
			?>

			<!-- Section Navigation -->
			<div class="page-navigation">
				<?php if ( is_a( $prev_post, 'WP_Post' ) ) : ?>
				<a href="<?php echo esc_url( get_permalink( $prev_post->ID ) ); ?>" class="page-navigation__prev">
					<span class="page-navigation__arrow">
						<?php echo esc_html__( 'Prev Article: ', 'larson' ); ?>
					</span>
					<span class="page-navigation__title">
						<?php echo wp_kses_post( get_the_title( $prev_post->ID ) ); ?>
					</span>
				</a>
				<?php endif; ?>
				<?php if ( is_a( $next_post, 'WP_Post' ) ) : ?>
				<a href="<?php echo esc_url( get_permalink( $next_post->ID ) ); ?>" class="page-navigation__next">
					<span class="page-navigation__arrow">
						<?php echo esc_html__( 'Next Article: ', 'larson' ); ?>
					</span>
					<span class="page-navigation__title">
						<?php echo wp_kses_post( get_the_title( $next_post->ID ) ); ?>
					</span>
				</a>
				<?php endif; ?>
			</div>

		<?php
		endif; // End is_singular().
	}
endif;

if ( ! function_exists( 'larson_post_tags' ) ) :
	/**
	 * Prints HTML with meta information for the categories, tags and comments.
	 */
	function larson_post_tags() {
		// Hide category and tag text for pages.
		if ( 'post' === get_post_type() ) {
			/* translators: used between list items, there is a space after the comma */
			$tags_list = get_the_tag_list( '', esc_html_x( ', ', 'list item separator', 'larson' ) );
			if ( $tags_list ) {
				/* translators: 1: list of tags. */
				echo '<div class="post-sb__tags">' . '<span>' . esc_html__( 'Tags: ', 'larson' ) . '</span>' . $tags_list . '</div>';
			}
		}
	}
endif;

if ( ! function_exists( 'larson_post_edit' ) ) :
	/**
	 * Prints HTML with meta information for the categories, tags and comments.
	 */
	function larson_post_edit() {
		edit_post_link(
			sprintf(
				wp_kses(
					/* translators: %s: Name of current post. Only visible to screen readers */
					__( 'Edit <span class="screen-reader-text">%s</span>', 'larson' ),
					array(
						'span' => array(
							'class' => array(),
						),
					)
				),
				get_the_title()
			),
			'<span class="edit-link">',
			'</span>'
		);
	}
endif;


if ( ! function_exists( 'larson_post_social' ) ) :
	/**
	 * Prints HTML with meta information for the categories, tags and comments.
	 */
	function larson_post_social() {
		$social_share = get_field( 'social_share', 'options' );

		// Hide category and tag text for pages.
		if ( 'post' == get_post_type() && $social_share ) { ?>

			<div class="post-sb__socials social-share">
              <span><?php echo esc_html__( 'Share:', 'larson' ); ?></span>
              <ul class="social post-sb__social">
                <?php foreach ( $social_share as $social ) : ?>
                <li class="social__item">
					<a class="social__link share-btn share-btn-<?php echo esc_attr( $social['value'] ); ?>">
						<?php if ( $social['value'] == 'facebook' ) : ?>
						<i class="fa fa-facebook-f"></i>
						<?php endif; ?>
						<?php if ( $social['value'] == 'twitter' ) : ?>
						<i class="fa fa-twitter"></i>
						<?php endif; ?>
						<?php if ( $social['value'] == 'tumblr' ) : ?>
						<i class="fa fa-tumblr"></i>
						<?php endif; ?>
						<?php if ( $social['value'] == 'linkedin' ) : ?>
						<i class="fa fa-linkedin"></i>
						<?php endif; ?>
						<?php if ( $social['value'] == 'reddit' ) : ?>
						<i class="fa fa-reddit-alien" aria-hidden="true"></i>
						<?php endif; ?>
						<?php if ( $social['value'] == 'pinterest' ) : ?>
						<i class="fa fa-pinterest-p"></i>
						<?php endif; ?>
						<?php if ( $social['value'] == 'whatsapp' ) : ?>
						<i class="fa fa-whatsapp"></i>
						<?php endif; ?>
					</a>
				</li>
				<?php endforeach; ?>
              </ul>
            </div>

		<?php }
	}
endif;

if ( ! function_exists( 'larson_comment' ) ) {
	/**
	 * Displays post comments.
	 */
	function larson_comment( $comment, $args, $depth ) {
		?>
			<!-- Item Comment -->
			<li <?php comment_class( 'comment-item' ); ?> id="li-comment-<?php comment_ID(); ?>">
				<div id="comment-<?php comment_ID(); ?>" class="comment">
					<div class="comment-item__photo">
						<?php
							$avatar_size = 64;
							if ( '0' != $comment->comment_parent ){
								$avatar_size = 64;
							}
							echo get_avatar( $comment, $avatar_size );
						?>
					</div>
					<div class="comment-item__content">
						<div class="comment-item__top">
				            <div class="comment-item__name"><?php comment_author_link(); ?></div>
				            <div class="comment-item__sent"><?php comment_date(); ?></div>
				        </div>
						<div class="comment-item__text">
							<?php comment_text(); ?>
						</div>
			          	<div class="comment-item__reply">
			          		<?php comment_reply_link( array_merge( $args, array( 'depth' => $depth, 'max_depth' => $args['max_depth'] ) ) ); ?>
			          	</div>
					</div>
				</div>
		<?php
	}
}