<?php
/**
 * The main template file
 *
 * This is the most generic template file in a WordPress theme
 * and one of the two required files for a theme (the other being style.css).
 * It is used to display a page when nothing more specific matches a query.
 * E.g., it puts together the home page when no home.php file exists.
 *
 * @link https://developer.wordpress.org/themes/basics/template-hierarchy/
 *
 * @package larson
 */

get_header();
?>

	<?php

	/*get options*/
	$blog_title = get_field( 'blog_title', 'option' );
	
	if( empty($blog_subtitle) ) {
		$blog_subtitle = esc_html__( 'Latest Posts', 'larson' );
	}

	?>

	<article class="article">
        <header class="article__header">
          <div class="container">
            <h1 class="article__heading heading heading--size-large"><?php echo wp_kses_post( $blog_subtitle ); ?></h1>
          </div>
        </header>
    </article>

    <?php get_template_part( 'template-parts/archive-list' ); ?>
    
<?php
get_footer();