<?php
/**
 * The template for displaying all pages
 *
 * This is the template that displays all pages by default.
 * Please note that this is the WordPress construct of pages
 * and that other 'pages' on your WordPress site may use a
 * different template.
 *
 * @link https://developer.wordpress.org/themes/basics/template-hierarchy/
 *
 * @package larson
 */

get_header();
?>
	
	<?php while ( have_posts() ) : the_post(); ?>

	<article class="article article--news">
		<header class="article__header">
          <div class="container">
            <h1 class="article__heading heading heading--size-large"><?php the_title(); ?></h1>
          </div>
        </header>
		<div class="post-sb-page__wrapper">
		  <!-- Post-->
		  <section class="post-sb post-sb--full">
		    <div class="article__main article__main--width-small container">
		      <div class="post-sb__wrapper">
		        <div class="post-sb__content">
		          <div class="post-sb__date">
		          	<!-- Details -->
		            <?php larson_post_details(); ?>
		          </div>

		          <div class="post-sb__text">
		          	<!-- Content -->
					<?php get_template_part( 'template-parts/content', 'page' ); ?>
		          </div>

		          <div class="post-sb__bottom">
					<!-- Post nav -->
						<?php 
						
						wp_link_pages( array(
							'before' => '<div class="page-links">' . esc_html__( 'Pages:', 'larson' ),
							'after'  => '</div>',
						) );

						?>
		          </div>
		        </div>
		      </div>
		    </div>

		    <?php if ( comments_open() || get_comments_number() ) :
				comments_template();
			endif; ?>

		  </section>
		</div>
	</article>

	<?php endwhile; ?>

<?php
get_footer();
