<?php
/**
 * The template for displaying search results pages
 *
 * @link https://developer.wordpress.org/themes/basics/template-hierarchy/#search-result
 *
 * @package larson
 */

get_header();
?>
	
	<article class="article">
        <header class="article__header">
          <div class="container">
            <h1 class="article__heading heading heading--size-large"><?php printf( esc_html__( 'Search: %s', 'larson' ), get_search_query() ); ?></h1>
          </div>
        </header>
    </article>

	<div class="article__main container">
		<!-- row -->
	    <div class="row archive-row">
	        <?php if ( is_active_sidebar( 'sidebar-1' ) ) : ?>
	        <div class="col-lg-9">
	        <?php else : ?>
	        <div class="col-lg-12">
	        <?php endif; ?>
	        
	            <?php if ( have_posts() ) : ?>        
	            <?php
	            /* Start the Loop */
	            while ( have_posts() ) : the_post(); ?>

	                <?php
	                /*
	                 * Include the Post-Type-specific template for the content.
	                 * If you want to override this in a child theme, then include a file
	                 * called content-___.php (where ___ is the Post Type name) and that will be used instead.
	                 */
	                get_template_part( 'template-parts/content', 'search' );
	                ?>
	            
	            <?php endwhile; ?>
	            
	            <?php if ( get_the_posts_pagination() ) : ?>
	            <div class="pager">
	                <?php
	                    echo paginate_links( array(
	                        'prev_text'     => esc_html__( 'Prev', 'larson' ),
	                        'next_text'     => esc_html__( 'Next', 'larson' ),
	                    ) );
	                ?>
	            </div>
	            <?php endif; ?>
	            
	            <?php else : ?>
	                <?php get_template_part( 'template-parts/content', 'none' ); ?>
	            <?php endif; ?>   
	        </div>
	        <?php if ( is_active_sidebar( 'sidebar-1' ) ) : ?>
	        <div class="col-lg-3">
	            <div class="col__sedebar">
	                <?php get_sidebar(); ?>
	            </div>
	        </div>
	        <?php endif; ?>
	    </div>
	    <!-- row end -->
	</div>

<?php
get_footer();