<?php
/**
 * Template Name: Elementor Template (Parallax)
 * Template Post Type: page
 *
 * @package larson
*/

get_header(); 
?>

<?php

while ( have_posts() ) : the_post(); 

$parallax_type = get_field( 'parallax_type' );
$loop = get_field( 'loop' );

if ( $parallax_type == 'widget' ) : 

?>
<div id="post-<?php the_ID(); ?>" <?php post_class(); ?>>
	<?php the_content(); ?>
</div><!-- #post-<?php the_ID(); ?> -->

<?php else : ?>
<?php

$parallax_builder = get_field( 'parallax_builder' );

?>
<?php if ( $parallax_builder ) : ?>
<div class="homepage-parallax" id="pagepiling" <?php if ( $loop == 1 ) : ?>data-loop="true"<?php endif; ?>>
    <?php foreach ( $parallax_builder as $section ) : ?>
    <!-- Section -->
    <section class="section parallax pp-scrollable<?php if ( $section['dark'] ) : ?> __js_bg dark<?php endif; ?><?php if ( $section['slider'] ) : ?> parallax--slider<?php endif; ?>"<?php if ( $section['bg'] ) : ?> style="background-image: url(<?php echo esc_url( get_the_post_thumbnail_url( $section['template'], 'larson_1920xAuto' ) ); ?>);"<?php else : ?> style="background-color: #fff;"<?php endif; ?>>
      <div class="scroll-wrap">
        <div class="<?php if ( $section['container'] ) : ?>container <?php endif; ?>parallax__container">
          <div class="parallax__type">
			<?php echo esc_html( $section['label'] ); ?>
		  </div>

          <?php 
          	$args = array( 'post_type' => 'pl_templates', 'p' => $section['template'] ); 

          	$loop = new WP_Query( $args );
			    while ( $loop->have_posts() ) : $loop->the_post();
			        the_content();
			    endwhile; wp_reset_postdata();
          ?>
        </div>
      </div>
    </section>
	<?php endforeach; ?>
</div>
<?php endif; ?>

<?php
endif;

endwhile; 

?>
	
<?php
get_footer();