<?php
/**
 * Default template for header
 *
 * @package larson
 */

?>

<?php

$transparent_header = get_field( 'transparent_header' );

?>

<header class="header<?php if ( $transparent_header ) : ?> header--white<?php endif; ?> __js_fixed-header" id="header">
  <div class="header__inner">
    <!-- Logo-->
    <a href="<?php echo esc_url( home_url() ); ?>" class="header__logo logo" title="<?php echo esc_attr( bloginfo('name') ); ?>">
      <span class="logo__large"><?php echo esc_html( bloginfo('name') ); ?></span>
      <span class="logo__small"><?php echo esc_html( bloginfo('description') ); ?></span>
    </a>
    <div class="container">
    	<!-- Site menu-->
		<div class="mobile-canvas __js_mobile-canvas header__mobile">
		  <nav class="mobile-canvas__nav navigation">
		  	<?php
			if ( has_nav_menu( 'primary' ) ) :
				wp_nav_menu( array(
					'theme_location' => 'primary',
					'container' => '',
					'menu_class' => 'navigation__list',
					'walker' => new Larson_TopmenuHorizontal_Walker(),
				) );
			endif; ?>
		  </nav>
		</div>
    </div>
    <!-- Burger-->
    <button class="header__menu-toggle menu-toggle" type="button">
      <span class="visually-hidden"><?php echo esc_html__( 'Menu', 'larson' ); ?></span>
    </button>
  </div>
</header>