<?php
/**
 * Template part for displaying posts
 *
 * @link https://developer.wordpress.org/themes/basics/template-hierarchy/
 *
 * @package larson
 */

?>

<?php

$container = get_query_var( 'container' );
$layout = get_query_var( 'layout' );

/* post content */
$current_categories = get_the_terms( get_the_ID(), 'portfolio_categories' );
$categories_slugs_string = '';
if ( $current_categories && ! is_wp_error( $current_categories ) ) {
	foreach ( $current_categories as $key => $value ) {
		$categories_slugs_string .= '__js_' . $value->slug . ' ';
	}
}

$image = get_the_post_thumbnail_url( get_the_ID(), 'larson_900x900' );
$title = get_the_title();
$size = false;

$col_class = 'col-12 col-md-6 col-xl-4';

if ( $container == 'fullwidth' ) {
	$col_class = 'col-12 col-md-6 col-xl-3';
}
if ( $layout == 'masonry' ) {
	$size = get_field( 'size' );

	if ( $size == 1 ) {
		$image = get_the_post_thumbnail_url( get_the_ID(), 'larson_900xAuto' );
	}
	if ( $size == 2 ) {
		$image = get_the_post_thumbnail_url( get_the_ID(), 'larson_900xAuto' );
		$col_class = 'col-12 col-xl-8';

		if ( $container == 'fullwidth' ) {
			$col_class = 'col-12 col-xl-6';
		}
	}
}

$full_image = get_the_post_thumbnail_url( get_the_ID(), 'larson_1920xAuto' );

?>

<li class="gallery-masonry__item projects-masonry__item <?php echo esc_attr( $col_class ); ?> __js_masonry-item <?php echo esc_attr( $categories_slugs_string ); ?>">
  <a class="card card--small card--masonry" href="<?php echo esc_url( $full_image ); ?>" data-elementor-lightbox-slideshow="gallery-grid" data-elementor-lightbox-title="<?php echo esc_attr( $title ); ?>">
    <?php if ( $image ) : ?>
    <div class="card__image<?php if ( $layout == 'masonry' ) : ?> card__image-m<?php endif; ?><?php if ( $size == 1 ) : ?> card__image-v<?php endif; ?><?php if ( $size == 2 ) : ?> card__image-h<?php endif; ?>">
      <img src="<?php echo esc_url( $image ); ?>" alt="<?php echo esc_attr( $title ); ?>" />
    </div>
    <?php endif; ?>
    <div class="card__content">
      <span class="zoom">
				<i class="fas fa-plus"></i>
			</span>
    </div>
  </a>
</li>
