<?php
/**
 * Template part for displaying posts
 *
 * @link https://developer.wordpress.org/themes/basics/template-hierarchy/
 *
 * @package larson
 */

?>

<?php

$container = get_query_var( 'container' );
$layout = get_query_var( 'layout' );

/* post content */
$current_categories = get_the_terms( get_the_ID(), 'portfolio_categories' );
$categories_slugs_string = '';
if ( $current_categories && ! is_wp_error( $current_categories ) ) {
	foreach ( $current_categories as $key => $value ) {
		$categories_slugs_string .= '__js_' . $value->slug . ' ';
	}
}

$image = get_the_post_thumbnail_url( get_the_ID(), 'larson_900x900' );
$title = get_the_title();
$href = get_the_permalink();
$short = get_field( 'short' );
$size = false;

$col_class = 'col-12 col-md-6 col-xl-4';

if ( $container == 'fullwidth' ) {
	$col_class = 'col-12 col-md-6 col-xl-3';
}
if ( $layout == 'masonry' ) {
	$size = get_field( 'size' );

	if ( $size == 1 ) {
		$image = get_the_post_thumbnail_url( get_the_ID(), 'larson_900xAuto' );
	} 
	if ( $size == 2 ) {
		$image = get_the_post_thumbnail_url( get_the_ID(), 'larson_900xAuto' );
		$col_class = 'col-12 col-xl-8';

		if ( $container == 'fullwidth' ) {
			$col_class = 'col-12 col-xl-6';
		}
	}
}

?>

<li class="projects-masonry__item <?php echo esc_attr( $col_class ); ?> __js_masonry-item <?php echo esc_attr( $categories_slugs_string ); ?>">
  <a class="card card--small card--masonry" href="<?php echo esc_url( $href ); ?>">
    <?php if ( $image ) : ?>
    <div class="card__image<?php if ( $layout == 'masonry' ) : ?> card__image-m<?php endif; ?><?php if ( $size == 1 ) : ?> card__image-v<?php endif; ?><?php if ( $size == 2 ) : ?> card__image-h<?php endif; ?>">
      <img src="<?php echo esc_url( $image ); ?>" alt="<?php echo esc_attr( $title ); ?>" />
    </div>
    <?php endif; ?>
    <div class="card__content">
      <?php if ( $title ) : ?>
      <h3 class="card__heading">
      	<?php echo esc_html( $title ); ?>
      </h3>
      <?php endif; ?>
      <?php if ( $short ) : ?>
      <div class="card__text">
      	<?php echo wp_kses_post( $short ); ?>
      </div>
      <?php endif; ?>
      <div class="card__bottom">
        <span class="card__link">
          <?php echo esc_html__( 'See project', 'larson' ); ?>
          <svg width="20" height="20">
            <use xlink:href="#chevron-right"></use>
          </svg>
        </span>
      </div>
    </div>
  </a>
</li>