<?php
/**
 * The template for displaying 404 pages (not found)
 *
 * @link https://codex.wordpress.org/Creating_an_Error_404_Page
 *
 * @package larson
 */

get_header();
?>

<?php 

$title = get_field( 'p404_title', 'option' );
$content = get_field( 'p404_content', 'option' );

?>

<article class="page-404">
	<div class="container page-404__container">
	  <div class="page-404__num"><?php echo esc_html__( '404', 'larson' ); ?></div>
	  <?php if ( $title ) : ?>
	  <div class="page-404__title"><?php echo wp_kses_post( $title ); ?></div>
	  <?php else : ?>
	  <div class="page-404__title"><?php esc_html__( 'Opps! Page Not Found', 'larson' ); ?></div>
	  <?php endif; ?>
	  <div class="page-404__text">
	  	<?php if ( $content ) : ?>
	  		<?php echo wp_kses_post( $content ); ?>
	  	<?php else : ?>
	  		<?php esc_html__( 'It seems we can\'t find what you\'re looking for. Perhaps searching can help or go back to', 'larson' ); ?>
	  	<?php endif; ?>
	    <br>
	    <a href="<?php echo esc_url( home_url() ); ?>"><?php echo esc_html__( 'Homepage', 'larson' ); ?></a>
	  </div>
	  <form method="get" action="<?php echo esc_url( home_url( '/' ) ); ?>">	
	  	<input class="page-404__search" type="search" value="<?php echo esc_attr( get_search_query() ); ?>" name="s" placeholder="<?php echo esc_attr__( 'Search', 'larson' ); ?>" />
	  </form>
	</div>
</article>

<?php
get_footer();