<?php
/**
 * The template for displaying the footer
 *
 * Contains the closing of the #content div and all content after.
 *
 * @link https://developer.wordpress.org/themes/basics/template-files/#template-partials
 *
 * @package larson
 */

?>
	
	<?php

	$hide_footer = get_field( 'hide_footer' );
	$footer_layout = get_field( 'footer_layout', 'option' );
	$page_template = get_page_template_slug();
	$coming_soon = false; 

	if ( $page_template == 'template-elementor-parallax.php' ) {
		$footer_classes = 'footer--lite footer--white footer--fixed';
	} else {
		$footer_classes = '__js_fixed-footer';
	}

	if ( $page_template == 'template-elementor-coming-soon.php' ) {
		$coming_soon = true; 
	}
	
	if ( is_404() ) {
		$hide_footer = 1;
	}

	if ( ! $coming_soon ) :
	?>

	</main>

	<?php if ( ! $hide_footer ) : ?>
	<footer class="footer <?php echo esc_attr( $footer_classes );?>">
		<?php if ( ! $footer_layout ) :
			get_template_part( 'template-elements/footer', 'default' );
		else :
			get_template_part( 'template-elements/footer', 'builder' );
		endif; ?>
	</footer>
	<?php endif; ?>
	    
	</div>

	<?php endif; ?>
	
	<?php wp_footer(); ?>

</body>
</html>