<?php
if ( class_exists( 'LarsonPlugin' ) && class_exists( 'OCDI_Plugin' ) && class_exists( 'ACF' ) ) {

function larson_ocdi_import_files() {
    return array(
        array(
            'import_file_name'             => esc_attr__( 'Default', 'larson' ),
            'categories'                   => array( esc_attr__( 'Main', 'larson' ) ),
            'import_file_url'              => LARSON_EXTRA_PLUGINS_DIRECTORY . '/normal/ocdi-import/demo/01/content.xml',
            'preview_url'                  => esc_url( 'https://bslthemes.com/larson/intro/' ),
        ),
    );
}
add_filter( 'pt-ocdi/import_files', 'larson_ocdi_import_files' );

function larson_ocdi_after_import_setup( $selected_import ) {
    
    $front_page_id = get_page_by_title( 'Home (Default)' );
    $main_menu = get_term_by( 'name', 'Header Menu', 'nav_menu' );

    set_theme_mod( 'nav_menu_locations', array(
        'primary' => $main_menu->term_id,
    ) );

    update_option( 'show_on_front', 'page' );
    update_option( 'page_on_front', $front_page_id->ID );
    update_option( 'posts_per_page', 6 );

    $ocdi_fields_static = array(
        'options_header_layout' => '1',
        '_options_header_layout' => 'field_6047f336daec0',
        'options_footer_layout' => '1',
        '_options_footer_layout' => 'field_6047f44e06120',
        'options_social_links' => '4',
        '_options_social_links' => 'field_5b68ccabc1b63',
        'options_blog_title' => '',
        '_options_blog_title' => 'field_5e5e39b87f0e0',
        'options_post_page' => '',
        '_options_post_page' => 'field_5d29eb446dca9',
        'options_blog_categories' => '1',
        '_options_blog_categories' => 'field_5b81b6d930cb9',
        'options_blog_excerpt' => '0',
        '_options_blog_excerpt' => 'field_5b81b7ca30cba',
        'options_social_share' => 'a:5:{i:0;s:8:""facebook"";i:1;s:7:""twitter"";i:2;s:8:""linkedin"";i:3;s:6:""reddit"";i:4;s:9:""pinterest"";}',
        '_options_social_share' => 'field_5c610c399cf20',
        'options_portfolio_page' => '',
        '_options_portfolio_page' => 'field_5d29e1a48ac41',
        'options_p404_content' => 'It seems we can\'t find what you\'re looking for. Perhaps searching can help or go back to',
        '_options_p404_content' => 'field_5d180feb59b80',
        'options_disable_preloader' => '0',
        '_options_disable_preloader' => 'field_5e7d27a0e322a',
        'options_preloader_color' => '',
        '_options_preloader_color' => 'field_608c707f85717',
        'options_header_template' => '660',
        '_options_header_template' => 'field_6047f4160611f',
        'options_social_links_0_icon' => 'fab fa-facebook-f',
        '_options_social_links_0_icon' => 'field_5eadbff631a92',
        'options_social_links_0_name' => 'Facebook',
        '_options_social_links_0_name' => 'field_5ef614b63614e',
        'options_social_links_0_url' => 'https://facebook.com/',
        '_options_social_links_0_url' => 'field_5b68ccd7c1b65',
        'options_social_links_1_icon' => 'fab fa-twitter',
        '_options_social_links_1_icon' => 'field_5eadbff631a92',
        'options_social_links_1_name' => 'Twitter',
        '_options_social_links_1_name' => 'field_5ef614b63614e',
        'options_social_links_1_url' => 'https://twitter.com/',
        '_options_social_links_1_url' => 'field_5b68ccd7c1b65',
        'options_social_links_2_icon' => 'fab fa-youtube',
        '_options_social_links_2_icon' => 'field_5eadbff631a92',
        'options_social_links_2_name' => 'Youtube',
        '_options_social_links_2_name' => 'field_5ef614b63614e',
        'options_social_links_2_url' => 'https://youtube.com/',
        '_options_social_links_2_url' => 'field_5b68ccd7c1b65',
        'options_social_links_3_icon' => 'fab fa-instagram',
        '_options_social_links_3_icon' => 'field_5eadbff631a92',
        'options_social_links_3_name' => 'Instagram',
        '_options_social_links_3_name' => 'field_5ef614b63614e',
        'options_social_links_3_url' => 'https://instagram.com/',
        '_options_social_links_3_url' => 'field_5b68ccd7c1b65',
        'options_footer_template' => '728',
        '_options_footer_template' => 'field_6047f46706121',
        'options_p404_title' => 'Opps! Page Not Found',
        '_options_p404_title' => 'field_610b183e86074',
        'options_single_type' => '0',
        '_options_single_type' => 'field_610c0463e614e',
        'options_mob_tel' => '+7 (212) 674-25-10',
        '_options_mob_tel' => 'field_610d7154e0d7b',
        'options_mob_tel_url' => 'tel:+72126742510',
        '_options_mob_tel_url' => 'field_610d7166e0d7c',
        'options_mob_copy' => '© 2021 <strong>Larson.</strong> All Rights Reserved.
        Development by <strong>Paul Studio</strong>',
        '_options_mob_copy' => 'field_610d716ee0d7d',
    );
    $ocdi_fields_to_change = array();

    if( 'Default' === $selected_import['import_file_name'] ) {
        $ocdi_fields_to_change = array(
            'options_theme_ui' => '0',
            '_options_theme_ui' => 'field_607dcd3956c17',
            'options_base_bg_color' => '',
            '_options_base_bg_color' => 'field_5b68d509665d9',
            'options_text_color' => '',
            '_options_text_color' => 'field_60672b1d6115f',
            'options_theme_color' => '',
            '_options_theme_color' => 'field_60672bee61163',
            'options_base_font_size' => '',
            '_options_base_font_size' => 'field_60672c8261165',
            'options_heading_font_size' => '',
            '_options_heading_font_size' => 'field_60672cef61168',
            'options_post_heading_font_size' => '',
            '_options_post_heading_font_size' => 'field_60672d3361169',
            'options_text_font_family' => '0',
            '_options_text_font_family' => 'field_5b68d188906fd',
            'options_primary_font_family' => '0',
            '_options_primary_font_family' => 'field_5b68cfc4906fc',
        );
    }

    global $wpdb;
    foreach ( array_merge( $ocdi_fields_static, $ocdi_fields_to_change ) as $field => $value ) {
        if ( $wpdb->get_var( $wpdb->prepare( "SELECT COUNT(*) FROM $wpdb->options WHERE option_name = %s", $field ) ) == 0 ) {
            $wpdb->query( $wpdb->prepare( "INSERT INTO $wpdb->options ( option_name, option_value, autoload ) VALUES (%s, %s, 'no')", $field, $value ) );
        } else {
            $wpdb->query( $wpdb->prepare( "UPDATE $wpdb->options SET option_value = %s WHERE option_name = %s", $value, $field ) );
        }
    }

}
add_action( 'pt-ocdi/after_import', 'larson_ocdi_after_import_setup' );

}
