<?php
/**
 * The template for displaying all single posts
 *
 * @link https://developer.wordpress.org/themes/basics/template-hierarchy/#single-post
 *
 * @package larson
 */

get_header();
?>

	<?php while ( have_posts() ) : the_post(); 

	//image
	$image = get_the_post_thumbnail_url( get_the_ID(), 'larson_1920xauto' );
	$title = get_the_title();
	$single_type = get_field( 'single_type', 'option' );

	?>

	<article class="article article--news<?php if ( $single_type == 1 ) : ?> article--p0 post-sb-page<?php endif; ?>">
		<?php if ( ! $single_type ) : ?>
		<header class="article__header">
          <div class="container">
            <?php larson_post_categories(); ?>
            <h1 class="article__heading heading heading--size-large"><?php the_title(); ?></h1>
          </div>
        </header>
        <?php endif; ?>
		<div class="post-sb-page__main-pic<?php if ( $single_type == 1 ) : ?> post-sb-page__main-pic--inner<?php endif; ?><?php if ( ! $image ) : ?> post-sb-page__no-main-pic<?php endif; ?>">
		  <?php if ( $image ) : ?>
		  <img src="<?php echo esc_url( $image ); ?>" alt="<?php echo esc_attr( $title ); ?>" />
		  <?php endif; ?>

		  <?php if ( $single_type == 1 ) : ?>
		  <div class="post-sb-page__title">
		  	<!-- Categories -->
			<?php larson_post_categories(); ?>
		    
		    <h1 class="post-sb-page__heading">
		      <?php the_title(); ?>
		    </h1>
		  </div>
		  <?php endif; ?>
		</div>
		<div class="post-sb-page__wrapper">
		  <!-- Post-->
		  <section class="post-sb post-sb--full">
		    <div class="article__main article__main--width-small container">
		      <div class="post-sb__wrapper">
		        <div class="post-sb__content">
		          <div class="post-sb__date">
		          	<!-- Details -->
		            <?php larson_post_details(); ?>
		          </div>

		          <div class="post-sb__text">
		          	<!-- Content -->
					<?php 
						get_template_part( 'template-parts/content', 'single' ); 
						wp_link_pages( array(
							'before' => '<div class="page-links">' . esc_html__( 'Pages:', 'larson' ),
							'after'  => '</div>',
						) );
					?>
					<!-- /content -->
		          </div>

		          <div class="post-sb__bottom">
		          	<!-- Tags -->
		            <?php larson_post_tags(); ?>

		            <!-- Social-->
		            <?php larson_post_social(); ?>
							         	
		            <!-- Navigation -->
		            <?php larson_post_navigation(); ?>
		          </div>
		        </div>
		      </div>
		    </div>

		    <?php if ( comments_open() || get_comments_number() ) :
				comments_template();
			endif; ?>

		  </section>
		</div>
	</article>
	
	<?php endwhile; ?>

<?php
get_footer();