<?php
/**
 * Builder template for header
 *
 * @package larson
 */

?>

<?php
	$social_links = get_field( 'social_links', 'option' );
	$social_links_type = get_field( 'social_links_type', 'option' );

  $mob_tel = get_field( 'mob_tel', 'option' );
  $mob_tel_url = get_field( 'mob_tel_url', 'option' );
  $mob_copy = get_field( 'mob_copy', 'option' );
  $mob_lang = get_field( 'mob_lang', 'option' );
?>

<!-- Site menu-->
<div class="mobile-canvas __js_mobile-canvas">
  <button class="mobile-canvas__close" type="button">
    <svg width="24" height="24">
      <use xlink:href="#close"></use>
    </svg>
    <span class="visually-hidden"><?php echo esc_html__( 'Close menu', 'larson' ); ?></span>
  </button>

  <?php if ( $mob_lang ) : echo wp_kses_post( $mob_lang ); endif; ?>

  <nav class="mobile-canvas__nav mobile-canvas__nav-h navigation"></nav>

  <div class="mobile-canvas__bottom">
    <?php if ( $mob_tel ) : ?>
    <a class="mobile-canvas__phone" href="<?php echo esc_url( $mob_tel_url ); ?>"><?php echo esc_html( $mob_tel ); ?></a>
    <?php endif; ?>

    <?php if ( $mob_copy ) : ?>
    <div class="mobile-canvas__copy">
      <?php echo wp_kses_post( $mob_copy ); ?>
    </div>
    <?php endif; ?>

    <?php if ( $social_links ) : ?>
    <!-- Social-->
    <ul class="mobile-canvas__social social">
      <?php foreach ( $social_links as $link ) : ?>
      <li class="social__item">
        <a class="social__link" href="<?php echo esc_url( $link['url'] ); ?>" target="_blank" title="<?php echo esc_attr( $link['name'] ); ?>">
        	<?php echo wp_kses_post( $link['icon'] ); ?>
        </a>
      </li>
      <?php endforeach; ?>
    </ul>
    <?php endif; ?>
	
  </div>
</div>