<?php
/**
 * Template part for displaying posts
 *
 * @link https://developer.wordpress.org/themes/basics/template-hierarchy/
 *
 * @package larson
 */

?>

<?php

/* post content */

$image = get_the_post_thumbnail_url( get_the_ID(), 'larson_1920xAuto' );
$title = get_the_title();
$href = get_the_permalink();
$short = get_field( 'short' );
$size = get_field( 'size' );

$cols = 'col-lg-4';

if ( $size == 2 ) :
	$cols = 'col-lg-8';
endif;

?>

<div class="featured-projects__item col-12 <?php echo esc_attr( $cols ); ?> __js_masonry-item" data-aos="fade">
  <div class="preview-card" tabindex="0">
    <?php if ( $image ) : ?>
    <div class="preview-card__image preview-card__image-s-<?php echo esc_attr( $size ); ?>">
      <img src="<?php echo esc_url( $image ); ?>" alt="<?php echo esc_attr( $title ); ?>" />
    </div>
    <?php endif; ?>
    <div class="preview-card__content">
      <h3 class="preview-card__heading preview-card__heading--large">
      	<?php echo esc_html( $title ); ?>
      </h3>
      <div class="preview-card__text">
      	<?php echo wp_kses_post( $short ); ?>
      </div>
      <a class="preview-card__btn" href="<?php echo esc_url( $href ); ?>"><?php echo esc_html__( 'See project', 'larson' ); ?></a>
    </div>
  </div>
</div>