<?php
/**
 * Template part for displaying posts
 *
 * @link https://developer.wordpress.org/themes/basics/template-hierarchy/
 *
 * @package larson
 */

?>

<?php

//options
$blog_excerpt = get_field( 'blog_excerpt', 'option' );

//content
$image = get_the_post_thumbnail_url( get_the_ID(), 'larson_1920xAuto' );

$container = get_query_var( 'container' );

$col_class = 'col-12 col-md-6 col-xl-4';

if ( $container == 'fullwidth' ) {
  $col_class = 'col-12 col-md-6 col-xl-3';
}

$categories_list = get_the_category( get_the_ID() );
$categories_slugs_string = '';
if ( $categories_list ) {
  foreach ( $categories_list as $category ) {
    $categories_slugs_string .= '__js_' . $category->slug . ' ';
  }
}

?>

<li id="post-<?php the_ID(); ?>" <?php post_class( 'news-listing__item news-listing__item--high ' . $col_class . ' __js_masonry-item ' . $categories_slugs_string ); ?>>
  <div class="card card--small card--masonry card--news">
    <?php if ( $image ) : ?>
    <div class="card__image">
      <img src="<?php echo esc_url( $image ); ?>" alt="<?php echo esc_attr( get_the_title() ); ?>" />
    </div>
    <?php endif; ?>
    <div class="card__content card__content--full">
      <div class="card__date"><?php echo esc_html( get_the_date() ); ?></div>
      <h3 class="card__heading"><a href="<?php echo esc_url( get_permalink() ); ?>"><?php the_title(); ?></a></h3>
      <?php if ( ! $blog_excerpt ) : ?>
      <div class="card__text"><?php the_excerpt(); ?></div>
      <?php endif; ?>
      <div class="card__bottom">
        <a class="card__link" href="<?php echo esc_url( get_permalink() ); ?>">
          <?php echo esc_html__( 'Learn more', 'larson' ); ?>
          <svg width="20" height="20">
            <use xlink:href="#chevron-right"></use>
          </svg>
        </a>
      </div>
    </div>
  </div>
</li><!-- #post-<?php the_ID(); ?> -->